/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.ecore;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.emfstore.common.model.ESModelElementId;
import org.eclipse.emf.emfstore.common.model.ESSingletonIdResolver;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;

public class ETypeIdResolver
implements ESSingletonIdResolver {
    private Map<String, EClass> datatypes = new LinkedHashMap<String, EClass>();

    public ETypeIdResolver() {
        this.datatypes.put("EClass", EcorePackage.eINSTANCE.getEClass());
        this.datatypes.put("EStructuralFeature", EcorePackage.eINSTANCE.getEStructuralFeature());
    }

    public EObject getSingleton(ESModelElementId singletonId) {
        if (singletonId == null) {
            return null;
        }
        return (EObject)this.datatypes.get(singletonId.getId());
    }

    public ESModelElementId getSingletonModelElementId(EObject singleton) {
        if (!(singleton instanceof EClass) && !EStructuralFeature.class.isInstance(singleton) || singleton == null) {
            return null;
        }
        for (Map.Entry<String, EClass> entry : this.datatypes.entrySet()) {
            if (!entry.getValue().isInstance((Object)singleton)) continue;
            ModelElementId id = ModelFactory.eINSTANCE.createModelElementId();
            id.setId(entry.getKey());
            return (ESModelElementId)id.toAPI();
        }
        return null;
    }

    public boolean isSingleton(EObject eDataType) {
        return EClass.class.isInstance(eDataType) || EStructuralFeature.class.isInstance(eDataType);
    }
}

