/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UnsetType implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    IS_UNSET(1, "IS_UNSET", "IS_UNSET"),
    WAS_UNSET(2, "WAS_UNSET", "");

    public static final int NONE_VALUE = 0;
    public static final int IS_UNSET_VALUE = 1;
    public static final int WAS_UNSET_VALUE = 2;
    private static final UnsetType[] VALUES_ARRAY;
    public static final List<UnsetType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnsetType[]{NONE, IS_UNSET, WAS_UNSET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnsetType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnsetType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnsetType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnsetType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnsetType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return IS_UNSET;
            }
            case 2: {
                return WAS_UNSET;
            }
        }
        return null;
    }

    private UnsetType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

