/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs;

import java.util.List;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchSelectionDialog
extends TitleAreaDialog {
    private final List<BranchInfo> branches;
    private TableViewer tableViewer;
    private BranchInfo result;

    public BranchSelectionDialog(Shell parentShell, List<BranchInfo> branches) {
        super(parentShell);
        this.branches = branches;
    }

    protected Control createDialogArea(Composite parent) {
        this.setHeaderTexts();
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.addCreationField(container);
        this.setTableViewer(new TableViewer(container, 2560));
        Table list = this.getTableViewer().getTable();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.getTableViewer().setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof BranchInfo) {
                    BranchInfo branch = (BranchInfo)element;
                    StyledString styledString = new StyledString("Branch:  " + branch.getName() + "  ", StyledString.createColorRegistryStyler((String)"red", null));
                    styledString.append("[Version: " + branch.getHead().getIdentifier() + "]", StyledString.DECORATIONS_STYLER);
                    cell.setText(styledString.toString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                }
                super.update(cell);
            }
        });
        this.getTableViewer().setInput(this.getBranches());
        this.endOfInit();
        return area;
    }

    protected void endOfInit() {
    }

    protected void okPressed() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setResult((BranchInfo)((IStructuredSelection)selection).getFirstElement());
        }
        super.okPressed();
    }

    public BranchInfo getResult() {
        return this.result;
    }

    protected void setHeaderTexts() {
        this.getShell().setText("Branch Selection");
        this.setTitle("Branch Selection");
        this.setMessage("Please select which Branch you want to merge into your local copy of the project.");
    }

    protected void addCreationField(Composite container) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(400, 350);
    }

    protected List<BranchInfo> getBranches() {
        return this.branches;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    protected void setResult(BranchInfo result) {
        this.result = result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckoutSelection
    extends BranchSelectionDialog {
        public CheckoutSelection(Shell parentShell, List<BranchInfo> branches) {
            super(parentShell, branches);
        }

        @Override
        protected void setHeaderTexts() {
            this.getShell().setText("Checkout Branch");
            this.setTitle("Checkout Branch");
            this.setMessage("Please choose which Branch should be checked out.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Creation
    extends BranchSelectionDialog {
        private Text text;
        private String newName = "";

        public Creation(Shell parentShell, List<BranchInfo> branches) {
            super(parentShell, branches);
        }

        @Override
        protected void setHeaderTexts() {
            this.getShell().setText("Create Branch");
            this.setTitle("Create Branch");
            this.setMessage("Please specify a name for the new Branch.");
        }

        public String getNewBranch() {
            return this.newName;
        }

        @Override
        protected void endOfInit() {
            this.getTableViewer().getTable().setEnabled(false);
            this.getTableViewer().getTable().setBackground(Display.getCurrent().getSystemColor(15));
        }

        @Override
        protected void okPressed() {
            if (this.text != null) {
                this.newName = this.text.getText();
            }
            super.okPressed();
        }

        @Override
        protected void addCreationField(Composite container) {
            Composite creationContainer = new Composite(container, 0);
            creationContainer.setLayout((Layout)new GridLayout(2, false));
            creationContainer.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            Label lblNewBranch = new Label(creationContainer, 0);
            lblNewBranch.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblNewBranch.setText("New Branch:");
            this.text = new Text(creationContainer, 2048);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
    }
}

