/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.callbacks.ESCommitCallback;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.client.handler.ESRunnableContext;
import org.eclipse.emf.emfstore.client.observer.ESLoginObserver;
import org.eclipse.emf.emfstore.client.observer.ESMergeObserver;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportChangesController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportProjectController;
import org.eclipse.emf.emfstore.internal.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.EMFStoreCommandStack;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.ConflictResolver;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.controller.CommitController;
import org.eclipse.emf.emfstore.internal.client.model.controller.ShareController;
import org.eclipse.emf.emfstore.internal.client.model.controller.UpdateController;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.IllegalProjectSpaceStateException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.MEUrlResolutionException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.PropertyNotFoundException;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileDownloadStatus;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileInformation;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.ApplyOperationsRunnable;
import org.eclipse.emf.emfstore.internal.client.model.impl.DefaultRunnableContext;
import org.eclipse.emf.emfstore.internal.client.model.impl.ESLocalProjectSaveStateNotifier;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.ResourcePersister;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.observers.DeleteProjectSpaceObserver;
import org.eclipse.emf.emfstore.internal.client.properties.PropertyManager;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdentifiableElementImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.internal.server.model.url.ModelElementUrlFragment;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectSpaceBase
extends IdentifiableElementImpl
implements ProjectSpace,
ESLoginObserver,
ESDisposable {
    private ESLocalProjectImpl esLocalProjectImpl;
    private boolean initCompleted;
    private boolean isTransient;
    private boolean disposed;
    private FileTransferManager fileTransferManager;
    private OperationManager operationManager;
    private PropertyManager propertyManager;
    private Map<String, OrgUnitProperty> propertyMap = new LinkedHashMap<String, OrgUnitProperty>();
    private ResourceSet resourceSet;
    private ResourcePersister resourcePersister;
    private ECrossReferenceAdapter crossReferenceAdapter;
    private ESRunnableContext runnableContext;

    public ProjectSpaceBase() {
        this.initRunnableContext();
    }

    private void initRunnableContext() {
        this.setRunnableContext((ESRunnableContext)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.client.runnableContext", ESRunnableContext.class, (Object)new DefaultRunnableContext(), true));
    }

    @Override
    public FileIdentifier addFile(File file) throws FileTransferException {
        return this.fileTransferManager.addFile(file);
    }

    @Override
    public void addOperations(List<? extends AbstractOperation> operations) {
        this.getOperations().addAll(operations);
        this.updateDirtyState();
        for (AbstractOperation abstractOperation : operations) {
            this.operationManager.notifyOperationExecuted(abstractOperation);
        }
    }

    @Override
    public void addTag(PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        ConnectionManager cm = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        cm.addTag(this.getUsersession().getSessionId(), this.getProjectId(), versionSpec, tag);
    }

    public void applyChanges(PrimaryVersionSpec baseSpec, List<ChangePackage> incoming, ChangePackage myChanges, IProgressMonitor progressMonitor, boolean runChecksumTestOnBaseSpec) throws ESException {
        this.notifyPreRevertMyChanges(this.getLocalChangePackage());
        this.revert();
        this.notifyPostRevertMyChanges();
        this.applyChangePackages(incoming, false);
        this.notifyPostApplyTheirChanges(incoming);
        if (runChecksumTestOnBaseSpec) {
            this.runChecksumTests(baseSpec, incoming, progressMonitor);
        }
        this.applyOperations((List<AbstractOperation>)myChanges.getOperations(), true);
        this.notifyPostApplyMergedChanges(myChanges);
        this.setBaseVersion(baseSpec);
        this.saveProjectSpaceOnly();
    }

    private void runChecksumTests(PrimaryVersionSpec baseSpec, List<ChangePackage> incoming, IProgressMonitor progressMonitor) throws ESException {
        progressMonitor.subTask("Computing checksum");
        if (!this.performChecksumCheck(baseSpec, this.getProject())) {
            progressMonitor.subTask("Invalid checksum.  Activating checksum error handler.");
            boolean errorHandled = Configuration.getClientBehavior().getChecksumErrorHandler().execute(this.toAPI(), (ESPrimaryVersionSpec)baseSpec.toAPI(), progressMonitor);
            if (!errorHandled) {
                int i = incoming.size() - 1;
                while (i >= 0) {
                    this.applyChangePackage(incoming.get(i).reverse(), false);
                    --i;
                }
                this.applyChangePackage(this.getLocalChangePackage(), true);
                throw new ESException("Update cancelled by checksum error handler due to invalid checksum.");
            }
        }
    }

    private void applyChangePackage(ChangePackage changePackage, boolean addOperations) {
        this.applyOperations((List<AbstractOperation>)changePackage.getOperations(), addOperations);
    }

    private void applyChangePackages(List<ChangePackage> changePackages, boolean addOperations) {
        for (ChangePackage changePackage : changePackages) {
            this.applyChangePackage(changePackage, addOperations);
        }
    }

    private boolean performChecksumCheck(PrimaryVersionSpec baseVersion, Project project) {
        if (Configuration.getClientBehavior().isChecksumCheckActive()) {
            long expectedChecksum = baseVersion.getProjectStateChecksum();
            try {
                long computedChecksum = ModelUtil.computeChecksum((IdEObjectCollection)project);
                return expectedChecksum == computedChecksum;
            }
            catch (SerializationException e) {
                WorkspaceUtil.logWarning("Could not compute checksum while applying changes.", (Exception)((Object)e));
            }
        }
        return true;
    }

    public void applyOperations(List<AbstractOperation> operations, boolean addOperations) {
        this.executeRunnable(new ApplyOperationsRunnable(this, operations, addOperations));
    }

    public void executeRunnable(Runnable runnable) {
        this.getRunnableContext().executeRunnable(runnable);
    }

    @Override
    public CompositeOperationHandle beginCompositeOperation() {
        return this.operationManager.beginCompositeOperation();
    }

    public void cleanCutElements() {
        ArrayList cutElements = new ArrayList(this.getProject().getCutElements());
        for (EObject cutElement : cutElements) {
            this.getProject().deleteModelElement(cutElement);
        }
    }

    @Override
    public PrimaryVersionSpec commit(IProgressMonitor monitor) throws ESException {
        return (PrimaryVersionSpec)new CommitController(this, null, null, monitor).execute();
    }

    @Override
    public PrimaryVersionSpec commit(String logMessage, ESCommitCallback callback, IProgressMonitor monitor) throws ESException {
        return (PrimaryVersionSpec)new CommitController(this, logMessage, callback, monitor).execute();
    }

    @Override
    public PrimaryVersionSpec commitToBranch(BranchVersionSpec branch, String logMessage, ESCommitCallback callback, IProgressMonitor monitor) throws ESException {
        return (PrimaryVersionSpec)new CommitController(this, branch, logMessage, callback, monitor).execute();
    }

    @Override
    public void exportLocalChanges(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportChangesController(this).execute(file, progressMonitor);
    }

    @Override
    public void exportLocalChanges(File file) throws IOException {
        new ExportChangesController(this).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void exportProject(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportProjectController(this).execute(file, progressMonitor);
    }

    @Override
    public void exportProject(File file) throws IOException {
        new ExportProjectController(this).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<ChangePackage> getChanges(VersionSpec sourceVersion, VersionSpec targetVersion) throws InvalidVersionSpecException, ESException {
        ConnectionManager connectionManager = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        List changes = connectionManager.getChanges(this.getUsersession().getSessionId(), this.getProjectId(), sourceVersion, targetVersion);
        return changes;
    }

    @Override
    public FileDownloadStatus getFile(FileIdentifier fileIdentifier) throws FileTransferException {
        return this.fileTransferManager.getFile(fileIdentifier);
    }

    @Override
    public FileInformation getFileInfo(FileIdentifier fileIdentifier) {
        return this.fileTransferManager.getFileInfo(fileIdentifier);
    }

    @Override
    public ChangePackage getLocalChangePackage(boolean canonize) {
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        for (AbstractOperation abstractOperation : this.getOperations()) {
            AbstractOperation copy = (AbstractOperation)ModelUtil.clone((EObject)abstractOperation);
            changePackage.getOperations().add((Object)copy);
        }
        LogMessage logMessage = VersioningFactory.eINSTANCE.createLogMessage();
        if (this.getUsersession() != null) {
            logMessage.setAuthor(this.getUsersession().getUsername());
        } else {
            logMessage.setAuthor("<Unkown>");
        }
        logMessage.setClientDate(new Date());
        changePackage.setLogMessage(logMessage);
        return changePackage;
    }

    public NotificationRecorder getNotificationRecorder() {
        return this.operationManager.getNotificationRecorder();
    }

    @Override
    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public List<AbstractOperation> getOperations() {
        ChangePackage localChangePackage = this.getLocalChangePackage();
        if (localChangePackage == null) {
            this.setLocalChangePackage(VersioningFactory.eINSTANCE.createChangePackage());
            localChangePackage = this.getLocalChangePackage();
        }
        return localChangePackage.getOperations();
    }

    @Override
    public ProjectInfo getProjectInfo() {
        ProjectInfo projectInfo = ModelFactory.eINSTANCE.createProjectInfo();
        projectInfo.setProjectId((ProjectId)ModelUtil.clone((EObject)this.getProjectId()));
        projectInfo.setName(this.getProjectName());
        projectInfo.setDescription(this.getProjectDescription());
        projectInfo.setVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)this.getBaseVersion()));
        return projectInfo;
    }

    @Override
    public PropertyManager getPropertyManager() {
        if (this.propertyManager == null) {
            this.propertyManager = new PropertyManager(this);
        }
        return this.propertyManager;
    }

    private OrgUnitProperty getProperty(String name) throws PropertyNotFoundException {
        OrgUnitProperty orgUnitProperty;
        if (this.getUsersession() != null && this.getUsersession().getACUser() != null && (orgUnitProperty = this.propertyMap.get(name)) != null) {
            return orgUnitProperty;
        }
        throw new PropertyNotFoundException();
    }

    @Override
    public void importLocalChanges(String fileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)fileName), true);
        EList directContents = resource.getContents();
        if (directContents.size() != 1 && !(directContents.get(0) instanceof ChangePackage)) {
            throw new IOException("File is corrupt, does not contain Changes.");
        }
        ChangePackage changePackage = (ChangePackage)directContents.get(0);
        if (!this.initCompleted) {
            this.init();
        }
        this.applyOperations((List<AbstractOperation>)changePackage.getOperations(), true);
    }

    @Override
    public void init() {
        this.initCrossReferenceAdapter();
        EMFStoreCommandStack commandStack = (EMFStoreCommandStack)ESWorkspaceProviderImpl.getInstance().getEditingDomain().getCommandStack();
        this.fileTransferManager = new FileTransferManager(this);
        this.operationManager = new OperationManager(this);
        this.initResourcePersister();
        commandStack.addCommandStackObserver(this.operationManager);
        commandStack.addCommandStackObserver(this.resourcePersister);
        this.getProject().addIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.operationManager);
        this.getProject().addIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.resourcePersister);
        if (this.getProject() instanceof ProjectImpl) {
            ((ProjectImpl)this.getProject()).setUndetachable((IdEObjectCollectionChangeObserver)this.operationManager);
            ((ProjectImpl)this.getProject()).setUndetachable((IdEObjectCollectionChangeObserver)this.resourcePersister);
        }
        this.initPropertyMap();
        this.startChangeRecording();
        this.cleanCutElements();
        this.initCompleted = true;
    }

    private void initPropertyMap() {
        if (this.getUsersession() != null) {
            ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this, new Class[]{ESLoginObserver.class});
            ACUser acUser = this.getUsersession().getACUser();
            if (acUser != null) {
                for (OrgUnitProperty p : acUser.getProperties()) {
                    if (p.getProject() == null || !p.getProject().equals(this.getProjectId())) continue;
                    this.propertyMap.put(p.getName(), p);
                }
            }
        }
    }

    private void initCrossReferenceAdapter() {
        boolean useCrossReferenceAdapter = true;
        for (ESExtensionElement element : new ESExtensionPoint("org.eclipse.emf.emfstore.client.inverseCrossReferenceCache").getExtensionElements()) {
            useCrossReferenceAdapter &= element.getBoolean("activated").booleanValue();
        }
        if (useCrossReferenceAdapter) {
            this.crossReferenceAdapter = new ECrossReferenceAdapter();
            this.getProject().eAdapters().add((Object)this.crossReferenceAdapter);
        }
    }

    private void initResourcePersister() {
        this.resourcePersister = new ResourcePersister((IdEObjectCollection)this.getProject());
        if (!this.isTransient) {
            this.resourcePersister.addResource(this.eResource());
            this.resourcePersister.addResource(this.getLocalChangePackage().eResource());
            this.resourcePersister.addResource(this.getProject().eResource());
            this.resourcePersister.addDirtyStateChangeLister(new ESLocalProjectSaveStateNotifier(this.toAPI()));
            ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.resourcePersister);
        }
    }

    public FileTransferManager getFileTransferManager() {
        return this.fileTransferManager;
    }

    @Override
    public void initResources(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.initCompleted = true;
        String projectSpaceFileNamePrefix = String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + Configuration.getFileInfo().getProjectSpaceDirectoryPrefix() + this.getIdentifier() + File.separatorChar;
        String projectSpaceFileName = String.valueOf(projectSpaceFileNamePrefix) + Configuration.getFileInfo().getProjectSpaceFileName() + Configuration.getFileInfo().getProjectSpaceFileExtension();
        String localChangePackageFileName = String.valueOf(projectSpaceFileNamePrefix) + Configuration.getFileInfo().getLocalChangePackageFileName() + Configuration.getFileInfo().getLocalChangePackageFileExtension();
        URI projectSpaceURI = URI.createFileURI((String)projectSpaceFileName);
        URI localChangePackageURI = URI.createFileURI((String)localChangePackageFileName);
        this.setResourceCount(0);
        String fileName = String.valueOf(projectSpaceFileNamePrefix) + Configuration.getFileInfo().getProjectFragmentFileName() + Configuration.getFileInfo().getProjectFragmentFileExtension();
        URI fileURI = URI.createFileURI((String)fileName);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)this.getProject());
        resources.add(resource);
        this.setResourceCount(this.getResourceCount() + 1);
        for (EObject modelElement : this.getProject().getAllModelElements()) {
            ((XMIResource)resource).setID(modelElement, this.getProject().getModelElementId(modelElement).getId());
        }
        Resource localChangePackageResource = resourceSet.createResource(localChangePackageURI);
        if (this.getLocalChangePackage() == null) {
            this.setLocalChangePackage(VersioningFactory.eINSTANCE.createChangePackage());
        }
        localChangePackageResource.getContents().add((Object)this.getLocalChangePackage());
        resources.add(localChangePackageResource);
        Resource projectSpaceResource = resourceSet.createResource(projectSpaceURI);
        projectSpaceResource.getContents().add((Object)this);
        resources.add(projectSpaceResource);
        for (Resource currentResource : resources) {
            try {
                ModelUtil.saveResource((Resource)currentResource, (IResourceLogger)WorkspaceUtil.getResourceLogger());
            }
            catch (IOException e) {
                WorkspaceUtil.logException("Project Space resource init failed!", e);
            }
        }
        this.init();
    }

    @Override
    public void delete(IProgressMonitor monitor) throws IOException {
        ((DeleteProjectSpaceObserver)ESWorkspaceProviderImpl.getObserverBus().notify(DeleteProjectSpaceObserver.class)).projectSpaceDeleted(this);
        this.getProject().delete();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()));
        Configuration.getFileInfo();
        String pathToProject = stringBuilder.append("ps-").append(this.getIdentifier()).toString();
        this.resourceSet.getResources().remove((Object)this.getProject().eResource());
        this.resourceSet.getResources().remove((Object)this.eResource());
        this.resourceSet.getResources().remove((Object)this.getLocalChangePackage().eResource());
        ESWorkspaceProviderImpl.getInstance().getInternalWorkspace().getProjectSpaces().remove((Object)this);
        this.dispose();
        this.deleteResource(this.getProject().eResource());
        this.deleteResource(this.eResource());
        this.deleteResource(this.getLocalChangePackage().eResource());
        FileUtil.deleteDirectory((File)new File(pathToProject), (boolean)true);
    }

    private void deleteResource(Resource resource) throws IOException {
        if (resource != null) {
            resource.delete(null);
        }
    }

    public Collection<EStructuralFeature.Setting> findInverseCrossReferences(EObject modelElement) {
        if (this.crossReferenceAdapter != null) {
            return this.crossReferenceAdapter.getInverseReferences(modelElement);
        }
        return EcoreUtil.UsageCrossReferencer.find((EObject)modelElement, (ResourceSet)this.resourceSet);
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean isUpdated() throws ESException {
        PrimaryVersionSpec headVersion = this.resolveVersionSpec((VersionSpec)Versions.createHEAD((VersionSpec)this.getBaseVersion()), (IProgressMonitor)new NullProgressMonitor());
        return this.getBaseVersion().equals(headVersion);
    }

    @Override
    public void loginCompleted(ESUsersession session) {
        if (this.getUsersession() == null || !((ESUsersessionImpl)this.getUsersession().toAPI()).equals(session)) {
            return;
        }
        try {
            this.transmitProperties();
        }
        catch (RuntimeException e) {
            WorkspaceUtil.logException("Resuming file transfers or transmitting properties failed!", e);
        }
    }

    @Override
    public void makeTransient() {
        if (this.initCompleted) {
            throw new IllegalAccessError("Project Space cannot be set to transient after init.");
        }
        this.isTransient = true;
    }

    @Override
    public void mergeBranch(final PrimaryVersionSpec branchSpec, ConflictResolver conflictResolver, final IProgressMonitor monitor) throws ESException {
        if (branchSpec == null || conflictResolver == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (Versions.isSameBranch((VersionSpec)this.getBaseVersion(), (VersionSpec)branchSpec)) {
            throw new InvalidVersionSpecException("Can't merge branch with itself.");
        }
        PrimaryVersionSpec commonAncestor = (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>((ProjectSpace)this){

            @Override
            protected PrimaryVersionSpec run() throws ESException {
                return ProjectSpaceBase.this.resolveVersionSpec((VersionSpec)Versions.createANCESTOR((PrimaryVersionSpec)ProjectSpaceBase.this.getBaseVersion(), (PrimaryVersionSpec)branchSpec), monitor);
            }
        }.execute();
        final List<ChangePackage> baseChanges = this.getChanges((VersionSpec)commonAncestor, (VersionSpec)this.getBaseVersion());
        List<ChangePackage> branchChanges = this.getChanges((VersionSpec)commonAncestor, (VersionSpec)branchSpec);
        ChangeConflictSet conflictSet = new ConflictDetector().calculateConflicts(branchChanges, baseChanges, this.getProject());
        if (conflictResolver.resolveConflicts(this.getProject(), conflictSet)) {
            final ChangePackage resolvedConflicts = this.mergeResolvedConflicts(conflictSet, branchChanges, baseChanges);
            RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProjectSpaceBase.this.applyChanges(ProjectSpaceBase.this.getBaseVersion(), baseChanges, resolvedConflicts, monitor, false);
                    ProjectSpaceBase.this.setMergedVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)branchSpec));
                    return null;
                }
            });
        }
    }

    @Override
    public ChangePackage mergeResolvedConflicts(ChangeConflictSet conflictSet, List<ChangePackage> myChangePackages, List<ChangePackage> theirChangePackages) throws ChangeConflictException {
        LinkedHashSet accceptedMineSet = new LinkedHashSet();
        LinkedHashSet rejectedTheirsSet = new LinkedHashSet();
        for (ConflictBucket conflict : conflictSet.getConflictBuckets()) {
            if (!conflict.isResolved()) {
                throw new ChangeConflictException("Conflict during update occured and callback failed to resolve all conflicts!", conflictSet);
            }
            accceptedMineSet.addAll(conflict.getAcceptedLocalOperations());
            rejectedTheirsSet.addAll(conflict.getRejectedRemoteOperations());
        }
        LinkedList<AbstractOperation> acceptedMineList = new LinkedList<AbstractOperation>();
        for (ChangePackage locChangePackage : myChangePackages) {
            for (AbstractOperation myOp : locChangePackage.getOperations()) {
                if (conflictSet.getNotInvolvedInConflict().contains(myOp)) {
                    acceptedMineList.add(myOp);
                } else if (accceptedMineSet.contains(myOp)) {
                    acceptedMineList.add(myOp);
                }
                accceptedMineSet.remove(myOp);
            }
        }
        accceptedMineSet.addAll(accceptedMineSet);
        LinkedList<AbstractOperation> rejectedTheirsList = new LinkedList<AbstractOperation>();
        for (ChangePackage theirCP : theirChangePackages) {
            for (AbstractOperation theirOp : theirCP.getOperations()) {
                if (!rejectedTheirsSet.contains(theirOp)) continue;
                rejectedTheirsList.add(theirOp);
            }
        }
        ArrayList<AbstractOperation> mergeResult = new ArrayList<AbstractOperation>(rejectedTheirsList.size() + acceptedMineList.size());
        for (AbstractOperation operationToReverse : rejectedTheirsList) {
            mergeResult.add(0, operationToReverse.reverse());
        }
        mergeResult.addAll(acceptedMineList);
        ChangePackage result = VersioningFactory.eINSTANCE.createChangePackage();
        result.getOperations().addAll(mergeResult);
        return result;
    }

    @Override
    public List<BranchInfo> getBranches() throws ESException {
        return (List)new ServerCall<List<BranchInfo>>((ProjectSpace)this){

            @Override
            protected List<BranchInfo> run() throws ESException {
                ConnectionManager cm = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
                return cm.getBranches(this.getSessionId(), ProjectSpaceBase.this.getProjectId());
            }
        }.execute();
    }

    @Override
    public void removeTag(PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        ConnectionManager cm = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        cm.removeTag(this.getUsersession().getSessionId(), this.getProjectId(), versionSpec, tag);
    }

    @Override
    public EObject resolve(ModelElementUrlFragment modelElementUrlFragment) throws MEUrlResolutionException {
        ModelElementId modelElementId = modelElementUrlFragment.getModelElementId();
        EObject modelElement = this.getProject().getModelElement(modelElementId);
        if (modelElement == null) {
            throw new MEUrlResolutionException();
        }
        return modelElement;
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(final VersionSpec versionSpec, IProgressMonitor monitor) throws InvalidVersionSpecException, ESException {
        return (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>((ProjectSpace)this, monitor){

            @Override
            protected PrimaryVersionSpec run() throws ESException {
                return this.getConnectionManager().resolveVersionSpec(this.getSessionId(), ProjectSpaceBase.this.getProjectId(), versionSpec);
            }
        }.execute();
    }

    @Override
    public void revert() {
        while (!this.getOperations().isEmpty()) {
            this.undoLastOperation();
        }
        this.updateDirtyState();
    }

    public void saveProjectSpaceOnly() {
        this.saveResource(this.eResource());
    }

    @Override
    public void save() {
        this.saveProjectSpaceOnly();
        this.saveChangePackage();
        this.resourcePersister.saveDirtyResources(true);
    }

    @Override
    public boolean hasUnsavedChanges() {
        if (this.resourcePersister != null) {
            return this.resourcePersister.isDirty();
        }
        return false;
    }

    private void saveChangePackage() {
        ChangePackage localChangePackage = this.getLocalChangePackage();
        if (localChangePackage.eResource() != null) {
            this.saveResource(localChangePackage.eResource());
        }
    }

    public void saveResource(Resource resource) {
        try {
            if (resource == null) {
                if (!this.isTransient) {
                    WorkspaceUtil.logException("Resources of project space are not properly initialized!", (Exception)((Object)new IllegalProjectSpaceStateException("Resource to save is null")));
                }
                return;
            }
            ModelUtil.saveResource((Resource)resource, (IResourceLogger)WorkspaceUtil.getResourceLogger());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("An error in the data was detected during save! The safest way to deal with this problem is to delete this project and checkout again.", e);
        }
    }

    @Override
    public void setProperty(OrgUnitProperty property) {
        if (this.getUsersession() != null && this.getUsersession().getACUser() != null) {
            try {
                if (property.getProject() == null) {
                    property.setProject((ProjectId)ModelUtil.clone((EObject)this.getProjectId()));
                } else if (!property.getProject().equals(this.getProjectId())) {
                    return;
                }
                OrgUnitProperty prop = this.getProperty(property.getName());
                prop.setValue(property.getValue());
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this.getUsersession().getACUser().getProperties().add((Object)property);
                this.propertyMap.put(property.getName(), property);
            }
            for (OrgUnitProperty changedProperty : this.getUsersession().getChangedProperties()) {
                if (!changedProperty.getName().equals(property.getName()) || !changedProperty.getProject().equals(this.getProjectId())) continue;
                changedProperty.setValue(property.getValue());
                ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).save();
                return;
            }
            this.getUsersession().getChangedProperties().add((Object)property);
            ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).save();
        }
    }

    @Override
    public ProjectInfo shareProject(IProgressMonitor monitor) throws ESException {
        return this.shareProject(null, monitor);
    }

    @Override
    public ProjectInfo shareProject(Usersession session, IProgressMonitor monitor) throws ESException {
        return (ProjectInfo)new ShareController(this, session, monitor).execute();
    }

    public void startChangeRecording() {
        this.operationManager.startChangeRecording();
        this.updateDirtyState();
    }

    public void stopChangeRecording() {
        if (this.operationManager != null) {
            this.operationManager.stopChangeRecording();
        }
    }

    @Override
    public void transmitProperties() {
        ArrayList<OrgUnitProperty> temp = new ArrayList<OrgUnitProperty>();
        for (OrgUnitProperty changedProperty : this.getUsersession().getChangedProperties()) {
            if (changedProperty.getProject() == null || !changedProperty.getProject().equals(this.getProjectId())) continue;
            temp.add(changedProperty);
        }
        ListIterator iterator = temp.listIterator();
        while (iterator.hasNext()) {
            try {
                ESWorkspaceProviderImpl.getInstance().getConnectionManager().transmitProperty(this.getUsersession().getSessionId(), (OrgUnitProperty)iterator.next(), this.getUsersession().getACUser(), this.getProjectId());
                iterator.remove();
            }
            catch (ESException e) {
                WorkspaceUtil.logException("Transmission of properties failed with exception", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void undoLastOperation() {
        this.undoLastOperations(1);
    }

    @Override
    public void undoLastOperations(int numberOfOperations) {
        if (numberOfOperations <= 0) {
            return;
        }
        if (!this.getOperations().isEmpty()) {
            List<AbstractOperation> operations = this.getOperations();
            AbstractOperation lastOperation = operations.get(operations.size() - 1);
            this.applyOperations(Collections.singletonList(lastOperation.reverse()), false);
            this.operationManager.notifyOperationUndone(lastOperation);
            operations.remove(lastOperation);
            this.undoLastOperations(--numberOfOperations);
        }
        this.updateDirtyState();
    }

    @Override
    public PrimaryVersionSpec update(IProgressMonitor monitor) throws ESException {
        return this.update((VersionSpec)Versions.createHEAD((VersionSpec)this.getBaseVersion()), null, monitor);
    }

    @Override
    public PrimaryVersionSpec update(VersionSpec version) throws ESException {
        return this.update(version, null, null);
    }

    @Override
    public PrimaryVersionSpec update(VersionSpec version, ESUpdateCallback callback, IProgressMonitor progress) throws ESException {
        return (PrimaryVersionSpec)new UpdateController(this, version, callback, progress).execute();
    }

    public void updateDirtyState() {
        this.setDirty(!this.getOperations().isEmpty());
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.stopChangeRecording();
        if (this.crossReferenceAdapter != null) {
            this.getProject().eAdapters().remove((Object)this.crossReferenceAdapter);
        }
        EMFStoreCommandStack commandStack = (EMFStoreCommandStack)ESWorkspaceProviderImpl.getInstance().getEditingDomain().getCommandStack();
        commandStack.removeCommandStackObserver(this.operationManager);
        commandStack.removeCommandStackObserver(this.resourcePersister);
        this.getProject().removeIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.operationManager);
        this.getProject().removeIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.resourcePersister);
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this.resourcePersister);
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this, new Class[]{ESLoginObserver.class});
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this);
        this.operationManager.dispose();
        this.resourcePersister.dispose();
        this.disposed = true;
    }

    @Override
    public boolean isShared() {
        return this.getUsersession() != null;
    }

    private void notifyPreRevertMyChanges(ChangePackage changePackage) {
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).preRevertMyChanges(this.toAPI(), (ESChangePackage)changePackage.toAPI());
    }

    private void notifyPostRevertMyChanges() {
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).postRevertMyChanges(this.toAPI());
    }

    private void notifyPostApplyTheirChanges(List<ChangePackage> theirChangePackages) {
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).postApplyTheirChanges(this.toAPI(), APIUtil.mapToAPI(ESChangePackage.class, theirChangePackages));
    }

    private void notifyPostApplyMergedChanges(ChangePackage changePackage) {
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).postApplyMergedChanges(this.toAPI(), (ESChangePackage)changePackage.toAPI());
    }

    public ESLocalProjectImpl toAPI() {
        if (this.esLocalProjectImpl == null) {
            this.esLocalProjectImpl = this.createAPI();
        }
        return this.esLocalProjectImpl;
    }

    public ESLocalProjectImpl createAPI() {
        return new ESLocalProjectImpl(this);
    }

    public ESRunnableContext getRunnableContext() {
        return this.runnableContext;
    }

    public void setRunnableContext(ESRunnableContext runnableContext) {
        this.runnableContext = runnableContext;
    }
}

