/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl.api;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.observer.ESCheckoutObserver;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.Messages;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ServerAdmin;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.query.ESHistoryQueryImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESPrimaryVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESTagVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESBranchInfo;
import org.eclipse.emf.emfstore.server.model.ESGlobalProjectId;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.emf.emfstore.server.model.query.ESHistoryQuery;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESTagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESRemoteProjectImpl
implements ESRemoteProject {
    private final ProjectInfo projectInfo;
    private final ServerInfo server;

    public ESRemoteProjectImpl(ServerInfo serverInfo, ProjectInfo projectInfo) {
        this.server = serverInfo;
        this.projectInfo = projectInfo;
    }

    @Override
    public ESGlobalProjectId getGlobalProjectId() {
        return (ESGlobalProjectId)this.getProjectInfo().getProjectId().toAPI();
    }

    @Override
    public String getProjectName() {
        return this.getProjectInfo().getName();
    }

    @Override
    public List<ESBranchInfo> getBranches(IProgressMonitor monitor) throws ESException {
        return (List)new UnknownEMFStoreWorkloadCommand<List<ESBranchInfo>>(monitor){

            @Override
            public List<ESBranchInfo> run(IProgressMonitor monitor) throws ESException {
                return APIUtil.mapToAPI(ESBranchInfo.class, (List)((List)new ServerCall<List<BranchInfo>>(ESRemoteProjectImpl.this.getServerInfo()){

                    @Override
                    protected List<BranchInfo> run() throws ESException {
                        ConnectionManager connectionManager = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
                        return connectionManager.getBranches(this.getSessionId(), ESRemoteProjectImpl.this.projectInfo.getProjectId());
                    }
                }.execute()));
            }
        }.execute();
    }

    @Override
    public List<ESBranchInfo> getBranches(ESUsersession usersession, IProgressMonitor monitor) throws ESException {
        return APIUtil.mapToAPI(ESBranchInfo.class, (List)((List)new ServerCall<List<BranchInfo>>(this.getServerInfo()){

            @Override
            protected List<BranchInfo> run() throws ESException {
                return this.getConnectionManager().getBranches(this.getSessionId(), ESRemoteProjectImpl.this.projectInfo.getProjectId());
            }
        }.execute()));
    }

    @Override
    public ESPrimaryVersionSpec resolveVersionSpec(ESVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
        final ESVersionSpecImpl versionSpecImpl = (ESVersionSpecImpl)versionSpec;
        PrimaryVersionSpec primaryVersionSpec = (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>(this.getServerInfo(), monitor){

            @Override
            protected PrimaryVersionSpec run() throws ESException {
                return this.getConnectionManager().resolveVersionSpec(this.getSessionId(), ESRemoteProjectImpl.this.projectInfo.getProjectId(), (VersionSpec)versionSpecImpl.toInternalAPI());
            }
        }.execute();
        return (ESPrimaryVersionSpec)primaryVersionSpec.toAPI();
    }

    @Override
    public ESPrimaryVersionSpec resolveVersionSpec(ESUsersession session, ESVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
        Usersession usersession = (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        final ESVersionSpecImpl versionSpecImpl = (ESVersionSpecImpl)versionSpec;
        PrimaryVersionSpec primaryVersionSpec = (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>(usersession){

            @Override
            protected PrimaryVersionSpec run() throws ESException {
                return this.getConnectionManager().resolveVersionSpec(this.getSessionId(), ESRemoteProjectImpl.this.projectInfo.getProjectId(), (VersionSpec)versionSpecImpl.toInternalAPI());
            }
        }.execute();
        return (ESPrimaryVersionSpec)primaryVersionSpec.toAPI();
    }

    @Override
    public List<ESHistoryInfo> getHistoryInfos(ESHistoryQuery<? extends ESHistoryQuery<?>> query, IProgressMonitor monitor) throws ESException {
        final ESHistoryQueryImpl queryImpl = (ESHistoryQueryImpl)query;
        return APIUtil.mapToAPI(ESHistoryInfo.class, (List)((List)new ServerCall<List<HistoryInfo>>(this.getServerInfo(), monitor){

            @Override
            protected List<HistoryInfo> run() throws ESException {
                return this.getConnectionManager().getHistoryInfo(this.getSessionId(), ESRemoteProjectImpl.this.projectInfo.getProjectId(), (HistoryQuery)queryImpl.toInternalAPI());
            }
        }.execute()));
    }

    @Override
    public List<ESHistoryInfo> getHistoryInfos(ESUsersession session, ESHistoryQuery<? extends ESHistoryQuery<?>> query, IProgressMonitor monitor) throws ESException {
        Usersession usersession = (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        final ESHistoryQueryImpl queryImpl = (ESHistoryQueryImpl)query;
        List historyInfos = (List)new ServerCall<List<HistoryInfo>>(usersession, monitor){

            @Override
            protected List<HistoryInfo> run() throws ESException {
                return this.getConnectionManager().getHistoryInfo(this.getUsersession().getSessionId(), ESRemoteProjectImpl.this.getProjectInfo().getProjectId(), (HistoryQuery)queryImpl.toInternalAPI());
            }
        }.execute();
        return APIUtil.mapToAPI(ESHistoryInfo.class, (List)historyInfos);
    }

    @Override
    public void addTag(ESPrimaryVersionSpec primaryVersionSpec, ESTagVersionSpec tagVersionSpec, final IProgressMonitor monitor) throws ESException {
        final ESPrimaryVersionSpecImpl primaryVersionSpecImpl = (ESPrimaryVersionSpecImpl)primaryVersionSpec;
        final ESTagVersionSpecImpl tagVersionSpecImpl = (ESTagVersionSpecImpl)tagVersionSpec;
        RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return (Void)new ServerCall<Void>(ESRemoteProjectImpl.this.getServerInfo(), monitor){

                    @Override
                    protected Void run() throws ESException {
                        this.getConnectionManager().addTag(this.getUsersession().getSessionId(), ESRemoteProjectImpl.this.getProjectInfo().getProjectId(), (PrimaryVersionSpec)primaryVersionSpecImpl.toInternalAPI(), (TagVersionSpec)tagVersionSpecImpl.toInternalAPI());
                        return null;
                    }
                }.execute();
            }
        });
    }

    @Override
    public void removeTag(ESPrimaryVersionSpec versionSpec, ESTagVersionSpec tag, final IProgressMonitor monitor) throws ESException {
        final ESPrimaryVersionSpecImpl versionSpecImpl = (ESPrimaryVersionSpecImpl)versionSpec;
        final ESTagVersionSpecImpl tagVersionSpecImpl = (ESTagVersionSpecImpl)tag;
        RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                new ServerCall<Void>(ESRemoteProjectImpl.this.getServerInfo(), monitor){

                    @Override
                    protected Void run() throws ESException {
                        this.getConnectionManager().removeTag(this.getUsersession().getSessionId(), ESRemoteProjectImpl.this.projectInfo.getProjectId(), (PrimaryVersionSpec)versionSpecImpl.toInternalAPI(), (TagVersionSpec)tagVersionSpecImpl.toInternalAPI());
                        return null;
                    }
                }.execute();
                return null;
            }
        });
    }

    @Override
    public ESLocalProjectImpl checkout(final String name, final IProgressMonitor monitor) throws ESException {
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESLocalProjectImpl>(){

            @Override
            public ESLocalProjectImpl call() throws Exception {
                return (ESLocalProjectImpl)new ServerCall<ESLocalProjectImpl>(ESRemoteProjectImpl.this.getServerInfo()){

                    @Override
                    protected ESLocalProjectImpl run() throws ESException {
                        return ESRemoteProjectImpl.this.checkout(name, (ESUsersession)this.getUsersession().toAPI(), monitor);
                    }
                }.execute();
            }
        });
    }

    @Override
    public ESLocalProjectImpl checkout(final String name, final ESUsersession usersession, final IProgressMonitor monitor) throws ESException {
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESLocalProjectImpl>(){

            @Override
            public ESLocalProjectImpl call() throws Exception {
                ESPrimaryVersionSpec primaryVersionSpec = ESRemoteProjectImpl.this.resolveVersionSpec(usersession, (ESVersionSpec)Versions.createHEAD().toAPI(), monitor);
                return ESRemoteProjectImpl.this.checkout(name, usersession, primaryVersionSpec, monitor);
            }
        });
    }

    @Override
    public ESLocalProjectImpl fetch(final String name, ESUsersession session, ESPrimaryVersionSpec versionSpec, IProgressMonitor progressMonitor) throws ESException {
        final SubMonitor parentMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.ESRemoteProjectImpl_Fetching_Title, (int)100);
        final Usersession usersession = (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        ESPrimaryVersionSpecImpl primaryVersionSpecImpl = (ESPrimaryVersionSpecImpl)versionSpec;
        final ProjectInfo projectInfoCopy = (ProjectInfo)ModelUtil.clone((EObject)this.getProjectInfo());
        projectInfoCopy.setVersion((PrimaryVersionSpec)primaryVersionSpecImpl.toInternalAPI());
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESLocalProjectImpl>(){

            @Override
            public ESLocalProjectImpl call() throws Exception {
                Project project = null;
                SubMonitor childMonitor = parentMonitor.newChild(40);
                parentMonitor.subTask(Messages.ESRemoteProjectImpl_Fetching_Project);
                project = (Project)new UnknownEMFStoreWorkloadCommand<Project>((IProgressMonitor)childMonitor){

                    @Override
                    public Project run(IProgressMonitor monitor) throws ESException {
                        return (Project)new ServerCall<Project>(usersession){

                            @Override
                            protected Project run() throws ESException {
                                return this.getConnectionManager().getProject(usersession.getSessionId(), ESRemoteProjectImpl.this.getProjectInfo().getProjectId(), (VersionSpec)projectInfoCopy.getVersion());
                            }
                        }.execute();
                    }
                }.execute();
                if (project == null) {
                    throw new ESException(Messages.ESRemoteProjectImpl_Server_Returned_Null_Project);
                }
                return (ESLocalProjectImpl)ESRemoteProjectImpl.this.initProjectSpace(usersession, projectInfoCopy, project, name).toAPI();
            }
        });
    }

    @Override
    public ESLocalProjectImpl checkout(String name, ESUsersession session, ESPrimaryVersionSpec versionSpec, IProgressMonitor progressMonitor) throws ESException {
        ESLocalProjectImpl project = this.fetch(name, session, versionSpec, progressMonitor);
        project.addToWorkspace(progressMonitor);
        ((ESCheckoutObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESCheckoutObserver.class)).checkoutDone(project);
        return project;
    }

    private ProjectSpace initProjectSpace(Usersession usersession, ProjectInfo projectInfoCopy, Project project, String projectName) {
        ProjectSpace projectSpace = ModelFactory.eINSTANCE.createProjectSpace();
        projectSpace.setProjectId(projectInfoCopy.getProjectId());
        projectSpace.setProjectName(projectName);
        projectSpace.setProjectDescription(projectInfoCopy.getDescription());
        projectSpace.setBaseVersion(projectInfoCopy.getVersion());
        projectSpace.setLastUpdated(new Date());
        projectSpace.setUsersession(usersession);
        projectSpace.setProject(project);
        projectSpace.setResourceCount(0);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        XMIResource res = (XMIResource)resourceSetImpl.createResource(ModelUtil.VIRTUAL_URI);
        ((ResourceImpl)res).setIntrinsicIDToEObjectMap(new HashMap());
        res.getContents().add((Object)project);
        projectSpace.setResourceSet((ResourceSet)resourceSetImpl);
        return projectSpace;
    }

    @Override
    public void delete(final IProgressMonitor monitor) throws ESException {
        RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ESRemoteProjectImpl.this.getDeleteProjectServerCall().setProgressMonitor(monitor).setServer(ESRemoteProjectImpl.this.getServerInfo()).execute();
                return null;
            }
        });
    }

    @Override
    public void delete(ESUsersession session, final IProgressMonitor monitor) throws ESException {
        final Usersession usersession = (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ESRemoteProjectImpl.this.getDeleteProjectServerCall().setProgressMonitor(monitor).setUsersession(usersession).execute();
                return null;
            }
        });
    }

    @Override
    public ESServerImpl getServer() {
        return (ESServerImpl)this.getServerInfo().toAPI();
    }

    @Override
    public ESPrimaryVersionSpec getHeadVersion(IProgressMonitor monitor) throws ESException {
        return this.resolveVersionSpec((ESVersionSpec)Versions.createHEAD().toAPI(), monitor);
    }

    private boolean canDeleteFiles(ACOrgUnit orgUnit, ProjectId projectId) {
        for (Role role : orgUnit.getRoles()) {
            if (!ServerAdmin.class.isInstance(role)) continue;
            return true;
        }
        return false;
    }

    private ServerCall<Void> getDeleteProjectServerCall() {
        return new ServerCall<Void>(){

            @Override
            protected Void run() throws ESException {
                new UnknownEMFStoreWorkloadCommand<Void>(this.getProgressMonitor()){

                    @Override
                    public Void run(IProgressMonitor monitor) throws ESException {
                        ACUser user = this.getUsersession().getACUser();
                        if (ESRemoteProjectImpl.this.canDeleteFiles((ACOrgUnit)user, ESRemoteProjectImpl.this.getProjectInfo().getProjectId())) {
                            this.getConnectionManager().deleteProject(this.getSessionId(), ESRemoteProjectImpl.this.getProjectInfo().getProjectId(), true);
                        } else {
                            this.getConnectionManager().deleteProject(this.getSessionId(), ESRemoteProjectImpl.this.getProjectInfo().getProjectId(), false);
                        }
                        return null;
                    }
                }.execute();
                return null;
            }
        };
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public ServerInfo getServerInfo() {
        return this.server;
    }
}

