/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.ConflictResolver;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.CancelOperationException;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.BranchSelectionDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.MergeProjectHandler;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIMergeController
extends AbstractEMFStoreUIController<Void> {
    private final ProjectSpace projectSpace;

    public UIMergeController(Shell shell, ESLocalProject localProject) {
        super(shell);
        this.projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        if (!this.projectSpace.getOperations().isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.UIMergeController_MergeNotApplicable_Title, (String)Messages.UIMergeController_MergeNotApplicable_Message);
            return null;
        }
        PrimaryVersionSpec selectedVersionSpec = this.branchSelection(this.projectSpace);
        if (selectedVersionSpec != null) {
            this.projectSpace.mergeBranch(selectedVersionSpec, (ConflictResolver)new MergeProjectHandler(true), monitor);
        }
        return null;
    }

    private PrimaryVersionSpec branchSelection(ProjectSpace projectSpace) throws ESException {
        final List branches = projectSpace.getBranches();
        ListIterator iterator = branches.listIterator();
        while (iterator.hasNext()) {
            BranchInfo current = (BranchInfo)iterator.next();
            if (!current.getName().equals(projectSpace.getBaseVersion().getBranch())) continue;
            iterator.remove();
        }
        BranchInfo result = RunInUI.WithException.runWithResult(new Callable<BranchInfo>(){

            @Override
            public BranchInfo call() throws Exception {
                BranchSelectionDialog dialog = new BranchSelectionDialog(UIMergeController.this.getShell(), branches);
                dialog.setBlockOnOpen(true);
                if (dialog.open() != 0 || dialog.getResult() == null) {
                    throw new CancelOperationException(Messages.UIMergeController_NoBranchGiven);
                }
                return dialog.getResult();
            }
        });
        return result.getHead();
    }
}

