/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.OrgUnitManagementGUI;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesComposite;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupComposite
extends PropertiesComposite {
    private ACGroup group;
    private final OrgUnitManagementGUI orgUnitMgmtGUI;

    public GroupComposite(Composite parent, int style, AdminBroker adminBroker, OrgUnitManagementGUI orgUnitMgmtGUI) {
        super(parent, style, adminBroker);
        this.orgUnitMgmtGUI = orgUnitMgmtGUI;
        this.createControls();
    }

    @Override
    protected void removeOrgUnit(ACOrgUnit orgUnit) {
        try {
            this.getAdminBroker().removeMember(this.group.getId(), orgUnit.getId());
        }
        catch (AccessControlException accessControlException) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GroupComposite_Insufficient_Access_Rights, (String)Messages.GroupComposite_Not_Allowed_To_Remove_Member_From_Selected_Group);
        }
        catch (ESException ex) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
        }
        this.getTableViewer().refresh();
    }

    @Override
    protected void addExistingOrgUnit(ACOrgUnit orgUnit) {
        if (orgUnit != null && !orgUnit.equals(this.group)) {
            try {
                this.getAdminBroker().addMember(this.group.getId(), orgUnit.getId());
            }
            catch (AccessControlException accessControlException) {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GroupComposite_Insufficient_Access_Rights, (String)Messages.GroupComposite_Not_Allowed_To_Add_Member_To_Selected_Group);
            }
            catch (ESException ex) {
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
            }
        }
        this.getTableViewer().refresh();
    }

    @Override
    protected void addNewOrgUnit() {
        for (ACOrgUnit newMember : this.getNewMembers()) {
            try {
                this.getAdminBroker().addMember(this.group.getId(), newMember.getId());
            }
            catch (AccessControlException accessControlException) {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GroupComposite_Insufficient_Access_Rights, (String)Messages.GroupComposite_Not_Allowed_To_Add_Member_To_Selected_Group);
            }
            catch (ESException ex) {
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
            }
        }
        this.getTableViewer().refresh();
    }

    private EList<ACOrgUnit> getNewMembers() {
        BasicEList allOrgUnits = new BasicEList();
        BasicEList members = new BasicEList();
        try {
            allOrgUnits.addAll(this.getAdminBroker().getOrgUnits());
            allOrgUnits.removeAll(this.getAdminBroker().getMembers(this.group.getId()));
            if (allOrgUnits.contains(this.group)) {
                allOrgUnits.remove(this.group);
            }
            Object[] result = this.showDialog((Collection<ACOrgUnit>)allOrgUnits, Messages.GroupComposite_Select_Member);
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof ACOrgUnit) {
                    members.add((Object)((ACOrgUnit)result[i]));
                }
                ++i;
            }
        }
        catch (ESException e) {
            e.printStackTrace();
        }
        return members;
    }

    @Override
    protected String getTabTitle() {
        return Messages.GroupComposite_Members;
    }

    @Override
    public void updateControls(EObject input) {
        if (input instanceof ACGroup) {
            this.group = (ACGroup)input;
            this.getTxtName().setText(this.group.getName());
            this.getTxtDescription().setText(this.group.getDescription() == null ? "" : this.group.getDescription());
            this.getTableViewer().setInput((Object)this.group);
        }
    }

    @Override
    protected void saveOrgUnitAttributes() {
        if (this.getTxtName() == null || this.getTxtDescription() == null) {
            return;
        }
        if (this.group == null) {
            return;
        }
        if (!this.group.getName().equals(this.getTxtName().getText()) || !this.group.getDescription().equals(this.getTxtDescription().getText())) {
            try {
                this.getAdminBroker().changeOrgUnit(this.group.getId(), this.getTxtName().getText(), this.getTxtDescription().getText());
                ((Form)this.getParent().getParent()).setText(String.valueOf(Messages.GroupComposite_Group) + this.getTxtName().getText());
                this.orgUnitMgmtGUI.getActiveTabContent().getTableViewer().refresh();
            }
            catch (ESException e) {
                EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
            }
        }
    }

    @Override
    protected void addDragNDropSupport() {
        super.addDragNDropSupport();
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DropTargetAdapter dropListener = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = PropertiesForm.getDragSource().equals(Messages.GroupComposite_Projects) ? 0 : 1;
            }

            public void drop(DropTargetEvent event) {
                if (PropertiesForm.getDragNDropObject() != null && PropertiesForm.getDragNDropObject() instanceof ACOrgUnit) {
                    ACOrgUnit orgUnit = (ACOrgUnit)PropertiesForm.getDragNDropObject();
                    GroupComposite.this.addExistingOrgUnit(orgUnit);
                    PropertiesForm.setDragNDropObject(null);
                    GroupComposite.this.getTableViewer().refresh();
                }
            }
        };
        this.getTableViewer().addDropSupport(1, transfers, (DropTargetListener)dropListener);
    }
}

