/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.TabContent;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport.wizard.AcUserImportAction;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action.CreateUserAction;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.action.DeleteUserAction;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTabContent
extends TabContent
implements IPropertyChangeListener {
    private static final String DELETE_ICON = "icons/delete.gif";
    private static final String LOCK_ICON = "icons/lock.png";
    private static final String USER_ICON = "icons/user.png";

    public UserTabContent(String string, AdminBroker adminBroker, PropertiesForm frm) {
        super(string, adminBroker, frm);
        this.setTab(this);
    }

    @Override
    protected List<Action> initActions() {
        CreateUserAction createNewUserAction = new CreateUserAction(this.getAdminBroker(), this.getTableViewer(), this.getForm());
        createNewUserAction.setImageDescriptor(Activator.getImageDescriptor(USER_ICON));
        createNewUserAction.setToolTipText(Messages.UserTabContent_Create_New_User);
        DeleteUserAction deleteUserAction = new DeleteUserAction(this.getAdminBroker(), this.getTableViewer(), this.getForm());
        deleteUserAction.setImageDescriptor(Activator.getImageDescriptor(DELETE_ICON));
        deleteUserAction.setToolTipText(Messages.UserTabContent_Delete_User);
        AcUserImportAction importOrgUnitAction = new AcUserImportAction(this.getAdminBroker());
        importOrgUnitAction.addPropertyChangeListener(this);
        ChangePasswordAction changePassword = new ChangePasswordAction();
        changePassword.setImageDescriptor(Activator.getImageDescriptor(LOCK_ICON));
        changePassword.setToolTipText(Messages.UserTabContent_Change_Password);
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(createNewUserAction);
        actions.add(deleteUserAction);
        actions.add(importOrgUnitAction);
        ESExtensionPoint showPasswordControls = new ESExtensionPoint("org.eclipse.emf.emfstore.client.ui.showPasswordControls");
        if (showPasswordControls.getBoolean("enabled", false).booleanValue()) {
            actions.add(changePassword);
        }
        return actions;
    }

    @Override
    public ITableLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return Activator.getImageDescriptor(UserTabContent.USER_ICON).createImage();
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ACUser)element).getName();
            }
        };
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList users = new ArrayList();
                try {
                    users.addAll(UserTabContent.this.getAdminBroker().getUsers());
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.UserTabContent_Insufficient_Access_Rights, (String)Messages.UserTabContent_Not_Allowed_To_List_Users);
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                }
                return users.toArray(new ACUser[users.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getTableViewer().refresh();
    }

    private final class ChangePasswordAction
    extends Action {
        private ChangePasswordAction() {
            super(Messages.UserTabContent_Change_Password);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)UserTabContent.this.getTableViewer().getSelection();
            for (ACUser user : selection) {
                if (user == null) {
                    return;
                }
                Display display = Display.getCurrent();
                Shell activeShell = display.getActiveShell();
                InputDialog inputDialog = new InputDialog(activeShell, String.valueOf(Messages.UserTabContent_Enter_New_Password_For_User) + " '" + user.getName() + "'", Messages.UserTabContent_Enter_New_Password, "", null);
                if (inputDialog.open() != 0) continue;
                String newPassword = inputDialog.getValue();
                try {
                    UserTabContent.this.getAdminBroker().changeUser(user.getId(), user.getName(), newPassword);
                }
                catch (AccessControlException accessControlException) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.UserTabContent_Insufficient_Access_Rights, (String)Messages.UserTabContent_Not_Allowed_To_Change_Password);
                }
                catch (ESException ex) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)ex));
                }
            }
            UserTabContent.this.getTableViewer().refresh();
        }
    }
}

