/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;

public class ExportImportControllerExecutor {
    private File file;
    private IProgressMonitor monitor;
    private IOException importExportError;

    public ExportImportControllerExecutor(File file, IProgressMonitor monitor) {
        this.file = file;
        this.monitor = monitor;
    }

    public void execute(final IExportImportController controller) throws IOException {
        final String action = controller.isExport() ? "Exporting " : "Importing ";
        new EMFStoreCommand(){

            protected void doRun() {
                ExportImportControllerExecutor.this.monitor.beginTask(String.valueOf(action) + controller.getLabel(), 100);
                ExportImportControllerExecutor.this.monitor.worked(10);
                try {
                    controller.execute(ExportImportControllerExecutor.this.file, ExportImportControllerExecutor.this.monitor);
                }
                catch (IOException e) {
                    ExportImportControllerExecutor.this.importExportError = e;
                }
                ExportImportControllerExecutor.this.monitor.worked(30);
                ExportImportControllerExecutor.this.monitor.worked(60);
                ExportImportControllerExecutor.this.monitor.done();
            }
        }.run(false);
        if (this.importExportError != null) {
            throw this.importExportError;
        }
    }
}

