/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.ESLocationProvider;

public class DefaultServerWorkspaceLocationProvider
implements ESLocationProvider {
    protected String getRootDirectory() {
        String parameter = this.getStartParameter("-EMFStoreHome");
        return parameter == null ? DefaultServerWorkspaceLocationProvider.addFolders(DefaultServerWorkspaceLocationProvider.getUserHome(), ".emfstore", "server") : parameter;
    }

    public String getWorkspaceDirectory() {
        String rootDirectory = this.getRootDirectory();
        File file = new File(rootDirectory);
        if (!file.isAbsolute()) {
            String currentDir = new File(".").getAbsolutePath();
            currentDir = currentDir.substring(0, currentDir.length() - 1);
            String absolutePath = String.valueOf(currentDir) + this.getRootDirectory();
            try {
                rootDirectory = new File(absolutePath).getCanonicalPath();
            }
            catch (IOException e) {
                rootDirectory = DefaultServerWorkspaceLocationProvider.getUserHome();
                ModelUtil.logWarning((String)("Invalid root directory specified.  Using default " + DefaultServerWorkspaceLocationProvider.getUserHome() + "."), (Throwable)e);
            }
        }
        return DefaultServerWorkspaceLocationProvider.addFolders(rootDirectory, "profiles", this.getSelectedProfile());
    }

    protected String getSelectedProfile() {
        String parameter = this.getStartParameter("-profile");
        if (parameter == null) {
            parameter = "default";
            if (ServerConfiguration.isTesting()) {
                parameter = String.valueOf(parameter) + "_test";
            } else if (!ServerConfiguration.isReleaseVersion()) {
                parameter = ServerConfiguration.isInternalReleaseVersion() ? String.valueOf(parameter) + "_internal" : String.valueOf(parameter) + "_dev";
            }
        }
        return parameter;
    }

    public String getBackupDirectory() {
        return DefaultServerWorkspaceLocationProvider.addFolders(this.getRootDirectory(), "backup");
    }

    protected String getStartParameter(String parameter) {
        return ServerConfiguration.getStartArgument(parameter);
    }

    protected static String addFolders(String path, String ... folders) {
        StringBuffer result = new StringBuffer(path);
        if (!path.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            result.append(folder);
            if (!folder.endsWith(File.separator)) {
                result.append(File.separatorChar);
            }
            ++n2;
        }
        return result.toString();
    }

    protected static String getUserHome() {
        StringBuffer sb = new StringBuffer();
        sb.append(System.getProperty("user.home"));
        sb.append(File.separatorChar);
        return sb.toString();
    }
}

