/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.testers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.emfstore.internal.client.accesscontrol.AccessControlHelper;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithResult;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;

public class IsAdminTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, final Object expectedValue) {
        if (receiver instanceof ProjectSpace && expectedValue instanceof Boolean) {
            final ProjectSpace projectSpace = (ProjectSpace)receiver;
            EMFStoreCommandWithResult<Boolean> command = new EMFStoreCommandWithResult<Boolean>(){

                protected Boolean doRun() {
                    Usersession usersession = projectSpace.getUsersession();
                    boolean isAdmin = false;
                    if (usersession != null && usersession.getACUser() != null) {
                        AccessControlHelper accessControlHelper = new AccessControlHelper(usersession);
                        try {
                            accessControlHelper.checkProjectAdminAccess(projectSpace.getProjectId());
                            isAdmin = true;
                        }
                        catch (AccessControlException accessControlException) {
                            isAdmin = false;
                        }
                    }
                    return new Boolean(isAdmin).equals(expectedValue);
                }
            };
            return (Boolean)command.run(false);
        }
        return false;
    }
}

