/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.emfstore.fuzzy.Annotations;
import org.eclipse.emf.emfstore.fuzzy.FuzzyDataProvider;
import org.eclipse.emf.emfstore.fuzzy.Test;
import org.eclipse.emf.emfstore.fuzzy.Util;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyTestClassRunner
extends BlockJUnit4ClassRunner {
    private int counter;
    private FuzzyDataProvider<?> dataProvider;
    private FrameworkField dataField;
    private FrameworkField utilField;
    private Util util;
    private FrameworkField optionsField;

    FuzzyTestClassRunner(Class<?> type, FuzzyDataProvider<?> dataProvider, FrameworkField dataField, FrameworkField utilField, FrameworkField optionsField, Util util, int counter) throws InitializationError {
        super(type);
        this.counter = counter;
        this.dataField = dataField;
        this.utilField = utilField;
        this.optionsField = optionsField;
        this.util = util;
        this.dataProvider = dataProvider;
    }

    public Object createTest() {
        try {
            Object testInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
            if (this.optionsField != null) {
                Object options = this.getValueFromField(this.optionsField.getField(), testInstance);
                if (options == null) {
                    throw new IllegalStateException("The options field has to be not null! Fill it or remove annotation.");
                }
                try {
                    this.dataProvider.setOptions((Map)options);
                }
                catch (ClassCastException classCastException) {
                    throw new ClassCastException("The options field is not of type: Map<String, Object>!");
                }
            }
            Object data = this.dataProvider.get(this.counter);
            this.setValueToField(this.dataField.getField(), testInstance, data, "The field annotated with " + Annotations.Data.class.getSimpleName() + " does not fit to the type of the dataprovider (" + this.dataProvider.getClass() + ").");
            if (this.util != null && this.utilField != null) {
                this.setValueToField(this.utilField.getField(), testInstance, this.util, "The field annotated " + Util.class.getSimpleName() + " does not fit to the Util type!");
            }
            return testInstance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getValueFromField(Field field, Object instance) throws IllegalAccessException {
        try {
            Object o;
            field.setAccessible(true);
            Object object = o = field.get(instance);
            return object;
        }
        finally {
            field.setAccessible(false);
        }
    }

    private void setValueToField(Field field, Object instance, Object value, String errorMsg) throws IllegalAccessException {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        finally {
            field.setAccessible(false);
        }
    }

    protected List<FrameworkMethod> getChildren() {
        List<Test> testsToRun = this.dataProvider.getTestsToRun();
        List allChildren = super.getChildren();
        if (testsToRun != null) {
            ArrayList<FrameworkMethod> filteredChildren = new ArrayList<FrameworkMethod>();
            for (Test test : testsToRun) {
                String name = test.getName();
                int seedCount = test.getSeedCount();
                for (FrameworkMethod child : allChildren) {
                    if (seedCount != this.counter || !name.equals(child.getName())) continue;
                    filteredChildren.add(child);
                }
            }
            return filteredChildren;
        }
        return allChildren;
    }

    private String testName(String name) {
        return String.format("%s%s[%s]", name, " ", this.counter);
    }

    protected String testName(FrameworkMethod method) {
        return this.testName(method.getName());
    }

    protected String getName() {
        return String.format("%s%s[%s]", this.getTestClass().getName(), " ", this.counter);
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }
}

