/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import com.google.common.base.Optional;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.PasswordVerifier;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.ESAuthenticationInformation;
import org.eclipse.emf.emfstore.server.model.ESClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserVerifier
extends PasswordVerifier {
    private final ESOrgUnitProvider orgUnitProvider;

    public UserVerifier(ESOrgUnitProvider orgUnitProvider) {
        this.orgUnitProvider = orgUnitProvider;
    }

    @Override
    public ESAuthenticationInformation verifyUser(String username, String password, ESClientVersionInfo clientVersionInfo) throws AccessControlException {
        this.checkClientVersion(clientVersionInfo);
        String preparedPassword = this.preparePassword(password);
        if (this.verifySuperUser(username, preparedPassword) || this.verifyPassword(username, preparedPassword)) {
            AuthenticationInformation createAuthenticationInfo = this.createAuthenticationInfo();
            createAuthenticationInfo.setResolvedACUser((ACUser)ModelUtil.clone((EObject)this.findUser(username)));
            return (ESAuthenticationInformation)createAuthenticationInfo.toAPI();
        }
        throw new AccessControlException();
    }

    protected ACUser findUser(String username) throws AccessControlException {
        Boolean ignoreCase = Boolean.parseBoolean(ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.matchusers.ignorecase", Boolean.FALSE.toString()));
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            Optional<ACUser> user = UserVerifier.findExistingUser(this.orgUnitProvider, username, ignoreCase);
            if (user.isPresent()) {
                return (ACUser)user.get();
            }
            throw new AccessControlException();
        }
    }

    protected static final Optional<ACUser> findExistingUser(ESOrgUnitProvider orgUnitProvider, String username, Boolean ignoreCase) {
        Set users = orgUnitProvider.getUsers();
        Set internal = APIUtil.toInternal((Set)users);
        for (ACUser user : internal) {
            if (!(ignoreCase != false ? user.getName().equalsIgnoreCase(username) : user.getName().equals(username))) continue;
            return Optional.of((Object)user);
        }
        return Optional.absent();
    }
}

