/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictBucketCandidate {
    private final Set<AbstractOperation> myOperations = new LinkedHashSet<AbstractOperation>();
    private final Set<AbstractOperation> theirOperations = new LinkedHashSet<AbstractOperation>();
    private final Map<AbstractOperation, Integer> operationToPriorityMap = new LinkedHashMap<AbstractOperation, Integer>();
    private ConflictBucketCandidate parentConflictBucketCandidate;

    public void addOperation(AbstractOperation operation, boolean isMyOperation, int priority) {
        if (operation == null) {
            return;
        }
        this.operationToPriorityMap.put(operation, priority);
        if (isMyOperation) {
            this.myOperations.add(operation);
        } else {
            this.theirOperations.add(operation);
        }
    }

    public void addConflictBucketCandidate(ConflictBucketCandidate otherBucket) {
        if (otherBucket == null) {
            return;
        }
        this.myOperations.addAll(otherBucket.getMyOperations());
        this.theirOperations.addAll(otherBucket.getTheirOperations());
        this.operationToPriorityMap.putAll(otherBucket.operationToPriorityMap);
    }

    public ConflictBucketCandidate getRootConflictBucketCandidate() {
        if (this.parentConflictBucketCandidate == null) {
            return this;
        }
        return this.getParentConflictBucketCandidate(new ArrayList<ConflictBucketCandidate>());
    }

    private ConflictBucketCandidate getParentConflictBucketCandidate(List<ConflictBucketCandidate> pathToRoot) {
        if (this.parentConflictBucketCandidate == null) {
            for (ConflictBucketCandidate conflictBucketCandidate : pathToRoot) {
                conflictBucketCandidate.setParentConflictBucketCandidate(this);
            }
            return this;
        }
        pathToRoot.add(this);
        return this.parentConflictBucketCandidate.getParentConflictBucketCandidate(pathToRoot);
    }

    public void setParentConflictBucketCandidate(ConflictBucketCandidate parentConflictBucketCandidate) {
        if (this == parentConflictBucketCandidate) {
            return;
        }
        this.parentConflictBucketCandidate = parentConflictBucketCandidate;
    }

    public int size() {
        return this.theirOperations.size() + this.myOperations.size();
    }

    public boolean isConflicting() {
        return this.theirOperations.size() > 0 && this.myOperations.size() > 0;
    }

    public Set<AbstractOperation> getMyOperations() {
        return this.myOperations;
    }

    public Set<AbstractOperation> getTheirOperations() {
        return this.theirOperations;
    }

    public Set<ConflictBucket> calculateConflictBuckets(ConflictDetector detector, Set<AbstractOperation> myOperationsNonConflictingOperations) {
        LinkedHashSet<ConflictBucket> conflictBucketsSet = new LinkedHashSet<ConflictBucket>();
        if (!this.isConflicting()) {
            myOperationsNonConflictingOperations.addAll(this.myOperations);
            return conflictBucketsSet;
        }
        ConflictBucket newConflictBucket = new ConflictBucket(this.getMyOperations(), this.getTheirOperations());
        conflictBucketsSet.add(newConflictBucket);
        return this.selectMyandTheirOperation(conflictBucketsSet);
    }

    private Set<ConflictBucket> selectMyandTheirOperation(Set<ConflictBucket> conflictBucketsSet) {
        Integer currentPrio;
        AbstractOperation maxOperation;
        Integer maxPriority;
        for (ConflictBucket conflictBucket : conflictBucketsSet) {
            maxPriority = -1;
            maxOperation = null;
            for (AbstractOperation myOperation : conflictBucket.getMyOperations()) {
                currentPrio = this.operationToPriorityMap.get(myOperation);
                if (currentPrio <= maxPriority) continue;
                maxPriority = currentPrio;
                maxOperation = myOperation;
            }
            conflictBucket.setMyOperation(maxOperation);
        }
        for (ConflictBucket conflictBucket : conflictBucketsSet) {
            maxPriority = -1;
            maxOperation = null;
            for (AbstractOperation theirOperation : conflictBucket.getTheirOperations()) {
                currentPrio = this.operationToPriorityMap.get(theirOperation);
                if (currentPrio <= maxPriority) continue;
                maxPriority = currentPrio;
                maxOperation = theirOperation;
            }
            conflictBucket.setTheirOperation(maxOperation);
        }
        return conflictBucketsSet;
    }
}

