/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;

public abstract class AbstractFileSystemBrowser {
    protected IFileID fileID = null;
    protected IRemoteFileSystemListener listener = null;
    private Exception exception = null;
    protected IRemoteFile[] remoteFiles = null;
    protected Proxy proxy;
    protected URL directoryOrFile;
    protected IConnectContext connectContext;
    protected DirectoryJob job = null;
    Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.job != null) {
                this.job.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.lock;
        synchronized (object) {
            this.job = null;
        }
    }

    protected abstract void runRequest() throws Exception;

    public AbstractFileSystemBrowser(IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL url, IConnectContext connectContext, Proxy proxy) {
        Assert.isNotNull((Object)directoryOrFileID);
        this.fileID = directoryOrFileID;
        Assert.isNotNull((Object)listener);
        this.listener = listener;
        this.directoryOrFile = url;
        this.connectContext = connectContext;
        this.proxy = proxy;
    }

    public IRemoteFileSystemRequest sendBrowseRequest() {
        this.job = new DirectoryJob();
        IRemoteFileSystemRequest request = this.createRemoteFileSystemRequest();
        this.job.setRequest(request);
        if (Job.getJobManager().isSuspended()) {
            this.job.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            this.job.schedule();
        }
        return request;
    }

    protected IRemoteFileSystemRequest createRemoteFileSystemRequest() {
        return new RemoteFileSystemRequest(this){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == null) {
                    return null;
                }
                if (adapter.isInstance(this)) {
                    return adapter.cast(this);
                }
                return null;
            }
        };
    }

    protected IRemoteFileSystemEvent createRemoteFileEvent() {
        return new IRemoteFileSystemBrowseEvent(){

            public IFileID getFileID() {
                return AbstractFileSystemBrowser.this.fileID;
            }

            public Exception getException() {
                return AbstractFileSystemBrowser.this.exception;
            }

            public String toString() {
                StringBuilder buf = new StringBuilder("RemoteFileSystemBrowseEvent[");
                buf.append("fileID=").append(AbstractFileSystemBrowser.this.fileID).append(";");
                List<IRemoteFile> list = AbstractFileSystemBrowser.this.remoteFiles != null ? Arrays.asList(AbstractFileSystemBrowser.this.remoteFiles) : null;
                buf.append("files=").append(list).append("]");
                return buf.toString();
            }

            public IRemoteFile[] getRemoteFiles() {
                return AbstractFileSystemBrowser.this.remoteFiles;
            }
        };
    }

    protected abstract void setupProxy(Proxy var1);

    protected IProxyData selectProxyFromProxies(String protocol, IProxyData[] proxies) {
        try {
            return ProxySetupHelper.selectProxyFromProxies(protocol, proxies);
        }
        catch (NoClassDefFoundError e) {
            Activator.logNoProxyWarning(e);
            return null;
        }
    }

    protected void setupProxies() {
        if (this.proxy == null) {
            try {
                this.proxy = ProxySetupHelper.getProxy(this.directoryOrFile.toExternalForm());
            }
            catch (NoClassDefFoundError e) {
                Activator.logNoProxyWarning(e);
            }
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    protected synchronized void setException(Exception exception) {
        this.exception = exception;
    }

    protected synchronized Exception getException() {
        return this.exception;
    }

    protected synchronized boolean isCanceled() {
        return this.exception instanceof UserCancelledException;
    }

    protected synchronized void setCanceled(Exception e) {
        this.exception = e instanceof UserCancelledException ? e : this.newUserCancelledException();
    }

    protected UserCancelledException newUserCancelledException() {
        return new UserCancelledException(Messages.AbstractRetrieveFileTransfer_Exception_User_Cancelled);
    }

    protected class DirectoryJob
    extends Job {
        private IRemoteFileSystemRequest request;

        public DirectoryJob() {
            super(AbstractFileSystemBrowser.this.fileID.getName());
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    if (monitor.isCanceled()) {
                        throw AbstractFileSystemBrowser.this.newUserCancelledException();
                    }
                    AbstractFileSystemBrowser.this.runRequest();
                }
                catch (Exception e) {
                    AbstractFileSystemBrowser.this.setException(e);
                    AbstractFileSystemBrowser.this.listener.handleRemoteFileEvent(AbstractFileSystemBrowser.this.createRemoteFileEvent());
                    AbstractFileSystemBrowser.this.cleanUp();
                }
            }
            finally {
                AbstractFileSystemBrowser.this.listener.handleRemoteFileEvent(AbstractFileSystemBrowser.this.createRemoteFileEvent());
                AbstractFileSystemBrowser.this.cleanUp();
            }
            return Status.OK_STATUS;
        }

        public void setRequest(IRemoteFileSystemRequest request) {
            this.request = request;
        }

        public IRemoteFileSystemRequest getRequest() {
            return this.request;
        }

        protected void canceling() {
            this.request.cancel();
        }
    }

    public abstract class RemoteFileSystemRequest
    implements IRemoteFileSystemRequest {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = AbstractFileSystemBrowser.this.lock;
            synchronized (object) {
                if (AbstractFileSystemBrowser.this.job != null) {
                    AbstractFileSystemBrowser.this.job.cancel();
                }
            }
        }

        public IFileID getFileID() {
            return AbstractFileSystemBrowser.this.fileID;
        }

        public IRemoteFileSystemListener getRemoteFileListener() {
            return AbstractFileSystemBrowser.this.listener;
        }
    }
}

