/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.equinox.metatype.impl.FragmentUtils;
import org.eclipse.equinox.metatype.impl.MetaTypeProviderImpl;
import org.osgi.framework.Bundle;

public abstract class LocalizationElement {
    public static final char KEY_SIGN = '%';
    public static final char LOCALE_SEP = '_';
    private final String localization;
    private Bundle bundle;
    private String locale;
    private Map<String, ResourceBundle> resourceBundleCache;

    private static ResourceBundle getResourceBundle(String resourceBase, String locale, Bundle bundle) {
        int idx2_first;
        String defaultLocale;
        int idx2_second;
        String[] searchCandidates = new String[7];
        if (locale != null && locale.length() > 0) {
            int idx1_first = locale.indexOf(95);
            if (idx1_first == -1) {
                searchCandidates[2] = "_" + locale;
            } else {
                searchCandidates[2] = "_" + locale.substring(0, idx1_first);
                int idx1_second = locale.indexOf(95, idx1_first + 1);
                if (idx1_second == -1) {
                    searchCandidates[1] = "_" + locale;
                } else {
                    searchCandidates[1] = "_" + locale.substring(0, idx1_second);
                    searchCandidates[0] = "_" + locale;
                }
            }
        }
        if ((idx2_second = (defaultLocale = Locale.getDefault().toString()).indexOf(95, (idx2_first = defaultLocale.indexOf(95)) + 1)) != -1) {
            searchCandidates[3] = "_" + defaultLocale;
            if (searchCandidates[3].equalsIgnoreCase(searchCandidates[0])) {
                searchCandidates[3] = null;
            }
        }
        if (idx2_first != -1 && idx2_second != idx2_first + 1) {
            searchCandidates[4] = "_" + (idx2_second == -1 ? defaultLocale : defaultLocale.substring(0, idx2_second));
            if (searchCandidates[4].equalsIgnoreCase(searchCandidates[1])) {
                searchCandidates[4] = null;
            }
        }
        if (idx2_first == -1 && defaultLocale.length() > 0) {
            searchCandidates[5] = "_" + defaultLocale;
        } else if (idx2_first > 0) {
            searchCandidates[5] = "_" + defaultLocale.substring(0, idx2_first);
        }
        if (searchCandidates[5] != null && searchCandidates[5].equalsIgnoreCase(searchCandidates[2])) {
            searchCandidates[5] = null;
        }
        searchCandidates[6] = "";
        URL resourceUrl = null;
        URL[] urls = null;
        int idx = 0;
        while (idx < searchCandidates.length && resourceUrl == null) {
            URL[] uRLArray = urls = searchCandidates[idx] == null ? null : FragmentUtils.findEntries(bundle, String.valueOf(resourceBase) + searchCandidates[idx] + ".properties");
            if (urls != null && urls.length > 0) {
                resourceUrl = urls[0];
            }
            ++idx;
        }
        if (resourceUrl != null) {
            try {
                return new PropertyResourceBundle(resourceUrl.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public LocalizationElement(String localization) {
        this.localization = localization;
    }

    String getLocalization() {
        return this.localization;
    }

    protected String getLocalized(String key) {
        if (key == null) {
            return null;
        }
        if (key.length() > 1 && key.charAt(0) == '%') {
            ResourceBundle rb = this.getResourceBundle();
            if (rb != null) {
                try {
                    String transfered = rb.getString(key.substring(1));
                    if (transfered != null) {
                        return transfered;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return key.substring(1);
        }
        return key;
    }

    protected synchronized ResourceBundle getResourceBundle() {
        String resourceBase = this.localization != null ? this.localization : MetaTypeProviderImpl.getBundleLocalization(this.bundle);
        long bundleId = this.bundle.getBundleId();
        String key = this.locale != null ? String.valueOf(bundleId) + ":" + this.locale + ":" + resourceBase : String.valueOf(bundleId) + ":" + resourceBase;
        ResourceBundle resourceBundle = this.resourceBundleCache.get(key);
        if (resourceBundle == null && (resourceBundle = LocalizationElement.getResourceBundle(resourceBase, this.locale, this.bundle)) != null) {
            this.resourceBundleCache.put(key, resourceBundle);
        }
        return resourceBundle;
    }

    protected synchronized void setLocaleAndBundle(String locale, Bundle bundle, Map<String, ResourceBundle> resourceBundleCache) {
        this.locale = locale;
        this.bundle = bundle;
        this.resourceBundleCache = resourceBundleCache;
    }
}

