/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.provisioning;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipInputStream;
import javax.management.openmbean.TabularData;
import org.eclipse.gemini.mgmt.internal.OSGiProperties;
import org.osgi.jmx.service.provisioning.ProvisioningServiceMBean;
import org.osgi.service.provisioning.ProvisioningService;

public final class Provisioning
implements ProvisioningServiceMBean {
    private ProvisioningService provisioning;

    public Provisioning(ProvisioningService provisioning) {
        this.provisioning = provisioning;
    }

    public void addInformationFromZip(String zipURL) throws IOException {
        InputStream is = new URL(zipURL).openStream();
        ZipInputStream zis = new ZipInputStream(is);
        try {
            this.provisioning.addInformation(zis);
        }
        finally {
            zis.close();
        }
    }

    public void addInformation(TabularData info) throws IOException {
        this.provisioning.addInformation(OSGiProperties.propertiesFrom(info));
    }

    public TabularData listInformation() throws IOException {
        return OSGiProperties.tableFrom(this.provisioning.getInformation());
    }

    public void setInformation(TabularData info) throws IOException {
        this.provisioning.setInformation(OSGiProperties.propertiesFrom(info));
    }
}

