/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;

public class ViewerFocusTracker {
    private final Viewer[] viewers;
    private Viewer viewerInFocus;
    private final FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            Viewer[] viewerArray = ViewerFocusTracker.this.viewers;
            int n = viewerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Viewer viewer = viewerArray[n2];
                if (viewer.getControl() == e.widget) {
                    if (viewer == ViewerFocusTracker.this.viewerInFocus) break;
                    ViewerFocusTracker.this.viewerInFocus = viewer;
                    ViewerFocusTracker.this.focusChanged();
                    break;
                }
                ++n2;
            }
        }

        public void focusLost(FocusEvent e) {
        }
    };

    public ViewerFocusTracker(Viewer[] viewers, Viewer viewerInFocus) {
        this.viewers = viewers;
        this.viewerInFocus = viewerInFocus;
        Viewer[] viewerArray = viewers;
        int n = viewers.length;
        int n2 = 0;
        while (n2 < n) {
            Viewer viewer = viewerArray[n2];
            viewer.getControl().addFocusListener(this.focusListener);
            ++n2;
        }
    }

    public void dispose() {
        Viewer[] viewerArray = this.viewers;
        int n = this.viewers.length;
        int n2 = 0;
        while (n2 < n) {
            Viewer viewer = viewerArray[n2];
            Control control = viewer.getControl();
            if (!control.isDisposed()) {
                control.removeFocusListener(this.focusListener);
            }
            ++n2;
        }
    }

    public final Viewer getViewerInFocus() {
        return this.viewerInFocus;
    }

    protected void focusChanged() {
    }
}

