/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.artemis.consumer;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Consumer.class);
    private final TransportConfiguration transportConfig;
    private final String queueName;
    private ServerLocator locator;
    private ClientSessionFactory sessionFactory;
    private ClientSession session;
    private ClientConsumer consumer;
    private String queueAddress;
    private QueueType queueType;

    public static Consumer connectRemote(String host, int port, String queueAddress, String queueName, QueueType queueType, boolean isSSLEnabled) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", host);
        params.put("port", port);
        params.put("sslEnabled", isSSLEnabled);
        params.put("useNio", "true");
        TransportConfiguration config = new TransportConfiguration(NettyConnectorFactory.class.getName(), params);
        return new Consumer(config, queueAddress, queueName, queueType);
    }

    private Consumer(TransportConfiguration config, String address, String queueName, QueueType queueType) {
        this.transportConfig = config;
        this.queueAddress = address;
        this.queueType = queueType;
        this.queueName = queueName;
    }

    public void openSession(String username, String password) throws Exception {
        if (this.session == null) {
            this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.transportConfig});
            this.sessionFactory = this.locator.createSessionFactory();
        }
        if (this.session == null || this.session.isClosed()) {
            this.session = this.sessionFactory.createSession(username, password, false, true, true, this.locator.isPreAcknowledge(), this.locator.getAckBatchSize());
            boolean queueExists = this.session.queueQuery(new SimpleString(this.queueName)).isExists();
            if (!queueExists) {
                this.createQueue();
            }
            this.session.start();
        }
        if (this.consumer == null || this.consumer.isClosed()) {
            this.consumer = this.session.createConsumer(this.queueName);
        }
    }

    public void commitSession() throws ActiveMQException {
        if (this.session == null) {
            return;
        }
        this.session.commit();
    }

    public void closeSession() throws ActiveMQException {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        if (this.locator != null) {
            this.locator.close();
            this.locator = null;
        }
    }

    public boolean isSessionOpen() {
        return this.session != null && !this.session.isClosed();
    }

    /*
     * Unable to fully structure code
     */
    public void processChangesSync(MessageHandler handler, long timeout) throws ActiveMQException {
        if (this.session != null) ** GOTO lbl5
        Consumer.LOGGER.warn("Session not open: cannot process any changes");
        return;
lbl-1000:
        // 1 sources

        {
            handler.onMessage(msg);
lbl5:
            // 2 sources

            ** while ((msg = this.consumer.receive((long)timeout)) != null)
        }
lbl6:
        // 1 sources

    }

    public void processChangesAsync(MessageHandler handler) throws ActiveMQException {
        if (this.session == null) {
            LOGGER.warn("Session not open: cannot process any changes");
            return;
        }
        this.consumer.setMessageHandler(handler);
    }

    private void createQueue() throws ActiveMQException {
        switch (this.queueType) {
            case TEMPORARY: {
                this.session.createTemporaryQueue(this.queueAddress, this.queueName);
                break;
            }
            case DURABLE: 
            case DEFAULT: {
                this.session.createQueue(this.queueAddress, this.queueName, this.queueType == QueueType.DURABLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown queue type");
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeSession();
        }
        catch (ActiveMQException e) {
            throw new IOException(e);
        }
    }

    public static enum QueueType {
        TEMPORARY,
        DURABLE,
        DEFAULT;

    }
}

