/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.tableGenerator;

import ee.jakarta.tck.persistence.core.annotations.tableGenerator.Client;
import ee.jakarta.tck.persistence.core.annotations.tableGenerator.DataTypes2;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private DataTypes2 d2;
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "DataTypes3", pkgName + "DataTypes4"};
        return this.createDeploymentJar("jpa_core_annotations_tableGenerator2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup2");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData2();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void generatorOnPropertyTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = this.d2.getId();
            logger.log(System.Logger.Level.TRACE, "find id: " + id);
            DataTypes2 d = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)id);
            if (d != null) {
                if (d.getStringData().equals(this.d2.getStringData())) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("generatorOnPropertyTest failed");
        }
    }

    public void createTestData2() {
        try {
            this.getEntityTransaction().begin();
            this.d2 = new DataTypes2();
            this.d2.setStringData("testData2");
            logger.log(System.Logger.Level.TRACE, "DataType2:" + this.d2.toString());
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }
}

