/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.callback.common;

import ee.jakarta.tck.persistence.core.callback.common.CallbackStatusIF;
import ee.jakarta.tck.persistence.core.callback.common.GenerictListenerImpl;

public abstract class ListenerBase {
    private static final System.Logger logger = System.getLogger(ListenerBase.class.getName());

    protected ListenerBase() {
    }

    public String getShortName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    protected void prePersist(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.prePersist in class " + this, b);
        b.setPrePersistCalled(true);
        b.addPrePersistCall(this.getShortName());
        String testName = b.getTestName();
        if ("prePersistRuntimeExceptionTest".equals(testName)) {
            logger.log(System.Logger.Level.TRACE, "Throwing ArithmeticException in ListenerBase");
            throw new ArithmeticException("RuntimeException from PrePersist.");
        }
    }

    protected void postPersist(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In ListenerBase.postPersist." + this, p);
        if (!p.isPrePersistCalled()) {
            logger.log(System.Logger.Level.TRACE, "When calling postPersist, prePersist has not been called.");
            throw new IllegalStateException("When calling postPersist, prePersist has not been called.");
        }
        p.setPostPersistCalled(true);
        p.addPostPersistCall(this.getShortName());
    }

    protected void preRemove(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.preRemove." + this, b);
        b.setPreRemoveCalled(true);
        b.addPreRemoveCall(this.getShortName());
    }

    protected void postRemove(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In ListenerBase.postRemove." + this, p);
        if (!p.isPreRemoveCalled()) {
            logger.log(System.Logger.Level.TRACE, "When calling postRemove, preRemove has not been called.");
            throw new IllegalStateException("When calling postRemove, preRemove has not been called.");
        }
        p.setPostRemoveCalled(true);
        p.addPostRemoveCall(this.getShortName());
    }

    protected void preUpdate(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.preUpdate." + this, b);
        b.setPreUpdateCalled(true);
        b.addPreUpdateCall(this.getShortName());
    }

    protected void postUpdate(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In ListenerBase.postUpdate." + this, p);
        if (!p.isPreUpdateCalled()) {
            logger.log(System.Logger.Level.ERROR, "When calling postUpdate, preUpdate has not been called.");
            throw new IllegalStateException("When calling postUpdate, preUpdate has not been called.");
        }
        p.setPostUpdateCalled(true);
        p.addPostUpdateCall(this.getShortName());
    }

    protected void postLoad(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.postLoad." + this, b);
        b.setPostLoadCalled(true);
        b.addPostLoadCall(this.getShortName());
    }
}

