/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.schema30.Address;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Spouse;
import ee.jakarta.tck.persistence.common.schema30.UtilCustAliasProductData;
import jakarta.persistence.Parameter;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.invoke.CallSite;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client2
extends UtilCustAliasProductData {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaBuilder2.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void construct() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[16].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)cbuilder.construct(Customer.class, new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))})).where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Object)"Roslindale"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List actual = tq.getResultList();
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("construct Test  failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void tupleIntTest() throws Exception {
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|");
                    pass1 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Expected name:" + this.customerRef[id - 1].getName() + ", actual:null");
                pass1 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("tupleIntTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void tupleToArrayTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.customerRef[2].getId());
        expected.add(this.customerRef[2].getName());
        expected.add(this.customerRef[3].getId());
        expected.add(this.customerRef[3].getName());
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"3"), (Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("id", String.class)), (Object)"4")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<String> actual = new ArrayList<String>();
            for (Tuple t : result) {
                for (Object o : t.toArray()) {
                    logger.log(System.Logger.Level.TRACE, "Object:" + o);
                    actual.add((String)o);
                }
            }
            if (TestUtil.traceflag) {
                logger.log(System.Logger.Level.TRACE, "actual" + actual);
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "expected: " + expected + ", actual: " + actual);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("tupleToArrayTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void tupleIntClassTest() throws Exception {
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Tuple t : result) {
                Integer id = Integer.valueOf((String)t.get(0));
                String name = (String)t.get(1);
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|");
                    pass1 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Expected name:" + this.customerRef[id - 1].getName() + ", actual:null");
                pass1 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("tupleIntClassTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void tupleGetIntClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get("id"), customer.get("name"), customer.get("home")});
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            Tuple t = (Tuple)result.get(0);
            logger.log(System.Logger.Level.INFO, "Testing valid index");
            logger.log(System.Logger.Level.TRACE, "value:" + (String)t.get(1, String.class));
            logger.log(System.Logger.Level.INFO, "Testing invalid index");
            try {
                t.get(99, String.class);
                logger.log(System.Logger.Level.ERROR, "Did not get expected IllegalArgumentException for invalid index:" + (String)t.get(99, String.class));
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Got expected IllegalArgumentException");
                if (!this.getEntityTransaction().getRollbackOnly()) {
                    pass1 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing invalid type");
            try {
                t.get(2, Date.class);
                logger.log(System.Logger.Level.ERROR, "Did not get expected IllegalArgumentException for invalid type:" + t.get(2, Date.class));
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Got expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("tupleGetIntClassIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void tupleElementGetJavaTypeTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
            Path idPath = customer.get(Customer_.getSingularAttribute("id", String.class));
            Class type = idPath.getJavaType();
            if (type.getSimpleName().equals("String")) {
                logger.log(System.Logger.Level.TRACE, "type=" + type.getSimpleName());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected element type of String, actual value:" + type.getSimpleName());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        if (!pass) {
            throw new Exception("tupleElementGetJavaTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void tupleSelectionArrayTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
                Root cust = cquery.from(Customer.class);
                EntityType Customer_ = cust.getModel();
                logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
                cquery.where((Expression)qbuilder.equal((Expression)cust.get(Customer_.getSingularAttribute("id", String.class)), (Object)"4"));
                Selection[] s = new Selection[]{cust.get("id"), cust.get("name")};
                cquery.select((Selection)qbuilder.tuple(s));
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                List result = q.getResultList();
                if (result.size() == 1) {
                    Tuple t = (Tuple)result.get(0);
                    String id = (String)t.get(0);
                    if (id.equals(this.customerRef[3].getId())) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + id);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:" + this.customerRef[3].getId() + ", actual:" + id);
                    }
                    String name = (String)t.get(1);
                    if (name.equals(this.customerRef[3].getName())) {
                        logger.log(System.Logger.Level.TRACE, "Received expected name:" + name);
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected name:" + this.customerRef[3].getName() + ", actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received incorrect result size - Expected: 1, Actual:" + result.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("tupleSelectionArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void array() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        boolean pass3 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
            cquery.select((Selection)cbuilder.array(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))}));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            pass1 = true;
            for (Object[] row : result) {
                Integer id = Integer.valueOf((String)row[0]);
                String name = (String)row[1];
                if (name != null) {
                    if (this.customerRef[id - 1].getName().equals(name)) {
                        actual.add(id);
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|");
                    pass2 = false;
                    continue;
                }
                if (this.customerRef[id - 1].getName() == null) {
                    actual.add(id);
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Expected name:" + this.customerRef[id - 1].getName() + ", actual:null");
                pass2 = false;
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass3 = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("array test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void arrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            Selection[] s = new Selection[]{customer.get("id"), customer.get("name")};
            logger.log(System.Logger.Level.INFO, "Testing tuple");
            try {
                qbuilder.array(new Selection[]{qbuilder.tuple(s)});
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing array");
            try {
                qbuilder.array(new Selection[]{qbuilder.array(s)});
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        if (!pass1 || !pass2) {
            throw new Exception("arrayIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void constructIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            Selection[] s = new Selection[]{customer.get("id"), customer.get("name")};
            logger.log(System.Logger.Level.INFO, "Testing tuple");
            try {
                qbuilder.construct(Customer.class, new Selection[]{qbuilder.tuple(s)});
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing array");
            try {
                qbuilder.construct(Customer.class, new Selection[]{qbuilder.array(s)});
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        if (!pass1 || !pass2) {
            throw new Exception("constructIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void countDistinct() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Long.class);
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            logger.log(System.Logger.Level.TRACE, "count number of orders by customer");
            cquery.select((Selection)cbuilder.countDistinct((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long countResult = (Long)tq.getSingleResult();
            Long expectedCount = 16L;
            if (countResult.equals(expectedCount)) {
                logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "count test returned:" + countResult + "expected: " + expectedCount);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("countDistinct test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void andPredicates() throws Exception {
        boolean pass = false;
        Customer expectedCustomer = this.customerRef[2];
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.and(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("street", String.class)), (Object)"125 Moxy Lane"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Object)"Swansea"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Object)"MA"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), (Object)"11345")}));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Customer result = (Customer)tq.getSingleResult();
            if (result.equals((Object)expectedCustomer)) {
                logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "expected: " + expectedCustomer + ", actual:" + result);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("andPredicates test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void orPredicates() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("street", String.class)), (Object)"47 Skyline Drive"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Object)"Chelmsford"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Object)"VT"), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), (Object)"02155")}));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("orPredicates test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void isNull() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[11].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.isNull((Expression)customer.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isNull test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void isNotNull() throws Exception {
        boolean pass = false;
        String[] expected = new String[17];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 12) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = mm.entity(Customer.class);
            EntityType Address_ = mm.entity(Address.class);
            cquery.where((Expression)cb.isNotNull((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("zip", String.class))));
            cquery.select((Selection)customer);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isNotNull test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void parameter() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            ParameterExpression param1 = cbuilder.parameter(String.class, "streetParam");
            ParameterExpression param2 = cbuilder.parameter(String.class, "cityParam");
            ParameterExpression param3 = cbuilder.parameter(String.class, "stateParam");
            ParameterExpression param4 = cbuilder.parameter(String.class, "zipParam");
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or(new Predicate[]{cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("street", String.class)), (Expression)param1), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("city", String.class)), (Expression)param2), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Expression)param3), cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), (Expression)param4)}));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("streetParam", (Object)"47 Skyline Drive");
            tq.setParameter("cityParam", (Object)"Chelmsford");
            tq.setParameter("stateParam", (Object)"VT");
            tq.setParameter("zipParam", (Object)"02155");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("parameter test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void parameterCaseSensitiveTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[9].getId(), this.customerRef[13].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            ParameterExpression param1 = cbuilder.parameter(String.class, "stateParam");
            ParameterExpression param2 = cbuilder.parameter(String.class, "STATEPARAM");
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Expression)param1), (Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)), (Expression)param2)));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("stateParam", (Object)"RI");
            tq.setParameter("STATEPARAM", (Object)"VT");
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("parameterCaseSensitiveTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void criteriaBuilderValuesTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[14].getId(), this.customerRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            CriteriaBuilder.In inExp = cbuilder.in((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)));
            inExp.value((Expression)cbuilder.parameter(String.class, "state1"));
            inExp.value((Expression)cbuilder.parameter(String.class, "state2"));
            cquery.where((Expression)inExp);
            List result = this.getEntityManager().createQuery(cquery).setParameter("state1", (Object)"MA").setParameter("state2", (Object)"VT").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + c.getId() + ", state:" + c.getHome().getState());
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("criteriaBuilderValuesTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void criteriaBuilderIn1Test() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[14].getId(), this.customerRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            CriteriaBuilder.In inExp = cbuilder.in((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)));
            inExp.value((Expression)cbuilder.parameter(String.class, "state1"));
            inExp.value((Expression)cbuilder.parameter(String.class, "state2"));
            cquery.where((Expression)inExp);
            List result = this.getEntityManager().createQuery(cquery).setParameter("state1", (Object)"MA").setParameter("state2", (Object)"VT").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + c.getId() + ", state:" + c.getHome().getState());
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("criteriaBuilderIn1Test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void criteriaBuilderIn2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        String[] expected = new String[]{this.spouse[0].getId(), this.spouse[3].getId(), this.spouse[4].getId(), this.spouse[5].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            CriteriaBuilder.In in = cbuilder.in((Expression)spouse.get("id"));
            for (String id : new String[]{"2", "3"}) {
                in.value((Object)id);
            }
            Predicate pred = in.not();
            cquery.where((Expression)pred);
            if (!pred.getOperator().equals((Object)Predicate.BooleanOperator.AND)) {
                logger.log(System.Logger.Level.ERROR, "Expected: " + Predicate.BooleanOperator.AND + ", actual:" + pred.getOperator().name());
            } else {
                pass1 = true;
            }
            if (!in.not().isNegated()) {
                logger.log(System.Logger.Level.ERROR, "Expected in.not().isNegated() to return: true, actual:" + in.isNegated());
            } else {
                pass2 = true;
            }
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber());
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass3 = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("criteriaBuilderIn2Test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void criteriaBuilderInValueTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[0].getId(), this.customerRef[1].getId(), this.customerRef[2].getId(), this.customerRef[3].getId(), this.customerRef[6].getId(), this.customerRef[7].getId(), this.customerRef[8].getId(), this.customerRef[9].getId(), this.customerRef[10].getId(), this.customerRef[12].getId(), this.customerRef[14].getId(), this.customerRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            CriteriaBuilder.In inExp = cbuilder.in((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("state", String.class)));
            inExp.value((Object)"MA");
            inExp.value((Object)"VT");
            cquery.where((Expression)inExp);
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + c.getId() + ", state:" + c.getHome().getState());
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("criteriaBuilderInValueTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void expressionInObjectArrayTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId(), this.spouse[2].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)exp.in(new Object[]{"2", "3"}));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber());
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("expressionInObjectArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void expressionInExpressionArrayTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId(), this.spouse[2].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)exp.in(new Expression[]{cbuilder.literal((Object)"2"), cbuilder.literal((Object)"3")}));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber());
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("expressionInExpressionArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void expressionInExpressionTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            Expression e = cbuilder.literal((Object)"2");
            cquery.where((Expression)exp.in(e));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber());
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("expressionInExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void expressionInCollectionTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[1].getId(), this.spouse[2].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            Root spouse = cquery.from(Spouse.class);
            Path exp = spouse.get("id");
            ParameterExpression param = cbuilder.parameter(String.class);
            ArrayList<String> col = new ArrayList<String>();
            col.add("2");
            col.add("3");
            cquery.where((Expression)exp.in(col));
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber());
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("expressionInCollectionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void parameterExpressionIsNullTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            cquery.from(Spouse.class);
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)param.isNull());
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.setParameter((Parameter)param, (Object)"2").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber());
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("parameterExpressionIsNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void parameterExpressionIsNotNullTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.spouse[0].getId(), this.spouse[1].getId(), this.spouse[2].getId(), this.spouse[3].getId(), this.spouse[4].getId(), this.spouse[5].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Spouse.class);
        if (cquery != null) {
            cquery.from(Spouse.class);
            ParameterExpression param = cbuilder.parameter(String.class);
            cquery.where((Expression)param.isNotNull());
            TypedQuery query = this.getEntityManager().createQuery(cquery);
            List result = query.setParameter((Parameter)param, (Object)"2").getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Spouse s : result) {
                logger.log(System.Logger.Level.TRACE, "Customer id:" + s.getId() + ", state:" + s.getSocialSecurityNumber());
                actual.add(Integer.parseInt(s.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("parameterExpressionIsNotNullTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void likeExpStringTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%77"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("likeExpStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void likeExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.customerRef[1].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%77")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("likeExpExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void notLikeExpStringTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[17];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%77"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notLikeExpStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void notLikeExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[17];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%77")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notLikeExpExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void notLikeExpExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%_7"), cbuilder.literal((Object)Character.valueOf('\\'))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notLikeExpExpExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void notLikeExpExpCharTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), cbuilder.literal((Object)"%_7"), '\\'));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notLikeExpExpCharTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void notLikeExpStringExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%_7", cbuilder.literal((Object)Character.valueOf('\\'))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notLikeExpStringExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void notLikeExpStringCharTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[16];
        int j = 0;
        for (int i = 0; i < 18; ++i) {
            if (i == 1 || i == 5) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get(Customer_.getSingularAttribute("home", Address.class)).get(Address_.getSingularAttribute("zip", String.class)), "%_7", '\\'));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notLikeExpStringCharTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void concatExpStringTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("street", String.class)), cbuilder.concat(cbuilder.literal((Object)"1 Network"), " Drive")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("concatExpStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void concatStringExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("street", String.class)), cbuilder.concat("1 Network", cbuilder.literal((Object)" Drive"))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("concatStringExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void concatExpExpTest() throws Exception {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_ = customer.getModel();
            EntityType Address_ = mm.entity(Address.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_.getSingularAttribute("work", Address.class)).get(Address_.getSingularAttribute("street", String.class)), cbuilder.concat(cbuilder.literal((Object)"1 Network"), cbuilder.literal((Object)" Drive"))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("concatExpExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void trimBothExpTest() throws Exception {
        boolean pass = false;
        String expectedResult = "David R. Vincent";
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(String.class);
        if (cquery != null) {
            Root cust = cquery.from(Customer.class);
            EntityType Customer_ = cust.getModel();
            cquery.where((Expression)cb.equal((Expression)cust.get(Customer_.getSingularAttribute("name", String.class)), cb.literal((Object)" David R. Vincent")));
            cquery.select((Selection)cb.trim(CriteriaBuilder.Trimspec.BOTH, (Expression)cust.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            if (result.equals("David R. Vincent")) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:|" + result + "|");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected = |David R. Vincent|, received = |" + result + "|");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("trimBothExpTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void lower() throws Exception {
        String expectedResult = "lisa m. presley";
        boolean pass = false;
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cb.createQuery(String.class);
        if (cquery != null) {
            Root cust = cquery.from(Customer.class);
            EntityType Customer_ = cust.getModel();
            cquery.where((Expression)cb.equal((Expression)cust.get(Customer_.getSingularAttribute("name", String.class)), cb.literal((Object)"Lisa M. Presley")));
            cquery.select((Selection)cb.lower((Expression)cust.get(Customer_.getSingularAttribute("name", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String result = (String)tq.getSingleResult();
            if (result.equals("lisa m. presley")) {
                logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected = lisa m. presley received = " + result);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("lower test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void nullifExpressionExpressionTest() throws Exception {
        boolean pass = false;
        ArrayList<CallSite> expected = new ArrayList<CallSite>();
        for (Customer c : this.customerRef) {
            String id = c.getId();
            if (Integer.parseInt(id) > 18 || Integer.parseInt(id) == 9) continue;
            if (c.getHome().getCity().equals(c.getWork().getCity())) {
                expected.add((CallSite)((Object)(c.getId() + ",null")));
                continue;
            }
            expected.add((CallSite)((Object)(c.getId() + "," + c.getHome().getCity().toLowerCase())));
        }
        Collections.sort(expected);
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Tuple.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            Expression expHomeCity = cbuilder.lower((Expression)customer.get("home").get("city"));
            Expression expWorkCity = cbuilder.lower((Expression)customer.get("work").get("city"));
            cquery.multiselect(new Selection[]{customer.get("id"), cbuilder.nullif(expHomeCity, expWorkCity)});
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.isNotNull((Expression)customer.get("home").get("city")), (Expression)cbuilder.isNotNull((Expression)customer.get("work").get("city"))));
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get("id"))});
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            for (Tuple tuple : result) {
                logger.log(System.Logger.Level.TRACE, "actual:" + tuple.toString());
                String id = (String)tuple.get(0);
                String city = (String)tuple.get(1);
                if (city != null) {
                    actual.add((CallSite)((Object)(id + "," + city)));
                    continue;
                }
                actual.add((CallSite)((Object)(id + ",null")));
            }
            for (String string : actual) {
                logger.log(System.Logger.Level.TRACE, "actual:" + string);
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                for (String string : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + string);
                }
                for (String string : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + string);
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("nullifExpressionExpressionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void nullifExpressionObjectTest() throws Exception {
        boolean pass = false;
        ArrayList<CallSite> expected = new ArrayList<CallSite>();
        for (Customer c : this.customerRef) {
            String id = c.getId();
            if (Integer.parseInt(id) > 18 || Integer.parseInt(id) == 9) continue;
            if (c.getHome().getCity().equals(c.getWork().getCity())) {
                expected.add((CallSite)((Object)(c.getId() + ",null")));
                continue;
            }
            expected.add((CallSite)((Object)(c.getId() + "," + c.getHome().getCity().toLowerCase())));
        }
        Collections.sort(expected);
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Tuple.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            Expression expHomeCity = cbuilder.lower((Expression)customer.get("home").get("city"));
            cquery.multiselect(new Selection[]{customer.get("id"), cbuilder.nullif(expHomeCity, (Object)"burlington")});
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("home").get("city")));
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get("id"))});
            List result = this.getEntityManager().createQuery(cquery).getResultList();
            for (Tuple tuple : result) {
                logger.log(System.Logger.Level.TRACE, "actual:" + tuple.toString());
                String id = (String)tuple.get(0);
                String city = (String)tuple.get(1);
                if (city != null) {
                    actual.add((CallSite)((Object)(id + "," + city)));
                    continue;
                }
                actual.add((CallSite)((Object)(id + ",null")));
            }
            for (String string : actual) {
                logger.log(System.Logger.Level.TRACE, "actual:" + string);
            }
            Collections.sort(actual);
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                for (String string : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + string);
                }
                for (String string : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + string);
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("nullifExpressionObjectTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void selectMultiSelectTest() throws Exception {
        Integer id;
        ArrayList<Integer> actual;
        List result;
        TypedQuery q;
        EntityType Customer_;
        CriteriaQuery cquery;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (Customer c : this.customerRef) {
            expected.add(Integer.valueOf(c.getId()));
        }
        Collections.sort(expected);
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        logger.log(System.Logger.Level.INFO, "Testing select");
        try {
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                Customer_ = customer.getModel();
                cquery.select((Selection)customer.get(Customer_.getSingularAttribute("id", String.class)));
                q = this.getEntityManager().createQuery(cquery);
                result = q.getResultList();
                actual = new ArrayList<Integer>();
                for (Object row : result) {
                    id = Integer.valueOf((String)row);
                    logger.log(System.Logger.Level.TRACE, "id=" + id);
                    actual.add(id);
                }
                Collections.sort(actual);
                if (!this.checkEntityPK(actual, expected)) {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass1 = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)ex);
        }
        logger.log(System.Logger.Level.INFO, "Testing multiselect");
        try {
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                Customer_ = customer.getModel();
                cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("id", String.class)), customer.get(Customer_.getSingularAttribute("name", String.class))});
                q = this.getEntityManager().createQuery(cquery);
                result = q.getResultList();
                actual = new ArrayList();
                for (Object row : result) {
                    id = Integer.valueOf((String)row[0]);
                    String name = (String)row[1];
                    logger.log(System.Logger.Level.TRACE, "id=" + id);
                    logger.log(System.Logger.Level.TRACE, "name=" + name);
                    if (name != null && this.customerRef[id - 1].getName() != null) {
                        if (this.customerRef[id - 1].getName().equals(name)) {
                            actual.add(id);
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Expected name:|" + this.customerRef[id - 1].getName() + "|, actual:|" + name + "|");
                        continue;
                    }
                    if (name == null && this.customerRef[id - 1].getName() == null) {
                        actual.add(id);
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected name:" + this.customerRef[id - 1].getName() + ", actual:null");
                }
                Collections.sort(actual);
                if (!this.checkEntityPK(actual, expected)) {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass2 = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("selectMultiSelectTest test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void multiRootTest() throws Exception {
        boolean pass = true;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int i = 1; i <= this.spouse.length; ++i) {
            for (int j = 1; j <= this.spouse.length; ++j) {
                list.add((CallSite)((Object)(Integer.toString(i) + "," + Integer.toString(j))));
            }
        }
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root spouse1 = cquery.from(Spouse.class);
                Root spouse2 = cquery.from(Spouse.class);
                EntityType Spouse1_ = spouse1.getModel();
                EntityType Spouse2_ = spouse2.getModel();
                cquery.multiselect(new Selection[]{spouse1.get(Spouse1_.getSingularAttribute("id", String.class)), spouse2.get(Spouse2_.getSingularAttribute("id", String.class))});
                TypedQuery q = this.getEntityManager().createQuery(cquery);
                List result = q.getResultList();
                for (Object[] objectArray : result) {
                    Integer sId1 = Integer.valueOf((String)objectArray[0]);
                    Integer sId2 = Integer.valueOf((String)objectArray[1]);
                    logger.log(System.Logger.Level.TRACE, "sId1=" + sId1 + ", sId2=" + sId2);
                    list.remove(sId1 + "," + sId2);
                }
                logger.log(System.Logger.Level.TRACE, "Size:" + list.size());
                if (list.isEmpty()) {
                    logger.log(System.Logger.Level.TRACE, "All PK's were found");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Not all PK's were returned");
                    for (String string : list) {
                        logger.log(System.Logger.Level.ERROR, "Not all PK's were returned:" + string);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)ex);
        }
        if (!pass) {
            throw new Exception("multiRootTest test failed");
        }
    }
}

