/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.inheritance.nonentity;

import ee.jakarta.tck.persistence.core.inheritance.nonentity.Employee;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
public class Project
implements Serializable {
    private static final System.Logger logger = System.getLogger(Project.class.getName());
    private long projId;
    private String name;
    private BigDecimal budget;
    private Employee projectLead;

    public Project() {
        logger.log(System.Logger.Level.TRACE, "Project no-arg constructor");
    }

    public Project(long projId, String name, BigDecimal budget) {
        this(projId, name, budget, null);
    }

    public Project(long projId, String name, BigDecimal budget, Employee projectLead) {
        this.projId = projId;
        this.name = name;
        this.budget = budget;
        this.projectLead = projectLead;
    }

    @Id
    public long getProjId() {
        return this.projId;
    }

    public void setProjId(long projId) {
        this.projId = projId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getBudget() {
        return this.budget;
    }

    public void setBudget(BigDecimal budget) {
        this.budget = budget;
    }

    @OneToOne(mappedBy="project")
    public Employee getProjectLead() {
        return this.projectLead;
    }

    public void setProjectLead(Employee projectLead) {
        this.projectLead = projectLead;
    }
}

