/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.nestedembedding;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.nestedembedding.A;
import ee.jakarta.tck.persistence.core.nestedembedding.Address;
import ee.jakarta.tck.persistence.core.nestedembedding.B;
import ee.jakarta.tck.persistence.core.nestedembedding.ZipCode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "B", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_override_nestedembedding.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void NE1XMTest1() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            B b3 = new B("3", "b3", 1);
            b3.setAddress(addr1);
            B b4 = new B("4", "b4", 1);
            b4.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                B newB = this.getBFromCollection(newCol, b1);
                if (newB != null) {
                    if (newB.getAddress().getStreet().equals("1 Network Drive") && newB.getAddress().getCity().equals("Burlington") && newB.getAddress().getState().equals("MA") && newB.getAddress().getZipCode().getZip().equals("01801") && newB.getAddress().getZipCode().getPlusFour().equals("1234")) {
                        pass = true;
                        logger.log(System.Logger.Level.TRACE, "verified nested embedded class contents ");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected address:" + addr1.toString());
                        logger.log(System.Logger.Level.ERROR, "actual address:" + newB.getAddress().toString());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "b not found in Collection");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Collection did not contain all entries:");
                if (newCol.contains(b1)) {
                    logger.log(System.Logger.Level.TRACE, "found b1");
                } else {
                    logger.log(System.Logger.Level.ERROR, "b1 NOT FOUND");
                }
                if (newCol.contains(b2)) {
                    logger.log(System.Logger.Level.TRACE, "found b2");
                } else {
                    logger.log(System.Logger.Level.ERROR, "b2 NOT FOUND");
                }
                if (newCol.contains(b3)) {
                    logger.log(System.Logger.Level.TRACE, "found b3");
                } else {
                    logger.log(System.Logger.Level.ERROR, "b3 NOT FOUND");
                }
                if (newCol.contains(b4)) {
                    logger.log(System.Logger.Level.TRACE, "found b4");
                } else {
                    logger.log(System.Logger.Level.ERROR, "b4 NOT FOUND");
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void NE1XMTest2() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            A newA = this.findA("1");
            if (newA != null) {
                Collection newCol = aRef.getBCol();
                B newB = (B)this.getEntityManager().createQuery("Select b from B b where b.address.zipcode.zip='01801'").getSingleResult();
                if (newB != null) {
                    logger.log(System.Logger.Level.TRACE, "newB:" + newB.toString());
                    if (newCol.contains(newB)) {
                        logger.log(System.Logger.Level.TRACE, "b contains the searched embeddable Address");
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected:" + newCol.toString() + ", actual:" + newB.toString());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "newB is null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "newA is null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("NE1XMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void NE1XMTest3() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            A newA = this.findA("1");
            if (newA != null) {
                Collection newCol = aRef.getBCol();
                B newB = (B)this.getEntityManager().createQuery("Select b from B b where b.address.street='1 Network Drive'").getSingleResult();
                if (newB != null) {
                    if (newCol.contains(newB)) {
                        logger.log(System.Logger.Level.TRACE, "b contains the searched embeddable Address");
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected:" + newCol.toString() + ", actual:" + newB.toString());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "newB is null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "newA is null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("NE1XMTest3 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        logger.log(System.Logger.Level.TRACE, "Entered createB method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)b);
        this.getEntityTransaction().commit();
    }

    private B findB(String id) {
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private List findByName(String name) {
        logger.log(System.Logger.Level.TRACE, "Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getResultList();
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataA(Collection c) {
        logger.log(System.Logger.Level.TRACE, "collection Data");
        logger.log(System.Logger.Level.TRACE, "---------------");
        logger.log(System.Logger.Level.TRACE, "- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            A v = (A)i.next();
            logger.log(System.Logger.Level.TRACE, "- Element #" + elem++);
            logger.log(System.Logger.Level.TRACE, "  id=" + v.getAId() + ", name=" + v.getAName() + ", value=" + v.getAValue());
        }
    }

    private void dumpCollectionDataB(Collection c) {
        logger.log(System.Logger.Level.TRACE, "collection Data");
        logger.log(System.Logger.Level.TRACE, "---------------");
        logger.log(System.Logger.Level.TRACE, "- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            logger.log(System.Logger.Level.TRACE, "- Element #" + elem++);
            logger.log(System.Logger.Level.TRACE, "  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue());
        }
    }

    public B getBFromCollection(Collection c, B b) {
        logger.log(System.Logger.Level.TRACE, "getBFromCollection");
        B resultB = null;
        if (c.size() != 0) {
            for (B newB : c) {
                if (newB.getBId().equals(b.getBId()) && newB.getBName().equals(b.getBName()) && newB.getBValue() == b.getBValue()) {
                    logger.log(System.Logger.Level.TRACE, "Found B in Collection");
                    resultB = newB;
                    return resultB;
                }
                logger.log(System.Logger.Level.TRACE, "b not found in Collection");
            }
        }
        return resultB;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM ANE_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BNE_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

