/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.descriptors;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.descriptors.XAddress;
import ee.jakarta.tck.persistence.core.relationship.descriptors.XAnnualReview;
import ee.jakarta.tck.persistence.core.relationship.descriptors.XCompany;
import ee.jakarta.tck.persistence.core.relationship.descriptors.XInsurance;
import ee.jakarta.tck.persistence.core.relationship.descriptors.XPerson;
import ee.jakarta.tck.persistence.core.relationship.descriptors.XProject;
import ee.jakarta.tck.persistence.core.relationship.descriptors.XTeam;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final XAddress[] aRef = new XAddress[5];
    private static final XAnnualReview[] rRef = new XAnnualReview[10];
    private static final XCompany[] cRef = new XCompany[5];
    private static final XInsurance[] insRef = new XInsurance[5];
    private static final XPerson[] pRef = new XPerson[20];
    private static final XProject[] projRef = new XProject[10];
    private static final XTeam[] tRef = new XTeam[10];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "XAddress", pkgName + "XAnnualReview", pkgName + "XCompany", pkgName + "XInsurance", pkgName + "XPerson", pkgName + "XProject", pkgName + "XTeam"};
        return this.createDeploymentJar("jpa_core_relationship_descriptors.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void descriptorMappingTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin descriptorMappingTest1");
        boolean pass = false;
        try {
            this.createPeople();
            this.createProjects();
            this.getEntityTransaction().begin();
            pRef[0].setXProject(projRef[2]);
            projRef[2].setXProjectLead(pRef[0]);
            this.getEntityManager().merge((Object)pRef[0]);
            this.getEntityManager().merge((Object)projRef[2]);
            XPerson newPerson = (XPerson)this.getEntityManager().find(XPerson.class, (Object)1);
            if (newPerson.getXProject().getXName().equals("Asp")) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("descriptorMappingTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void descriptorMappingTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin descriptorMappingTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        int foundTeam1 = 0;
        int foundTeam2 = 0;
        String[] expectedTeam1 = new String[]{"Engineering", "Marketing", "Sales"};
        String[] expectedTeam2 = new String[]{"Accounting", "Training"};
        try {
            this.createTeams();
            this.createCompany();
            this.getEntityTransaction().begin();
            tRef[0].setXCompany(cRef[0]);
            tRef[1].setXCompany(cRef[0]);
            tRef[2].setXCompany(cRef[0]);
            Vector<XTeam> v1 = new Vector<XTeam>();
            v1.add(tRef[0]);
            v1.add(tRef[1]);
            v1.add(tRef[2]);
            cRef[0].setXTeams(v1);
            tRef[3].setXCompany(cRef[1]);
            tRef[4].setXCompany(cRef[1]);
            Vector<XTeam> v2 = new Vector<XTeam>();
            v2.add(tRef[3]);
            v2.add(tRef[4]);
            cRef[1].setXTeams(v2);
            this.getEntityManager().merge((Object)tRef[0]);
            this.getEntityManager().merge((Object)tRef[1]);
            this.getEntityManager().merge((Object)tRef[2]);
            this.getEntityManager().merge((Object)tRef[3]);
            this.getEntityManager().merge((Object)tRef[4]);
            this.getEntityManager().merge((Object)cRef[0]);
            this.getEntityManager().merge((Object)cRef[1]);
            this.getEntityManager().flush();
            XCompany c1 = (XCompany)this.getEntityManager().find(XCompany.class, (Object)25501L);
            Collection<XTeam> t1 = c1.getXTeams();
            XCompany c2 = (XCompany)this.getEntityManager().find(XCompany.class, (Object)37560L);
            Collection<XTeam> t2 = c2.getXTeams();
            if (t1.size() != 3 || t2.size() != 2) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest2: Did not get expected results.Team1 Collection Expected 3 references, got: " + t1.size() + ", Team2 Collection Expected 2 references, got: " + t2.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<XTeam> i1 = t1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Team 1 Collection for expected Teams");
                    XTeam o1 = i1.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedTeam1[l].equals(o1.getXName())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Team 1:" + o1.getXName());
                        ++foundTeam1;
                        continue block11;
                    }
                }
                Iterator<XTeam> i2 = t2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Team 2 Collection for expected Teams");
                    XTeam o2 = i2.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedTeam2[l].equals(o2.getXName())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Team 2:" + o2.getXName());
                        ++foundTeam2;
                        continue block13;
                    }
                }
            }
            if (foundTeam1 != 3 || foundTeam2 != 2) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest2: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass2) {
            throw new Exception("descriptorMappingTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void descriptorMappingTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin descriptorMappingTest3");
        boolean pass = false;
        try {
            this.createTeams();
            this.createCompany();
            this.getEntityTransaction().begin();
            tRef[0].setXCompany(cRef[0]);
            tRef[1].setXCompany(cRef[0]);
            Vector<XTeam> v1 = new Vector<XTeam>();
            v1.add(tRef[0]);
            v1.add(tRef[1]);
            cRef[0].setXTeams(v1);
            tRef[2].setXCompany(cRef[1]);
            tRef[3].setXCompany(cRef[1]);
            tRef[4].setXCompany(cRef[1]);
            Vector<XTeam> v2 = new Vector<XTeam>();
            v2.add(tRef[2]);
            v2.add(tRef[3]);
            v2.add(tRef[4]);
            cRef[1].setXTeams(v2);
            this.getEntityManager().merge((Object)tRef[0]);
            this.getEntityManager().merge((Object)tRef[1]);
            this.getEntityManager().merge((Object)tRef[2]);
            this.getEntityManager().merge((Object)tRef[3]);
            this.getEntityManager().merge((Object)tRef[4]);
            this.getEntityManager().merge((Object)cRef[0]);
            this.getEntityManager().merge((Object)cRef[1]);
            this.getEntityManager().flush();
            XTeam t1 = (XTeam)this.getEntityManager().find(XTeam.class, (Object)1);
            XTeam t2 = (XTeam)this.getEntityManager().find(XTeam.class, (Object)2);
            XTeam t3 = (XTeam)this.getEntityManager().find(XTeam.class, (Object)3);
            XTeam t4 = (XTeam)this.getEntityManager().find(XTeam.class, (Object)4);
            XTeam t5 = (XTeam)this.getEntityManager().find(XTeam.class, (Object)5);
            if (t1.getXCompany().getXCompanyId() == 25501L && t2.getXCompany().getXCompanyId() == 25501L && t3.getXCompany().getXCompanyId() == 37560L && t4.getXCompany().getXCompanyId() == 37560L && t5.getXCompany().getXCompanyId() == 37560L) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("descriptorMappingTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void descriptorMappingTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin descriptorMappingTest4");
        boolean pass = false;
        try {
            this.createAddress();
            this.createCompany();
            this.getEntityTransaction().begin();
            cRef[0].setXAddress(aRef[0]);
            cRef[1].setXAddress(aRef[1]);
            this.getEntityManager().merge((Object)cRef[0]);
            this.getEntityManager().merge((Object)cRef[1]);
            this.getEntityManager().flush();
            XCompany c1 = (XCompany)this.getEntityManager().find(XCompany.class, (Object)25501L);
            XCompany c2 = (XCompany)this.getEntityManager().find(XCompany.class, (Object)37560L);
            if (c1.getXAddress().getXCity().equals("Burlington") && c2.getXAddress().getXCity().equals("Santa Clara")) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected resultsExpected: Burlington and Santa Clara, got: " + c1.getXAddress().getXCity() + c2.getXAddress().getXCity());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("descriptorMappingTest4 failed");
        }
    }

    @Test
    public void descriptorMappingTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin descriptorMappingTest5");
        boolean pass = false;
        try {
            this.createTeams();
            this.createPeople();
            this.getEntityTransaction().begin();
            pRef[1].setXTeam(tRef[0]);
            pRef[3].setXTeam(tRef[1]);
            pRef[5].setXTeam(tRef[2]);
            pRef[7].setXTeam(tRef[3]);
            pRef[9].setXTeam(tRef[4]);
            pRef[2].setXTeam(tRef[4]);
            pRef[4].setXTeam(tRef[3]);
            pRef[6].setXTeam(tRef[2]);
            pRef[8].setXTeam(tRef[1]);
            pRef[10].setXTeam(tRef[0]);
            for (int i = 1; i < 11; ++i) {
                this.getEntityManager().merge((Object)pRef[i]);
            }
            this.getEntityManager().flush();
            if (pRef[1].getXTeam() == tRef[0] && pRef[10].getXTeam() == tRef[0] && pRef[3].getXTeam() == tRef[1] && pRef[8].getXTeam() == tRef[1] && pRef[5].getXTeam() == tRef[2] && pRef[6].getXTeam() == tRef[2] && pRef[7].getXTeam() == tRef[3] && pRef[4].getXTeam() == tRef[3] && pRef[9].getXTeam() == tRef[4] && pRef[2].getXTeam() == tRef[4]) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("descriptorMappingTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void descriptorMappingTest6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin descriptorMappingTest6");
        boolean pass1 = true;
        boolean pass2 = false;
        int foundProject1 = 0;
        int foundProject2 = 0;
        Long[] expectedResults1 = new Long[]{123456789L, 345678901L, 567890123L};
        Long[] expectedResults2 = new Long[]{234567890L, 345678901L, 456789012L};
        try {
            this.createPeople();
            this.createProjects();
            this.getEntityTransaction().begin();
            pRef[5].getXProjects().add(projRef[0]);
            pRef[5].getXProjects().add(projRef[2]);
            pRef[5].getXProjects().add(projRef[4]);
            this.getEntityManager().merge((Object)pRef[5]);
            pRef[8].getXProjects().add(projRef[1]);
            pRef[8].getXProjects().add(projRef[2]);
            pRef[8].getXProjects().add(projRef[3]);
            this.getEntityManager().merge((Object)pRef[8]);
            projRef[0].getXPersons().add(pRef[5]);
            this.getEntityManager().merge((Object)projRef[0]);
            projRef[1].getXPersons().add(pRef[8]);
            this.getEntityManager().merge((Object)projRef[1]);
            projRef[2].getXPersons().add(pRef[5]);
            this.getEntityManager().merge((Object)projRef[2]);
            projRef[2].getXPersons().add(pRef[8]);
            this.getEntityManager().merge((Object)projRef[2]);
            projRef[3].getXPersons().add(pRef[8]);
            this.getEntityManager().merge((Object)projRef[3]);
            projRef[4].getXPersons().add(pRef[5]);
            this.getEntityManager().merge((Object)projRef[4]);
            this.getEntityManager().flush();
            XPerson p1 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)6);
            XPerson p2 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)9);
            Collection<XProject> projCol1 = p1.getXProjects();
            Collection<XProject> projCol2 = p2.getXProjects();
            if (projCol1.size() != 3 || projCol2.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest6: Did not get expected results.Expected 3 Projects for Karen Tegan (PK 6) , got: " + projCol1.size() + ", Expected 2 Projects for William Keaton (PK 9), got: " + projCol2.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<XProject> i1 = projCol1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Karen Tegan Projects");
                    XProject o1 = i1.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedResults1[l].equals(o1.getXProjId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Project for Karen Tegan: " + o1.getXName());
                        ++foundProject1;
                        continue block11;
                    }
                }
                Iterator<XProject> i2 = projCol2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for William Keaton Projects");
                    XProject o2 = i2.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedResults2[l].equals(o2.getXProjId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Project for William Keaton: " + o2.getXName());
                        ++foundProject2;
                        continue block13;
                    }
                }
            }
            if (foundProject1 != 3 || foundProject2 != 3) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest6: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            Vector<XPerson> nullPersonCol = new Vector<XPerson>();
            projRef[0].setXPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[0]);
            projRef[1].setXPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[1]);
            projRef[2].setXPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[2]);
            projRef[3].setXPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[3]);
            projRef[4].setXPersons(nullPersonCol);
            this.getEntityManager().merge((Object)projRef[4]);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("descriptorMappingTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void descriptorMappingTest7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin descriptorMappingTest7");
        boolean pass1 = true;
        boolean pass2 = false;
        Vector<XAnnualReview> v1 = null;
        Vector<XAnnualReview> v2 = null;
        Vector<XAnnualReview> v3 = null;
        Vector<XAnnualReview> v4 = null;
        int foundCol1 = 0;
        int foundCol2 = 0;
        int foundCol3 = 0;
        int foundCol4 = 0;
        int foundCol5 = 0;
        Integer[] expectedCol1 = new Integer[]{1, 2, 3, 4};
        Integer[] expectedCol2 = new Integer[]{5, 6};
        Integer[] expectedCol3 = new Integer[]{3, 8};
        Integer[] expectedCol4 = new Integer[]{4, 7};
        Integer[] expectedCol5 = new Integer[]{1, 2, 3, 4};
        try {
            this.createReviews();
            this.createPeople();
            this.getEntityTransaction().begin();
            v1 = new Vector<XAnnualReview>();
            v1.add(rRef[0]);
            v1.add(rRef[1]);
            v1.add(rRef[2]);
            v1.add(rRef[3]);
            v2 = new Vector<XAnnualReview>();
            v2.add(rRef[4]);
            v2.add(rRef[5]);
            v3 = new Vector<XAnnualReview>();
            v3.add(rRef[2]);
            v3.add(rRef[7]);
            v4 = new Vector<XAnnualReview>();
            v4.add(rRef[3]);
            v4.add(rRef[6]);
            pRef[11].setXAnnualReviews(v1);
            pRef[13].setXAnnualReviews(v2);
            pRef[15].setXAnnualReviews(v3);
            pRef[17].setXAnnualReviews(v4);
            pRef[19].setXAnnualReviews(v1);
            this.getEntityManager().merge((Object)pRef[11]);
            this.getEntityManager().merge((Object)pRef[13]);
            this.getEntityManager().merge((Object)pRef[15]);
            this.getEntityManager().merge((Object)pRef[17]);
            this.getEntityManager().merge((Object)pRef[19]);
            this.getEntityManager().flush();
            XPerson p1 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)12);
            XPerson p2 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)14);
            XPerson p3 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)16);
            XPerson p4 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)18);
            XPerson p5 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)20);
            Collection<XAnnualReview> col1 = p1.getXAnnualReviews();
            Collection<XAnnualReview> col2 = p2.getXAnnualReviews();
            Collection<XAnnualReview> col3 = p3.getXAnnualReviews();
            Collection<XAnnualReview> col4 = p4.getXAnnualReviews();
            Collection<XAnnualReview> col5 = p5.getXAnnualReviews();
            if (col1.size() != 4 || col2.size() != 2 || col3.size() != 2 || col4.size() != 2 || col5.size() != 4) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest7: Did not get expected results.Expected 4 reviews for Mary Macy (PK 12) , got: " + col1.size() + ", Expected 2 reviews for Julie OClaire (PK 14), got: " + col2.size() + ", Expected 2 reviews for Kellie Lee (PK 16), got: " + col3.size() + ", Expected 2 reviews for Mark Francis (PK 18), got: " + col4.size() + ", Expected 4 reviews for Katy Hughes (PK 20), got: " + col5.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<XAnnualReview> i1 = col1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Mary Macy Reviews");
                    XAnnualReview o1 = i1.next();
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedCol1[l].equals(o1.getXService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Mary Macy Annual Review for Service Year: " + o1.getXService());
                        ++foundCol1;
                        continue block11;
                    }
                }
                Iterator<XAnnualReview> i2 = col2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Julie OClaire Reviews");
                    XAnnualReview o2 = i2.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedCol2[l].equals(o2.getXService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Julie OClaire Annual Review for Service Year: " + o2.getXService());
                        ++foundCol2;
                        continue block13;
                    }
                }
                Iterator<XAnnualReview> i3 = col3.iterator();
                block15: while (i3.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Kellie Lee Reviews");
                    XAnnualReview o3 = i3.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedCol3[l].equals(o3.getXService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Kellie Lee Annual Review for Service Year: " + o3.getXService());
                        ++foundCol3;
                        continue block15;
                    }
                }
                Iterator<XAnnualReview> i4 = col4.iterator();
                block17: while (i4.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Mark Francis Reviews");
                    XAnnualReview o4 = i4.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedCol4[l].equals(o4.getXService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Mark Francis Annual Review for Service Year: " + o4.getXService());
                        ++foundCol4;
                        continue block17;
                    }
                }
                Iterator<XAnnualReview> i5 = col5.iterator();
                block19: while (i5.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Collection for Katy Hughes Reviews");
                    XAnnualReview o5 = i5.next();
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedCol5[l].equals(o5.getXService())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Katy Hughes Annual Review for Service Year: " + o5.getXService());
                        ++foundCol5;
                        continue block19;
                    }
                }
            }
            if (foundCol1 != 4 || foundCol2 != 2 || foundCol3 != 2 || foundCol4 != 2 || foundCol5 != 4) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest7: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("descriptorMappingTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void descriptorMappingTest8() throws Exception {
        boolean pass1 = true;
        boolean pass2 = false;
        int foundInsurance1 = 0;
        int foundInsurance2 = 0;
        int foundInsurance3 = 0;
        Integer[] expectedResults1 = new Integer[]{1, 3};
        Integer[] expectedResults2 = new Integer[]{2, 3};
        Integer[] expectedResults3 = new Integer[]{1, 2, 3};
        try {
            this.createPeople();
            this.createInsurance();
            this.getEntityTransaction().begin();
            pRef[2].getXInsurance().add(insRef[0]);
            pRef[2].getXInsurance().add(insRef[2]);
            this.getEntityManager().merge((Object)pRef[2]);
            pRef[12].getXInsurance().add(insRef[1]);
            pRef[12].getXInsurance().add(insRef[2]);
            this.getEntityManager().merge((Object)pRef[12]);
            pRef[16].getXInsurance().add(insRef[0]);
            pRef[16].getXInsurance().add(insRef[1]);
            pRef[16].getXInsurance().add(insRef[2]);
            this.getEntityManager().merge((Object)pRef[16]);
            this.getEntityManager().flush();
            XPerson p1 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)3);
            XPerson p2 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)13);
            XPerson p3 = (XPerson)this.getEntityManager().find(XPerson.class, (Object)17);
            Collection<XInsurance> insCol1 = p1.getXInsurance();
            Collection<XInsurance> insCol2 = p2.getXInsurance();
            Collection<XInsurance> insCol3 = p3.getXInsurance();
            if (insCol1.size() != 2 || insCol2.size() != 2 || insCol3.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest8: Did not get expected results.Expected 2 Insurance Carriers for Shelly McGowan (PK 3) , got: " + insCol1.size() + ", Expected 2 Insurance Carriers for Cheng Fang (PK 13) , got: " + insCol2.size() + ", Expected 3 Insurance Carriers for Nicole Martin (PK 17), got: " + insCol3.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<XInsurance> i1 = insCol1.iterator();
                block11: while (i1.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Insurance Carriers for Shelly McGowan");
                    XInsurance o1 = i1.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedResults1[l].equals(o1.getXInsId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Insurance Carrier for Shelly McGowan: " + o1.getXCarrier());
                        ++foundInsurance1;
                        continue block11;
                    }
                }
                Iterator<XInsurance> i2 = insCol2.iterator();
                block13: while (i2.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Insurance Carriers for Cheng Fang");
                    XInsurance o2 = i2.next();
                    for (int l = 0; l < 2; ++l) {
                        if (!expectedResults2[l].equals(o2.getXInsId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Insurance Carrier for Cheng Fang: " + o2.getXCarrier());
                        ++foundInsurance2;
                        continue block13;
                    }
                }
                Iterator<XInsurance> i3 = insCol3.iterator();
                block15: while (i3.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check Insurance Carriers for Nicole Martin");
                    XInsurance o3 = i3.next();
                    for (int l = 0; l < 3; ++l) {
                        if (!expectedResults3[l].equals(o3.getXInsId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found Insurance Carrier for Nicole Martin: " + o3.getXCarrier());
                        ++foundInsurance3;
                        continue block15;
                    }
                }
            }
            if (foundInsurance1 != 2 || foundInsurance2 != 2 || foundInsurance3 != 3) {
                logger.log(System.Logger.Level.ERROR, "descriptorMappingTest8: Did not get expected results");
                pass2 = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("descriptorMappingTest8 failed");
        }
    }

    private void createPeople() throws Exception {
        logger.log(System.Logger.Level.TRACE, "CreatePeople");
        logger.log(System.Logger.Level.TRACE, "Create 20 People");
        Client.pRef[0] = new XPerson(1, "Alan", "Frechette");
        Client.pRef[1] = new XPerson(2, "Arthur", "Frechette");
        Client.pRef[2] = new XPerson(3, "Shelly", "McGowan");
        Client.pRef[3] = new XPerson(4, "Robert", "Bissett");
        Client.pRef[4] = new XPerson(5, "Stephen", "DMilla");
        Client.pRef[5] = new XPerson(6, "Karen", "Tegan");
        Client.pRef[6] = new XPerson(7, "Stephen", "Cruise");
        Client.pRef[7] = new XPerson(8, "Irene", "Caruso");
        Client.pRef[8] = new XPerson(9, "William", "Keaton");
        Client.pRef[9] = new XPerson(10, "Kate", "Hudson");
        Client.pRef[10] = new XPerson(11, "Jonathan", "Smith");
        Client.pRef[11] = new XPerson(12, "Mary", "Macy");
        Client.pRef[12] = new XPerson(13, "Cheng", "Fang");
        Client.pRef[13] = new XPerson(14, "Julie", "OClaire");
        Client.pRef[14] = new XPerson(15, "Steven", "Rich");
        Client.pRef[15] = new XPerson(16, "Kellie", "Lee");
        Client.pRef[16] = new XPerson(17, "Nicole", "Martin");
        Client.pRef[17] = new XPerson(18, "Mark", "Francis");
        Client.pRef[18] = new XPerson(19, "Will", "Forrest");
        Client.pRef[19] = new XPerson(20, "Katy", "Hughes");
        logger.log(System.Logger.Level.TRACE, "Start to persist people ");
        this.getEntityTransaction().begin();
        for (XPerson p : pRef) {
            this.getEntityManager().persist((Object)p);
            logger.log(System.Logger.Level.TRACE, "persisted person " + p);
        }
        this.getEntityTransaction().commit();
    }

    private void createTeams() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 5 Teams");
        Client.tRef[0] = new XTeam(1, "Engineering");
        Client.tRef[1] = new XTeam(2, "Marketing");
        Client.tRef[2] = new XTeam(3, "Sales");
        Client.tRef[3] = new XTeam(4, "Accounting");
        Client.tRef[4] = new XTeam(5, "Training");
        logger.log(System.Logger.Level.TRACE, "Start to persist teams ");
        this.getEntityTransaction().begin();
        for (XTeam t : tRef) {
            if (t == null) continue;
            this.getEntityManager().persist((Object)t);
            logger.log(System.Logger.Level.TRACE, "persisted team " + t);
        }
        this.getEntityTransaction().commit();
    }

    private void createInsurance() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 3 Insurance Carriers");
        Client.insRef[0] = new XInsurance(1, "Prudential");
        Client.insRef[1] = new XInsurance(2, "Cigna");
        Client.insRef[2] = new XInsurance(3, "Sentry");
        logger.log(System.Logger.Level.TRACE, "Start to persist insurance ");
        this.getEntityTransaction().begin();
        for (XInsurance i : insRef) {
            if (i == null) continue;
            this.getEntityManager().persist((Object)i);
            logger.log(System.Logger.Level.TRACE, "persisted insurance " + i);
        }
        this.getEntityTransaction().commit();
    }

    private void createProjects() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 5 Projects");
        Client.projRef[0] = new XProject(123456789L, "Sidewinder", new BigDecimal("20500.0"));
        Client.projRef[1] = new XProject(234567890L, "Boa", new BigDecimal("75000.0"));
        Client.projRef[2] = new XProject(345678901L, "Asp", new BigDecimal("500000.0"));
        Client.projRef[3] = new XProject(456789012L, "King Cobra", new BigDecimal("250000.0"));
        Client.projRef[4] = new XProject(567890123L, "Python", new BigDecimal("1000.0"));
        logger.log(System.Logger.Level.TRACE, "Start to persist projects ");
        this.getEntityTransaction().begin();
        for (XProject p : projRef) {
            if (p == null) continue;
            this.getEntityManager().persist((Object)p);
            logger.log(System.Logger.Level.TRACE, "persisted project " + p);
        }
        this.getEntityTransaction().commit();
    }

    private void createCompany() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 2 Companies");
        Client.cRef[0] = new XCompany(25501L, "American Gifts");
        Client.cRef[1] = new XCompany(37560L, "Planet Earth");
        logger.log(System.Logger.Level.TRACE, "Start to persist companies ");
        this.getEntityTransaction().begin();
        for (XCompany c : cRef) {
            if (c == null) continue;
            this.getEntityManager().persist((Object)c);
            logger.log(System.Logger.Level.TRACE, "persisted company " + c);
        }
        this.getEntityTransaction().commit();
    }

    private void createAddress() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 2 Addresses");
        Client.aRef[0] = new XAddress("100", "1 Network Drive", "Burlington", "MA", "01803");
        Client.aRef[1] = new XAddress("200", "4150 Network Drive", "Santa Clara", "CA", "95054");
        logger.log(System.Logger.Level.TRACE, "Start to persist addresses ");
        this.getEntityTransaction().begin();
        for (XAddress a : aRef) {
            if (a == null) continue;
            this.getEntityManager().persist((Object)a);
            logger.log(System.Logger.Level.TRACE, "persisted address " + a);
        }
        this.getEntityTransaction().commit();
    }

    private void createReviews() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Create 5 Addresses");
        Client.rRef[0] = new XAnnualReview(1, 1);
        Client.rRef[1] = new XAnnualReview(2, 2);
        Client.rRef[2] = new XAnnualReview(3, 3);
        Client.rRef[3] = new XAnnualReview(4, 4);
        Client.rRef[4] = new XAnnualReview(5, 5);
        Client.rRef[5] = new XAnnualReview(6, 6);
        Client.rRef[6] = new XAnnualReview(7, 7);
        Client.rRef[7] = new XAnnualReview(8, 8);
        logger.log(System.Logger.Level.TRACE, "Start to persist annual reviews ");
        this.getEntityTransaction().begin();
        for (XAnnualReview a : rRef) {
            if (a == null) continue;
            this.getEntityManager().persist((Object)a);
            logger.log(System.Logger.Level.TRACE, "persisted annual reviews " + a);
        }
        this.getEntityTransaction().commit();
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PERSON_INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PERSON_ANNUALREVIEW").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ANNUALREVIEW").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM TEAM").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM COMPANY").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PROJECT_PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

