/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.datetime;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.types.datetime.DateTimeEntity;
import ee.jakarta.tck.persistence.core.types.datetime.DummyEntity;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;
    private static final Instant INSTANT_DEF = Instant.ofEpochSecond(0L);
    private static final Instant INSTANT = Instant.now();
    private static final LocalDate LOCAL_DATE_DEF = LocalDate.of(1970, 1, 1);
    private static final LocalDate LOCAL_DATE = LocalDate.now();
    private static final LocalTime LOCAL_TIME_DEF = LocalTime.of(0, 0, 0);
    private static final LocalTime LOCAL_TIME = LocalTime.now();
    private static final LocalDateTime LOCAL_DATE_TIME_DEF = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private static final LocalDateTime LOCAL_DATE_TIME = Client.initLocalDateTime();
    private static final OffsetTime OFFSET_TIME_DEF = OffsetTime.of(LOCAL_TIME_DEF, ZoneOffset.ofHours(1));
    private static final OffsetTime OFFSET_TIME = OffsetTime.of(LOCAL_TIME, ZoneOffset.ofHours(0));
    private static final OffsetDateTime OFFSET_DATE_TIME_DEF = OffsetDateTime.of(LOCAL_DATE_TIME_DEF, ZoneOffset.ofHours(1));
    private static final OffsetDateTime OFFSET_DATE_TIME = OffsetDateTime.of(LOCAL_DATE_TIME, ZoneOffset.ofHours(0));
    private static final Year YEAR_DEF = Year.of(0);
    private static final Year YEAR = Year.now();
    private static final DateTimeEntity[] entities = new DateTimeEntity[]{new DateTimeEntity(1L, INSTANT_DEF, LOCAL_DATE, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF, YEAR_DEF), new DateTimeEntity(2L, INSTANT_DEF, LOCAL_DATE_DEF, LOCAL_TIME, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF, YEAR_DEF), new DateTimeEntity(3L, INSTANT_DEF, LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF, YEAR_DEF), new DateTimeEntity(4L, INSTANT_DEF, LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME, OFFSET_DATE_TIME_DEF, YEAR_DEF), new DateTimeEntity(5L, INSTANT_DEF, LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME, YEAR_DEF), new DateTimeEntity(6L, INSTANT, LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF, YEAR_DEF), new DateTimeEntity(7L, INSTANT_DEF, LOCAL_DATE_DEF, LOCAL_TIME_DEF, LOCAL_DATE_TIME_DEF, OFFSET_TIME_DEF, OFFSET_DATE_TIME_DEF, YEAR)};

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DateTimeEntity", pkgName + "DummyEntity"};
        return this.createDeploymentJar("jpa_datetime.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Setup: Jakarta Persistence Java 8 date and time types test");
        try {
            super.setup();
            this.createDeployment();
            Properties props = this.getPersistenceUnitProperties();
            props.put("jakarta.persistence.schema-generation.database.action", "drop-and-create");
            props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
            this.displayProperties(props);
            logger.log(System.Logger.Level.INFO, " - executing persistence schema generation");
            Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
            this.clearEMAndEMF();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "caught Exception: ", (Throwable)e);
            throw new Exception(" ! Jakarta Persistence Java 8 date and time types test setup failed", e);
        }
        this.verifySchema();
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Cleanup: Jakarta Persistence 2.2 Java 8 date and time types test");
            Properties props = this.getPersistenceUnitProperties();
            props.put("jakarta.persistence.schema-generation.database.action", "drop");
            this.displayProperties(props);
            logger.log(System.Logger.Level.INFO, " - executing persistence schema cleanup");
            Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
            this.closeEMAndEMF();
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private static LocalDateTime initLocalDateTime() {
        LocalDateTime value = LocalDateTime.now();
        return value.withNano(value.getNano() / 1000000 * 1000000);
    }

    @Test
    public void dateTimeTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "Test: Jakarta Persistence Java 8 date and time types");
        this.verifySchema();
        boolean createResult = this.createEntities();
        boolean allFindResult = true;
        boolean[] findResults = new boolean[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            findResults[i] = this.findEntityById(entities[i]);
        }
        boolean localDateResult = this.queryEntities("DateTimeEntity.findByLocalDate", "date", LOCAL_DATE, entities[0]);
        boolean localTimeResult = this.queryEntities("DateTimeEntity.findByLocalTime", "time", LOCAL_TIME, entities[1]);
        boolean localDateTimeResult = this.queryEntities("DateTimeEntity.findByLocalDateTime", "dateTime", LOCAL_DATE_TIME, entities[2]);
        boolean offsetTimeResult = this.queryEntities("DateTimeEntity.findByOffsetTime", "time", OFFSET_TIME, entities[3]);
        boolean offsetDateTimeResult = this.queryEntities("DateTimeEntity.findByOffsetDateTime", "dateTime", OFFSET_DATE_TIME, entities[4]);
        boolean instantResult = this.queryEntities("DateTimeEntity.findByInstant", "instant", INSTANT, entities[5]);
        boolean yearResult = this.queryEntities("DateTimeEntity.findByYear", "year", YEAR, entities[6]);
        boolean localDateRangeResult = this.queryEntitiesRange("DateTimeEntity.findLocalDateRange", "min", LOCAL_DATE.minus(10L, ChronoUnit.DAYS), "max", LOCAL_DATE.plus(10L, ChronoUnit.DAYS), entities[0]);
        boolean localTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findLocalTimeRange", "min", LOCAL_TIME.minus(10L, ChronoUnit.MINUTES), "max", LOCAL_TIME.plus(10L, ChronoUnit.MINUTES), entities[1]);
        boolean localDateTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findLocalDateTimeRange", "min", LOCAL_DATE_TIME.minus(10L, ChronoUnit.DAYS), "max", LOCAL_DATE_TIME.plus(10L, ChronoUnit.DAYS), entities[2]);
        boolean offsetTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findOffsetTimeRange", "min", OFFSET_TIME.minus(10L, ChronoUnit.MINUTES), "max", OFFSET_TIME.plus(10L, ChronoUnit.MINUTES), entities[3]);
        boolean offsetDateTimeRangeResult = this.queryEntitiesRange("DateTimeEntity.findOffsetDateTimeRange", "min", OFFSET_DATE_TIME.minus(10L, ChronoUnit.DAYS).minus(10L, ChronoUnit.MINUTES), "max", OFFSET_DATE_TIME.plus(10L, ChronoUnit.DAYS).plus(10L, ChronoUnit.MINUTES), entities[4]);
        boolean instantRangeResult = this.queryEntitiesRange("DateTimeEntity.findByInstantRange", "min", INSTANT.minus(10L, ChronoUnit.DAYS).minus(10L, ChronoUnit.MINUTES), "max", INSTANT.plus(10L, ChronoUnit.DAYS).plus(10L, ChronoUnit.MINUTES), entities[5]);
        boolean yearRangeResult = this.queryEntitiesRange("DateTimeEntity.findByYearRange", "min", YEAR.minus(10L, ChronoUnit.YEARS), "max", YEAR.plus(10L, ChronoUnit.YEARS), entities[6]);
        logger.log(System.Logger.Level.INFO, "--------------------------------------------------------------------------------");
        logger.log(System.Logger.Level.INFO, " - Jakarta Persistence Java 8 date and time types test results:");
        this.logTestResult("Entities creation", createResult);
        for (int i = 0; i < entities.length; ++i) {
            this.logTestResult("Find by ID=" + entities[i].getId().toString(), findResults[i]);
            allFindResult = allFindResult && findResults[i];
        }
        this.logTestResult("Query DateTimeEntity.findByLocalDate", localDateResult);
        this.logTestResult("Query DateTimeEntity.findByLocalTime", localTimeResult);
        this.logTestResult("Query DateTimeEntity.findByLocalDateTime", localDateTimeResult);
        this.logTestResult("Query DateTimeEntity.findByOffsetTime", offsetTimeResult);
        this.logTestResult("Query DateTimeEntity.findByOffsetDateTime", offsetDateTimeResult);
        this.logTestResult("Query DateTimeEntity.findByInstant", instantResult);
        this.logTestResult("Query DateTimeEntity.findByYear", yearResult);
        this.logTestResult("Query DateTimeEntity.findLocalDateRange", localDateRangeResult);
        this.logTestResult("Query DateTimeEntity.findLocalTimeRange", localTimeRangeResult);
        this.logTestResult("Query DateTimeEntity.findLocalDateTimeRange", localDateTimeRangeResult);
        this.logTestResult("Query DateTimeEntity.findOffsetTimeRange", offsetTimeRangeResult);
        this.logTestResult("Query DateTimeEntity.findOffsetDateTimeRange", offsetDateTimeRangeResult);
        this.logTestResult("Query DateTimeEntity.findByInstantRange", instantRangeResult);
        this.logTestResult("Query DateTimeEntity.findByYearRange", yearRangeResult);
        logger.log(System.Logger.Level.INFO, "--------------------------------------------------------------------------------");
        if (!(createResult && allFindResult && localDateResult && localTimeResult && localDateTimeResult && offsetTimeResult && offsetDateTimeResult && instantResult && yearResult && localDateRangeResult && localTimeRangeResult && localDateTimeRangeResult && offsetTimeRangeResult && offsetDateTimeRangeResult && instantRangeResult && yearRangeResult)) {
            throw new Exception("dateTimeTest (Jakarta Persistence Java 8 date and time types test) failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createEntities() {
        logger.log(System.Logger.Level.INFO, " - creating test entities");
        try {
            this.getEntityTransaction().begin();
            for (DateTimeEntity e : entities) {
                this.getEntityManager().persist((Object)e);
            }
            this.getEntityTransaction().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "caught Exception: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
    }

    private boolean findEntityById(DateTimeEntity expected) {
        logger.log(System.Logger.Level.INFO, " - executing find by ID=" + expected.getId().toString());
        try {
            DateTimeEntity result = (DateTimeEntity)this.getEntityManager().find(DateTimeEntity.class, (Object)expected.getId());
            if (result == null) {
                logger.log(System.Logger.Level.ERROR, "no result returned for " + expected.toString());
                return false;
            }
            if (!expected.equals(result)) {
                logger.log(System.Logger.Level.ERROR, "returned entity does not match expected");
                logger.log(System.Logger.Level.ERROR, " - expected: " + expected.toString());
                logger.log(System.Logger.Level.ERROR, " - returned: " + result.toString());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "caught Exception: ", (Throwable)e);
            return false;
        }
    }

    private boolean queryEntities(String queryName, String paramName, Object paramValue, DateTimeEntity expected) {
        logger.log(System.Logger.Level.INFO, " - executing query " + queryName + ": " + paramName + "=" + paramValue.toString());
        try {
            TypedQuery query = this.getEntityManager().createNamedQuery(queryName, DateTimeEntity.class);
            query.setParameter(paramName, paramValue);
            List result = query.getResultList();
            if (result == null || result.isEmpty()) {
                logger.log(System.Logger.Level.ERROR, "no result returned for query " + queryName + " with " + paramName + "=" + paramValue.toString());
                return false;
            }
            if (result.size() > 1) {
                logger.log(System.Logger.Level.ERROR, "too many results (" + Integer.toString(result.size()) + ") returned for query " + queryName + " with " + paramName + "=" + paramValue.toString());
                return false;
            }
            DateTimeEntity returned = (DateTimeEntity)result.get(0);
            if (!expected.equals(returned)) {
                logger.log(System.Logger.Level.ERROR, "returned entity does not match expected");
                logger.log(System.Logger.Level.ERROR, " - expected: " + expected.toString());
                logger.log(System.Logger.Level.ERROR, " - returned: " + (returned != null ? returned.toString() : "null"));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "caught Exception: ", (Throwable)e);
            return false;
        }
    }

    private boolean queryEntitiesRange(String queryName, String minName, Object minValue, String maxName, Object maxValue, DateTimeEntity expected) {
        logger.log(System.Logger.Level.INFO, " - executing query " + queryName + ": " + minName + "=" + minValue.toString() + ", " + maxName + "=" + maxValue.toString());
        try {
            TypedQuery query = this.getEntityManager().createNamedQuery(queryName, DateTimeEntity.class);
            query.setParameter(minName, minValue);
            query.setParameter(maxName, maxValue);
            List result = query.getResultList();
            if (result == null || result.isEmpty()) {
                logger.log(System.Logger.Level.ERROR, "no result returned for query " + queryName + " with " + minName + "=" + minValue.toString() + ", " + maxName + "=" + maxValue.toString());
                return false;
            }
            if (result.size() > 1) {
                logger.log(System.Logger.Level.ERROR, "too many results (" + Integer.toString(result.size()) + ") returned for query " + queryName + " with " + minName + "=" + minValue.toString() + ", " + maxName + "=" + maxValue.toString());
                return false;
            }
            DateTimeEntity returned = (DateTimeEntity)result.get(0);
            if (!expected.equals(returned)) {
                logger.log(System.Logger.Level.ERROR, "returned entity does not match expected");
                logger.log(System.Logger.Level.ERROR, " - expected: " + expected.toString());
                logger.log(System.Logger.Level.ERROR, " - returned: " + (returned != null ? returned.toString() : "null"));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "caught Exception: ", (Throwable)e);
            return false;
        }
    }

    private void verifySchema() throws Exception {
        logger.log(System.Logger.Level.INFO, " - executing persistence schema check");
        try {
            this.getEntityTransaction().begin();
            DummyEntity e = new DummyEntity();
            this.getEntityManager().persist((Object)e);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "   - stored " + e.toString());
            DummyEntity result = (DummyEntity)this.getEntityManager().find(DummyEntity.class, (Object)e.getId());
            if (result == null) {
                logger.log(System.Logger.Level.ERROR, "   ! no entity was found");
                throw new Exception("dateTimeTest: Schema verification failed");
            }
            this.getEntityTransaction().begin();
            result = (DummyEntity)this.getEntityManager().merge((Object)result);
            this.getEntityManager().remove((Object)result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "caught Exception: ", (Throwable)e);
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
            throw new Exception("dateTimeTest: Schema verification failed");
        }
    }

    public EntityTransaction getEntityTransaction() {
        if (this.isStandAloneMode() && !super.getEntityTransaction().isActive()) {
            EntityTransaction et = this.getEntityManager().getTransaction();
            this.setEntityTransaction(et);
        }
        return super.getEntityTransaction();
    }

    private void logTestResult(String name, boolean result) {
        StringBuilder sb = new StringBuilder();
        sb.append("   ").append(result ? (char)'+' : '-').append(' ');
        sb.append(name).append(": ");
        sb.append(result ? "PASSED" : "FAILED");
        logger.log(System.Logger.Level.INFO, sb.toString());
    }
}

