/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.repeatable.convert;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.repeatable.convert.Address;
import ee.jakarta.tck.persistence.jpa22.repeatable.convert.B;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "B", pkgName + "DotConverter", pkgName + "Employee3", pkgName + "NumberToStateConverter"};
        return this.createDeploymentJar("jpa_jpa22_repeatable_convert.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void convertsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            String street = "500.Oracle.Parkway";
            String city = "Redwood Shores";
            B b = new B("1", "name1", 1000, new Address(street, city, 1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            B b1 = (B)this.getEntityManager().find(B.class, (Object)b.id);
            logger.log(System.Logger.Level.TRACE, "B:" + b1.toString());
            if (b1.getBValue().equals(1000)) {
                logger.log(System.Logger.Level.TRACE, "Received expected value:" + b1.getBValue());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected value:1000, actual" + b1.getBValue());
            }
            Address a = b1.getAddress();
            if (a.getStreet().equals(street.replace(".", "_"))) {
                logger.log(System.Logger.Level.TRACE, "Received expected street:" + a.getStreet());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected street:" + street + ", actual:" + a.getStreet());
            }
            if (a.getState() == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected state:" + a.getState());
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected state: 1, actual: " + a.getState());
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("convertsTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM B_EMBEDDABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

