/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.schemaGeneration.annotations.orderColumn;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.se.schemaGeneration.annotations.orderColumn.Department;
import ee.jakarta.tck.persistence.se.schemaGeneration.annotations.orderColumn.Employee;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;
    String schemaGenerationDir = null;
    Employee expectedEmployee = null;
    String sTestCase = "jpa_se_schemaGeneration_annotations_orderColumn";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Employee"};
        return this.createDeploymentJar("jpa_se_schemaGeneration_annotations_orderColumn.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.schemaGenerationDir = System.getProperty("user.dir");
            if (!this.schemaGenerationDir.endsWith(File.separator)) {
                this.schemaGenerationDir = this.schemaGenerationDir + File.separator;
            }
            this.schemaGenerationDir = this.schemaGenerationDir + "schemaGeneration";
            logger.log(System.Logger.Level.INFO, "schemaGenerationDir=" + this.schemaGenerationDir);
            File f = new File(this.schemaGenerationDir);
            logger.log(System.Logger.Level.INFO, "Delete existing directory ");
            this.deleteItem(f);
            logger.log(System.Logger.Level.INFO, "Create new directory ");
            if (!f.mkdir()) {
                String msg = "Could not mkdir:" + f.getAbsolutePath();
                throw new Exception(msg);
            }
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void orderColumnTest() throws Exception {
        boolean pass1a = false;
        boolean pass1b = false;
        boolean pass1c = false;
        boolean pass2a = false;
        boolean pass2b = false;
        boolean pass2c = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        logger.log(System.Logger.Level.INFO, "Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        logger.log(System.Logger.Level.TRACE, "Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        logger.log(System.Logger.Level.INFO, "Check script(s) content");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("CREATE TABLE SCHEMAGENEMP");
        expected.add("EMPID");
        expected.add("FK_DEPT");
        expected.add("THEORDERCOLUMN");
        expected.add("PRIMARY KEY (EMPID)");
        pass1a = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("CREATE TABLE SCHEMAGENDEPT");
        expected.add("DEPTID");
        expected.add("PRIMARY KEY (DEPTID)");
        pass1b = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("ALTER TABLE");
        expected.add("SCHEMAGENEMP ADD CONSTRAINT MYCONSTRANT FOREIGN KEY (FK_DEPT) REFERENCES SCHEMAGENDEPT (DEPTID)");
        pass1c = this.findDataInFile(f1, expected);
        expected.clear();
        expected.add("DROP TABLE");
        expected.add("SCHEMAGENEMP");
        pass2a = this.findDataInFile(f2, expected);
        expected.clear();
        expected.add("DROP TABLE");
        expected.add("SCHEMAGENDEPT");
        pass2b = this.findDataInFile(f2, expected);
        expected.clear();
        expected.add("ALTER TABLE");
        expected.add("SCHEMAGENEMP DROP");
        pass2c = this.findDataInFile(f2, expected);
        pass2c = pass2c || this.findDataInFile(f2, List.of("DROP TABLE", "SCHEMAGENEMP", "CASCADE CONSTRAINTS"));
        logger.log(System.Logger.Level.TRACE, "Execute the create script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.create-script-source", this.convertToURI(CREATEFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            logger.log(System.Logger.Level.INFO, "Persist some data");
            this.getEntityTransaction(true).begin();
            Department d1 = new Department(50);
            this.getEntityManager().persist((Object)d1);
            this.expectedEmployee = new Employee(20, d1);
            Employee e2 = new Employee(40, d1);
            Employee e3 = new Employee(60, d1);
            this.getEntityManager().persist((Object)this.expectedEmployee);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().persist((Object)e3);
            ArrayList<Employee> expectedEmployees = new ArrayList<Employee>();
            expectedEmployees.add(e3);
            expectedEmployees.add(this.expectedEmployee);
            expectedEmployees.add(e2);
            d1.setEmployees(expectedEmployees);
            this.getEntityManager().merge((Object)d1);
            logger.log(System.Logger.Level.TRACE, "persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction(true).begin();
            TypedQuery q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.deptId = 50 AND INDEX(e) = 1", Employee.class);
            Employee e = (Employee)q.getSingleResult();
            if (e != null) {
                if (e.equals(this.expectedEmployee)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected:" + this.expectedEmployee);
                    pass3 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "expected:" + this.expectedEmployee + ", actual:" + e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Query of INDEX(1) returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", t);
        }
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.TRACE, "Execute the drop script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.drop-script-source", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        logger.log(System.Logger.Level.INFO, "Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        logger.log(System.Logger.Level.INFO, "Try to persist an entity, it should fail");
        try {
            this.getEntityTransaction(true).begin();
            Employee e2 = new Employee(2);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "An exception should have been thrown if drop had occurred successfully");
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.TRACE, "Receive expected exception");
            pass4 = true;
        }
        try {
            this.getEntityTransaction(true).begin();
            Department d = new Department(2);
            this.getEntityManager().persist((Object)d);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "An exception should have been thrown if drop had occurred successfully");
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.TRACE, "Receive expected exception");
            pass5 = true;
        }
        logger.log(System.Logger.Level.TRACE, "pass1a:" + pass1a);
        logger.log(System.Logger.Level.TRACE, "pass1b:" + pass1b);
        logger.log(System.Logger.Level.TRACE, "pass1c:" + pass1c);
        logger.log(System.Logger.Level.TRACE, "pass2a:" + pass2a);
        logger.log(System.Logger.Level.TRACE, "pass2b:" + pass2b);
        logger.log(System.Logger.Level.TRACE, "pass2c:" + pass2c);
        logger.log(System.Logger.Level.TRACE, "pass3:" + pass3);
        logger.log(System.Logger.Level.TRACE, "pass4:" + pass4);
        logger.log(System.Logger.Level.TRACE, "pass5:" + pass5);
        if (!(pass1a && pass1b && pass1c && pass2a && pass2b && pass2c && pass3 && pass4 && pass5)) {
            throw new Exception("orderColumnTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Try to drop table SCHEMAGENSIMPLE");
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGENEMP").executeUpdate();
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGENDEPT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.INFO, "AN EXCEPTION WAS THROWN DURING DROP TABLE, IT MAY OR MAY NOT BE A PROBLEM, " + t.getMessage());
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
                this.clearEntityTransaction();
                this.clearEMAndEMF();
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

