/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.FallbackMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.FallbackMetricHandler;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.util.MetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FallbackMetricTest
extends Arquillian {
    @Inject
    private FallbackMetricBean fallbackBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricFallback.war")).addClasses(new Class[]{FallbackMetricBean.class, FallbackMetricHandler.class})).addPackage(Packages.UTILS)).addPackage(Packages.METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @Test
    public void fallbackMetricMethodTest() {
        MetricGetter m = new MetricGetter(FallbackMetricBean.class, "doWork");
        m.baselineMetrics();
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        this.fallbackBean.doWork(FallbackMetricBean.Action.PASS);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.doWork(FallbackMetricBean.Action.FAIL);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.FAIL);
        Exceptions.expectTestException(() -> this.fallbackBean.doWork(FallbackMetricBean.Action.FAIL));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        Assert.expectThrows(FallbackMetricBean.NonFallbackException.class, () -> this.fallbackBean.doWork(FallbackMetricBean.Action.NON_FALLBACK_EXCEPTION));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void fallbackMetricHandlerTest() {
        MetricGetter m = new MetricGetter(FallbackMetricBean.class, "doWorkWithHandler");
        m.baselineMetrics();
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.PASS);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.FAIL);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.FAIL);
        Exceptions.expectTestException(() -> this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.FAIL));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        Assert.expectThrows(FallbackMetricBean.NonFallbackException.class, () -> this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.NON_FALLBACK_EXCEPTION));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.VALUE_RETURNED, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(MetricDefinition.InvocationResult.EXCEPTION_THROWN, MetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
    }
}

