/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.ProxyServerTest;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIProxyServerTest
extends WiremockArquillianTest {
    @Inject
    @RestClient
    private SimpleGetApi client;

    @Deployment
    public static WebArchive createDeployment() {
        String uriProperty = SimpleGetApi.class.getName() + "/mp-rest/uri=" + CDIProxyServerTest.getStringURL() + "testProxyCDI";
        String proxyProperty = SimpleGetApi.class.getName() + "/mp-rest/proxyAddress=localhost:" + CDIProxyServerTest.getPort();
        String simpleName = CDIProxyServerTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{SimpleGetApi.class, WiremockArquillianTest.class, ProxyServerTest.class})).addAsManifestResource((Asset)new StringAsset(String.format(uriProperty + "%n" + proxyProperty, new Object[0])), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testProxy() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)"/.*")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + ProxyServerTest.DESTINATION_SERVER_PORT).withAdditionalRequestHeader("X-Via", "CDIWireMockProxy")));
        try {
            ProxyServerTest.startDestinationServer("bar");
            Response response = this.client.executeGet();
            Assert.assertEquals((int)response.getStatus(), (int)200);
            Assert.assertEquals((String)((String)response.readEntity(String.class)).trim(), (String)"bar");
            Assert.assertEquals((String)response.getHeaderString("X-Via"), (String)"CDIWireMockProxy");
        }
        finally {
            ProxyServerTest.stopDestinationServer();
        }
    }
}

