/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.internal.server.Store;
import org.eclipse.emf.cdo.internal.server.StoreAccessor;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStoreAccessor
extends StoreAccessor
implements IDBStoreAccessor {
    private Connection connection;
    private Statement statement;

    protected DBStoreAccessor(DBStore store, ISession session) throws DBException {
        super((Store)store, session);
        this.initConnection();
    }

    protected DBStoreAccessor(DBStore store, IView view) throws DBException {
        super((Store)store, view);
        this.initConnection();
    }

    protected void initConnection() {
        try {
            this.connection = this.getStore().getDBConnectionProvider().getConnection();
            this.connection.setAutoCommit(this.isReader());
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void doRelease() throws DBException {
        DBUtil.close((Statement)this.statement);
        DBUtil.close((Connection)this.connection);
    }

    @Override
    public DBStore getStore() {
        return (DBStore)super.getStore();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Statement getStatement() {
        if (this.statement == null) {
            try {
                this.statement = this.getConnection().createStatement();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        return this.statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        try {
            return this.getConnection().prepareStatement(sql);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected Boolean getBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            if (((Number)value).intValue() != 0) {
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Not a boolean value: " + value);
    }

    protected Set<IDBTable> mapPackages(CDOPackage ... cdoPackages) {
        HashSet<IDBTable> affectedTables = new HashSet<IDBTable>();
        if (cdoPackages != null && cdoPackages.length != 0) {
            CDOPackage[] cDOPackageArray = cdoPackages;
            int n = cdoPackages.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackage cdoPackage = cDOPackageArray[n2];
                Set<IDBTable> tables = this.mapClasses(cdoPackage.getClasses());
                affectedTables.addAll(tables);
                ++n2;
            }
        }
        return affectedTables;
    }

    protected Set<IDBTable> mapClasses(CDOClass ... cdoClasses) {
        HashSet<IDBTable> affectedTables = new HashSet<IDBTable>();
        if (cdoClasses != null && cdoClasses.length != 0) {
            IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
            CDOClass[] cDOClassArray = cdoClasses;
            int n = cdoClasses.length;
            int n2 = 0;
            while (n2 < n) {
                CDOClass cdoClass = cDOClassArray[n2];
                IClassMapping mapping = mappingStrategy.getClassMapping(cdoClass);
                if (mapping != null) {
                    affectedTables.addAll(mapping.getAffectedTables());
                }
                ++n2;
            }
        }
        return affectedTables;
    }
}

