/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.presentation;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.domain.AdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.provider.MappedObjectItemProvider;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class MappingDomainLabelProvider
extends AdapterFactoryLabelProvider {
    protected static HashMap images = new HashMap();
    protected AdapterFactoryMappingDomain mappingDomain;

    public MappingDomainLabelProvider(AdapterFactoryMappingDomain mappingDomain) {
        super(mappingDomain.getAdapterFactory());
        this.mappingDomain = mappingDomain;
    }

    public Image getImage(Object object) {
        Image result = super.getImage(object);
        if (result != null) {
            Object mappedObject = object instanceof MappedObjectItemProvider ? ((MappedObjectItemProvider)object).getMappedObject() : object;
            Collection mappings = this.mappingDomain.getMappingRoot().getMappings(mappedObject);
            Object overlayImage = this.mappingDomain.getMappingRoot().isTopObject(mappedObject) ? MappingPlugin.getPlugin().getImage(mappings.isEmpty() ? "full/ovr16/OverlayBlank" : "full/ovr16/OverlayMappedTop") : (this.mappingDomain.getMappingRoot().isBottomObject(mappedObject) ? MappingPlugin.getPlugin().getImage(mappings.isEmpty() ? "full/ovr16/OverlayBlank" : "full/ovr16/OverlayMappedBottom") : MappingPlugin.getPlugin().getImage("full/ovr16/OverlayBlank"));
            Image image = this.getImageFromObject(overlayImage);
            Key key = new Key(result, image);
            Image cachedImage = (Image)images.get(key);
            if (cachedImage == null) {
                result = new MappingIndicatorCompositeImage(result.getImageData(), image.getImageData()).createImage();
                images.put(key, result);
            } else {
                result = cachedImage;
            }
        }
        return result;
    }

    static class Key {
        public Image mainImage;
        public Image overlayImage;

        public Key(Image mainImage, Image overlayImage) {
            this.mainImage = mainImage;
            this.overlayImage = overlayImage;
        }

        public int hashCode() {
            return this.mainImage.hashCode() + this.overlayImage.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return key.mainImage == this.mainImage && key.overlayImage == this.overlayImage;
            }
            return false;
        }
    }

    class MappingIndicatorCompositeImage
    extends CompositeImageDescriptor {
        protected ImageData mainImage;
        protected ImageData overlayImage;

        public MappingIndicatorCompositeImage(ImageData mainImage, ImageData overlayImage) {
            this.mainImage = mainImage;
            this.overlayImage = overlayImage;
        }

        public void drawCompositeImage(int width, int height) {
            this.drawImage(this.mainImage, 0, 0);
            this.drawImage(this.overlayImage, this.mainImage.width, 0);
        }

        public Point getSize() {
            return new Point(this.mainImage.width + this.overlayImage.width, Math.max(this.mainImage.height, this.overlayImage.height));
        }

        public int hashCode() {
            return this.mainImage.hashCode() + this.overlayImage.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MappingIndicatorCompositeImage) {
                MappingIndicatorCompositeImage that = (MappingIndicatorCompositeImage)((Object)object);
                return that.mainImage == this.mainImage && that.overlayImage == this.overlayImage;
            }
            return false;
        }
    }
}

