/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.security.UserManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUserManager
extends UserManager {
    protected String fileName;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.fileName == null) {
            throw new IllegalStateException("fileName == null");
        }
        File file = new File(this.fileName);
        if (file.exists() && !file.isFile()) {
            throw new IllegalStateException("Not a file: " + this.fileName);
        }
    }

    @Override
    protected void load(Map<String, char[]> users) throws IORuntimeException {
        File file = new File(this.fileName);
        if (!file.exists()) {
            return;
        }
        FileInputStream stream = IOUtil.openInputStream(new File(this.fileName));
        try {
            try {
                this.load(users, stream);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        finally {
            IOUtil.closeSilent(stream);
        }
    }

    protected void load(Map<String, char[]> users, InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String userID = (String)entry.getKey();
            char[] password = ((String)entry.getValue()).toCharArray();
            users.put(userID, password);
        }
    }

    @Override
    protected void save(Map<String, char[]> users) throws IORuntimeException {
        File file = new File(this.fileName);
        if (!file.exists()) {
            return;
        }
        FileOutputStream stream = IOUtil.openOutputStream(new File(this.fileName));
        try {
            try {
                this.save(users, stream);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        finally {
            IOUtil.closeSilent(stream);
        }
    }

    protected void save(Map<String, char[]> users, FileOutputStream stream) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, char[]> entry : users.entrySet()) {
            properties.put(entry.getKey(), new String(entry.getValue()));
        }
        String comment = MessageFormat.format("User database {0,date} {0,time}", System.currentTimeMillis());
        properties.store(stream, comment);
    }
}

