/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.texteditor.ITextEditor;

public class AcceleoElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final ComposedAdapterFactory FACTORY = AcceleoElementHyperlinkDetector.createAdapterFactory();

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Object wordRegion;
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        boolean shortcut = false;
        if (region == null || !(textEditor instanceof AcceleoEditor)) {
            shortcut = true;
        }
        int offset = region.getOffset();
        AcceleoEditor editor = (AcceleoEditor)textEditor;
        int start = Math.max(0, offset - 10);
        int end = Math.min(editor.getContent().getText().length(), offset + 10);
        String expressionSurroundings = new String(editor.getContent().getText().substring(start, end));
        if (!this.isRelevant(expressionSurroundings, offset - start)) {
            shortcut = true;
        }
        if (shortcut) {
            return null;
        }
        EObject res = null;
        int wordStart = -1;
        int wordLength = -1;
        boolean inferWordRegion = true;
        ASTNode astNode = editor.getContent().getResolvedASTNode(offset, offset);
        if (astNode != null) {
            res = OpenDeclarationUtils.findDeclarationFromAST(astNode);
            if (res instanceof IteratorExp && editor.getContent().getOCLEnvironment() != null) {
                res = OpenDeclarationUtils.findIteratorEOperation(editor.getContent().getOCLEnvironment(), (IteratorExp)res);
            }
            wordStart = astNode.getStartPosition();
            wordLength = astNode.getEndPosition() - astNode.getStartPosition();
        }
        if (res == null) {
            CSTNode cstNode = editor.getContent().getCSTNode(offset, offset);
            if (cstNode != null) {
                res = OpenDeclarationUtils.findDeclarationFromCST(editor, astNode, cstNode);
                wordStart = cstNode.getStartPosition();
                wordLength = cstNode.getEndPosition() - cstNode.getStartPosition();
            }
            if (cstNode instanceof TypedModel) {
                inferWordRegion = false;
            }
        }
        IHyperlink[] links = null;
        if (res != null && (wordRegion = inferWordRegion ? this.getWordRegion(editor, offset, wordStart, wordLength) : new Region(wordStart, wordLength)) != null) {
            links = new IHyperlink[]{new AcceleoElementHyperlink((ITextEditor)editor, (IRegion)wordRegion, res)};
        }
        return links;
    }

    private IRegion getWordRegion(AcceleoEditor currentEditor, int cursorOffset, int expressionStart, int expressionLength) {
        int next;
        if (expressionStart + expressionLength > currentEditor.getContent().getText().length()) {
            return null;
        }
        String expression = new String(currentEditor.getContent().getText().substring(expressionStart, expressionStart + expressionLength));
        int cursorPositionInExpression = cursorOffset - expressionStart;
        int prev = cursorPositionInExpression - 1;
        if (prev >= 0) {
            while (prev >= 0 && this.isRelevant(expression, prev)) {
                --prev;
            }
        }
        if ((next = cursorPositionInExpression + 1) < expression.length()) {
            while (next < expression.length() - 1 && this.isRelevant(expression, next)) {
                ++next;
            }
        }
        int wordStart = prev == -1 ? 0 : prev + 1;
        int wordEnd = next == expression.length() - 1 ? expression.length() : next;
        int wordLength = wordEnd - wordStart;
        return new Region(wordStart + expressionStart, wordLength);
    }

    private boolean isRelevant(String expression, int offset) {
        char character = expression.charAt(offset);
        if (Character.isJavaIdentifierPart(character)) {
            return true;
        }
        boolean relevant = false;
        char previous = 'a';
        char next = 'a';
        if (offset > 1) {
            previous = expression.charAt(offset - 1);
        }
        if (offset < expression.length() - 2) {
            next = expression.charAt(offset + 1);
        }
        if (Character.isWhitespace(character)) {
            int curOffset = offset;
            while (curOffset < expression.length() - 2 && !Character.isJavaIdentifierPart(next) && next != ':') {
                next = expression.charAt(++curOffset);
            }
            curOffset = offset;
            while (curOffset > 1 && !Character.isJavaIdentifierPart(previous) && previous != ':') {
                previous = expression.charAt(--curOffset);
            }
            if (previous == ':' || next == ':') {
                relevant = true;
            }
        } else if (character == ':') {
            relevant = true;
        } else if (character == '>' && previous == '-') {
            relevant = false;
        } else if (character == '-' && next == '>') {
            relevant = false;
        } else if (character == '<' || character == '>' || character == '=') {
            relevant = true;
        } else if (character == '+' || character == '-' || character == '/' || character == '*') {
            relevant = true;
        }
        return relevant;
    }

    private static ComposedAdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected static String getLabelFor(EObject eObj) {
        IItemLabelProvider labelProvider;
        String text = eObj == null ? "null" : ((labelProvider = (IItemLabelProvider)FACTORY.adapt((Notifier)eObj, IItemLabelProvider.class)) != null ? labelProvider.getText((Object)eObj) : "");
        return text;
    }

    private class AcceleoElementHyperlink
    implements IHyperlink {
        private final IRegion hyperLinkRegion;
        private final EObject target;
        private final ITextEditor sourceEditor;

        public AcceleoElementHyperlink(ITextEditor editor, IRegion region, EObject linkTarget) {
            this.sourceEditor = editor;
            this.hyperLinkRegion = region;
            this.target = linkTarget;
        }

        public IRegion getHyperlinkRegion() {
            return this.hyperLinkRegion;
        }

        public String getHyperlinkText() {
            return AcceleoUIMessages.getString("AcceleoElementHyperlinkDetector.OpenDeclarationLabel", AcceleoElementHyperlinkDetector.getLabelFor(this.target));
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            OpenDeclarationUtils.showEObject(this.sourceEditor.getSite().getPage(), this.target.eResource().getURI(), OpenDeclarationUtils.createRegion(this.target), this.target);
        }
    }
}

