/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizardController;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizardPage;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.CreateTemplateData;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class AcceleoNewTemplatesWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private IPageChangingListener pageChangingListener;
    private AcceleoNewTemplatesWizardPage templatePage;

    public AcceleoNewTemplatesWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewTemplatesWizard.Title"));
    }

    public AcceleoNewTemplatesWizardPage getTemplatePage() {
        return this.templatePage;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.pageChangingListener == null && this.getContainer() instanceof WizardDialog) {
            WizardDialog dialog = (WizardDialog)this.getContainer();
            this.pageChangingListener = new IPageChangingListener(){

                public void handlePageChanging(PageChangingEvent event) {
                    if (event.getCurrentPage() instanceof WizardPage && event.getTargetPage() instanceof AcceleoNewTemplatesWizardPage) {
                        WizardPage current = (WizardPage)event.getCurrentPage();
                        AcceleoNewTemplatesWizardPage target = (AcceleoNewTemplatesWizardPage)((Object)event.getTargetPage());
                        target.handleNewTemplatePageChanging(current);
                    }
                }
            };
            dialog.addPageChangingListener(this.pageChangingListener);
        }
    }

    public void dispose() {
        if (this.pageChangingListener != null && this.getContainer() instanceof WizardDialog) {
            WizardDialog dialog = (WizardDialog)this.getContainer();
            dialog.removePageChangingListener(this.pageChangingListener);
        }
        super.dispose();
    }

    public void init(IWorkbench workbench, IStructuredSelection aSelection) {
        this.selection = aSelection;
    }

    public void addPages() {
        IStructuredSelection aSelection;
        IContainer firstContainer = null;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (aSelection = (IStructuredSelection)this.selection).size() > 0) {
            Object element = aSelection.getFirstElement();
            if (element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
            }
            if (element instanceof IContainer) {
                firstContainer = (IContainer)element;
            } else if (element instanceof IResource) {
                firstContainer = ((IResource)element).getParent();
            }
        }
        String container = "";
        if (firstContainer != null) {
            container = firstContainer.getFullPath().toString();
        }
        this.templatePage = new AcceleoNewTemplatesWizardPage(container, this.multipleTemplates());
        this.addPage((IWizardPage)this.templatePage);
    }

    protected boolean multipleTemplates() {
        return false;
    }

    public boolean performFinish() {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (AcceleoNewTemplatesWizardController controller : AcceleoNewTemplatesWizard.this.templatePage.getControllers()) {
                    AcceleoNewTemplatesWizard.this.createTemplate(controller.getModel(), monitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(create, null);
            return true;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    protected void createTemplate(CreateTemplateData data, IProgressMonitor monitor) {
        data.createExampleStrategy();
        if (data.getTemplateContainer().length() > 0 && data.getTemplateShortName().length() > 0) {
            IPath templatePath = new Path(data.getTemplateContainer()).append(data.getTemplateShortName()).addFileExtension("mtl");
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(templatePath.segment(0));
                if (project.isAccessible()) {
                    monitor.beginTask(AcceleoUIMessages.getString("AcceleoNewTemplatesWizard.Task.CreateTemplate", templatePath.lastSegment()), 2);
                    IPath projectRelativePath = templatePath.removeFirstSegments(1);
                    ByteArrayInputStream javaStream = new ByteArrayInputStream(data.getTemplateContent().getBytes("UTF8"));
                    IProject container = project;
                    String[] folders = projectRelativePath.removeLastSegments(1).segments();
                    int i = 0;
                    while (i < folders.length) {
                        if (!(container = container.getFolder((IPath)new Path(folders[i]))).exists()) {
                            ((IFolder)container).create(true, true, monitor);
                        }
                        ++i;
                    }
                    final IFile file = container.getFile((IPath)new Path(projectRelativePath.lastSegment()));
                    if (!file.exists()) {
                        file.create((InputStream)javaStream, true, monitor);
                    } else {
                        file.setContents((InputStream)javaStream, true, false, monitor);
                    }
                    monitor.worked(1);
                    monitor.setTaskName(AcceleoUIMessages.getString("AcceleoNewTemplatesWizard.Task.OpenTemplate"));
                    this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchPage aPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IDE.openEditor((IWorkbenchPage)aPage, (IFile)file, (boolean)true);
                            }
                            catch (PartInitException partInitException) {
                                // empty catch block
                            }
                        }
                    });
                    monitor.worked(1);
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
            catch (UnsupportedEncodingException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", 0, e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

