/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;

interface BracketMetaObject {
    public BracketMetaObject getChildBracketMetaObject(View var1);

    public LMLifeLineBracket createChildBracket(AbsNode var1, LmOwner var2);

    public boolean needsOffsetRight();

    public int getTopOutSpace();

    public int getTopInSpace();

    public int getBottomOutSpace();

    public int getBottomInSpace();

    public boolean tieBottomToTop();

    public static abstract class Adapter
    implements BracketMetaObject {
        private final int myVerticalTopOutSpace;
        private final int myVerticalBottomOutSpace;
        private final int myVerticalInSpace;
        private final boolean myNeedsOffsetRight;

        public Adapter(int verticalInSpace, int verticalTopOutSpace, int verticalBottomOutSpace, boolean needsOffsetRight) {
            this.myVerticalInSpace = verticalInSpace;
            this.myVerticalTopOutSpace = verticalTopOutSpace;
            this.myVerticalBottomOutSpace = verticalBottomOutSpace;
            this.myNeedsOffsetRight = needsOffsetRight;
        }

        public abstract BracketMetaObject getChildBracketMetaObject(View var1);

        public boolean needsOffsetRight() {
            return this.myNeedsOffsetRight;
        }

        public int getBottomInSpace() {
            return this.myVerticalInSpace;
        }

        public int getBottomOutSpace() {
            return this.myVerticalBottomOutSpace;
        }

        public int getTopInSpace() {
            return this.myVerticalInSpace;
        }

        public int getTopOutSpace() {
            return this.myVerticalTopOutSpace;
        }

        public boolean tieBottomToTop() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Ruled
    extends Adapter {
        private final List<GetChildBracketLogic> myGetChildBracketLogics = new ArrayList<GetChildBracketLogic>(4);

        public Ruled(int verticalInSpace, int verticalOutSpace, boolean needsOffsetRight) {
            this(verticalInSpace, verticalOutSpace, verticalOutSpace, needsOffsetRight);
        }

        public Ruled(int verticalInSpace, int verticalTopOutSpace, int verticalBottomOutSpace, boolean needsOffsetRight) {
            super(verticalInSpace, verticalTopOutSpace, verticalBottomOutSpace, needsOffsetRight);
        }

        @Override
        public BracketMetaObject getChildBracketMetaObject(View reference) {
            int i = 0;
            while (i < this.myGetChildBracketLogics.size()) {
                GetChildBracketLogic getChildBracketLogic = this.myGetChildBracketLogics.get(i);
                BracketMetaObject bracketMetaObject = getChildBracketLogic.getChildBracketMetaObject(reference);
                if (bracketMetaObject != null) {
                    return bracketMetaObject;
                }
                ++i;
            }
            return null;
        }

        void addMetaclass(EClass metaclass, BracketMetaObject bracketMetaObject) {
            Rule rule = new Rule(metaclass, bracketMetaObject);
            this.addGetChildBracketLogic(new GetChildBracketLogicImpl(rule));
        }

        void addCondition(Condition condition, BracketMetaObject bracketMetaObject) {
            Rule rule = new Rule(condition, bracketMetaObject);
            this.addGetChildBracketLogic(new GetChildBracketLogicImpl(rule));
        }

        void addGetChildBracketLogics(Collection<GetChildBracketLogic> getChildBracketLogics) {
            this.myGetChildBracketLogics.addAll(getChildBracketLogics);
        }

        void addGetChildBracketLogic(GetChildBracketLogic getChildBracketLogic) {
            this.myGetChildBracketLogics.add(getChildBracketLogic);
        }

        static interface Condition {
            public boolean matches(View var1);
        }

        static class EClassCondition
        implements Condition {
            private final EClass[] myEClasses;

            EClassCondition(EClass ... eClasses) {
                this.myEClasses = eClasses;
            }

            public boolean matches(View reference) {
                EObject entity = reference.getElement();
                if (entity == null) {
                    return false;
                }
                EClass[] eClassArray = this.myEClasses;
                int n = this.myEClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    EClass next = eClassArray[n2];
                    if (next.isInstance((Object)entity)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }

        static interface GetChildBracketLogic {
            public BracketMetaObject getChildBracketMetaObject(View var1);
        }

        static class GetChildBracketLogicImpl
        implements GetChildBracketLogic {
            private final Rule myRule;

            GetChildBracketLogicImpl(EClass metaclass, BracketMetaObject bracketMetaObject) {
                this(new Rule(metaclass, bracketMetaObject));
            }

            GetChildBracketLogicImpl(Rule rule) {
                this.myRule = rule;
            }

            public BracketMetaObject getChildBracketMetaObject(View reference) {
                if (!this.myRule.getCondition().matches(reference)) {
                    return null;
                }
                return this.myRule.getBracketMetaObject();
            }
        }

        static class Rule {
            private final Condition myCondition;
            private final BracketMetaObject myBracketMetaObject;

            Rule(EClass eClass, BracketMetaObject bracketMetaObject) {
                this(new EClassCondition(eClass), bracketMetaObject);
            }

            Rule(Condition condition, BracketMetaObject bracketMetaObject) {
                this.myCondition = condition;
                this.myBracketMetaObject = bracketMetaObject;
            }

            BracketMetaObject getBracketMetaObject() {
                return this.myBracketMetaObject;
            }

            Condition getCondition() {
                return this.myCondition;
            }
        }
    }
}

