/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.uml2.diagram.common.draw2d.FillingBorderLayout;

public class PackageFrameFigure
extends RectangleFigure {
    private final Pentagon myPentagon;
    private final RectangleFigure myContentPane;
    private final Label myKindLabel;
    private final Label myNameLabel;
    private final ToolbarLayout myContentsLayout;

    public PackageFrameFigure() {
        this.setLineWidth(1);
        this.setOutline(true);
        this.setFill(true);
        this.setLayoutManager((LayoutManager)new DontStretchTopBorderLayout());
        this.myPentagon = new Pentagon();
        this.myContentPane = new RectangleFigure();
        this.myContentPane.setOutline(false);
        this.myContentPane.setFill(false);
        this.myContentPane.setOpaque(false);
        this.myContentPane.setLayoutManager((LayoutManager)new StackLayout());
        Figure pentagonContents = new Figure();
        this.myContentsLayout = new ToolbarLayout();
        this.myContentsLayout.setStretchMinorAxis(true);
        this.myContentsLayout.setMinorAlignment(0);
        this.myContentsLayout.setSpacing(10);
        this.myContentsLayout.setVertical(false);
        pentagonContents.setLayoutManager((LayoutManager)this.myContentsLayout);
        this.myKindLabel = new Label();
        this.myNameLabel = new Label();
        pentagonContents.add((IFigure)this.myKindLabel);
        pentagonContents.add((IFigure)this.myNameLabel);
        this.myPentagon.setContent((IFigure)pentagonContents);
        this.add((IFigure)this.myPentagon, BorderLayout.TOP);
        this.add((IFigure)this.myContentPane, BorderLayout.CENTER);
    }

    public void setKindLabelText(String text) {
        this.getKindLabel().setText(text == null ? "" : text);
    }

    public void setKindLabelVisible(boolean visible) {
        this.myKindLabel.setVisible(visible);
    }

    public void setLabelsSpacing(int spacing) {
        if (this.myContentsLayout.getSpacing() != spacing) {
            this.myContentsLayout.setSpacing(spacing);
            this.revalidate();
        }
    }

    public Label getKindLabel() {
        return this.myKindLabel;
    }

    public RectangleFigure getContentPane() {
        return this.myContentPane;
    }

    public Label getNameLabel() {
        return this.myNameLabel;
    }

    private static class DontStretchTopBorderLayout
    extends BorderLayout {
        private IFigure myTop;

        private DontStretchTopBorderLayout() {
        }

        public void setConstraint(IFigure child, Object constraint) {
            super.setConstraint(child, constraint);
            if (constraint instanceof Number && ((Number)constraint).intValue() == 8) {
                this.myTop = child;
            }
        }

        public void remove(IFigure child) {
            super.remove(child);
            if (child == this.myTop) {
                this.myTop = null;
            }
        }

        public void layout(IFigure container) {
            super.layout(container);
            if (this.myTop != null && this.myTop.isVisible()) {
                Dimension childSize = this.myTop.getPreferredSize(container.getClientArea().width, -1);
                this.myTop.getBounds().width = Math.min(childSize.width, this.myTop.getBounds().width);
            }
        }
    }

    private static class Pentagon
    extends Shape {
        public static final int BIT_SIZE = 5;

        public Pentagon() {
            this.setLineWidth(1);
            this.setLayoutManager((LayoutManager)new FillingBorderLayout());
        }

        protected void fillShape(Graphics graphics) {
            graphics.fillPolygon(this.getPoints(Pentagon.getOutlineBounds(this).shrink(1, 1)));
        }

        protected void outlineShape(Graphics graphics) {
            graphics.drawPolyline(this.getPoints(Pentagon.getOutlineBounds(this)));
        }

        public void setContent(IFigure content) {
            content.setBorder((Border)new MarginBorder(0, 5, 2, 5));
            this.add(content, FillingBorderLayout.CENTER);
        }

        protected PointList getPoints(Rectangle rect) {
            PointList points = new PointList(6);
            points.addPoint(rect.x, rect.y);
            points.addPoint(rect.x + rect.width, rect.y);
            if (5 > rect.height || 5 > rect.width) {
                points.addPoint(rect.x + rect.width, rect.y + rect.height);
            } else {
                points.addPoint(rect.x + rect.width, rect.y + rect.height - 5);
                points.addPoint(rect.x + rect.width - 5, rect.y + rect.height);
            }
            points.addPoint(rect.x, rect.y + rect.height);
            return points;
        }

        private static Rectangle getOutlineBounds(Shape shape) {
            Rectangle b = new Rectangle(shape.getBounds());
            int lineWidth = shape.getLineWidth();
            int lineOffset = lineWidth / 2;
            b.x += lineOffset;
            b.y += lineOffset;
            b.width -= lineWidth;
            b.height -= lineWidth;
            return b;
        }
    }
}

