/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.diagram.common.sheet.TextAndDialogCellEditor;

public class ImageLocationCellEditor
extends TextAndDialogCellEditor {
    private static final String[] myImageFileExtensions = new String[]{"svg", "gif", "png", "jpg", "wmf", "bmp", "emf"};
    private final ViewerFilter myViewFilter = new ImageFileFilter(myImageFileExtensions);
    private URI myProfileResourceURI;

    public ImageLocationCellEditor(EObject source, Composite composite, ILabelProvider labelProvider) {
        super(composite, labelProvider);
        Resource eResource = source.eResource();
        URIConverter uriConverter = eResource.getResourceSet().getURIConverter();
        this.myProfileResourceURI = uriConverter.normalize(eResource.getURI());
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        IFile[] files;
        String currentLocation = (String)this.getValue();
        Object[] initialSelection = null;
        if (currentLocation != null) {
            try {
                IFile file = this.getFileForProfileRelativeLocation(currentLocation);
                if (file != null) {
                    initialSelection = new Object[]{file};
                }
            }
            catch (Exception exception) {}
        }
        if ((files = WorkspaceResourceDialog.openFileSelection((Shell)cellEditorWindow.getShell(), null, null, (boolean)false, (Object[])initialSelection, Collections.singletonList(this.myViewFilter))) != null && files.length > 0) {
            return this.getRelativeLocationForFile(files[0]);
        }
        return null;
    }

    private IFile getFileForProfileRelativeLocation(String location) {
        URI uri = URI.createURI((String)location).resolve(this.myProfileResourceURI);
        IResource workspaceResource = ImageLocationCellEditor.getResource(uri);
        if (workspaceResource != null && workspaceResource instanceof IFile) {
            return (IFile)workspaceResource;
        }
        return null;
    }

    private String getRelativeLocationForFile(IFile file) {
        IProject profileProject = ImageLocationCellEditor.getResource(this.myProfileResourceURI).getProject();
        IPath filePath = file.getFullPath();
        IPath profilePath = profileProject.getFullPath();
        if (profilePath.isPrefixOf(filePath)) {
            return filePath.makeRelativeTo(profilePath).toString();
        }
        return URI.createPlatformResourceURI((String)filePath.toString(), (boolean)false).toString();
    }

    private static IResource getResource(URI uri) {
        String fileName = uri.toFileString();
        if (fileName != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        }
        if (uri.isPlatformResource()) {
            String path = uri.toPlatformString(false);
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        }
        return null;
    }

    private class ImageFileFilter
    extends ViewerFilter {
        private final List<String> myFileExtensions;

        public ImageFileFilter(String ... extensions) {
            this.myFileExtensions = Arrays.asList(extensions);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                String fileExtension = file.getFullPath().getFileExtension().toLowerCase();
                return this.myFileExtensions.contains(fileExtension);
            }
            if (element instanceof Resource) {
                Resource res = (Resource)element;
                String fileExtension = res.getURI().fileExtension().toLowerCase();
                return this.myFileExtensions.contains(fileExtension);
            }
            return true;
        }
    }
}

