/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.xtext.ui.refactoring.IRenameProcessorAdapter;

public class JavaRenameProcessorAdapter
implements IRenameProcessorAdapter {
    private final JavaRenameProcessor processor;

    public JavaRenameProcessorAdapter(JavaRenameProcessor processor) {
        this.processor = processor;
    }

    public String getOriginalName() {
        return this.processor.getCurrentElementName();
    }

    public String getNewName() {
        return this.processor.getNewElementName();
    }

    public void setNewName(String newName) {
        this.processor.setNewElementName(newName);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws Exception {
        return this.processor.checkInitialConditions(pm);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws Exception {
        return this.processor.checkFinalConditions(pm, context);
    }

    public Change createChange(IProgressMonitor pm) throws Exception {
        return this.processor.createChange(pm);
    }

    public RefactoringStatus validateNewName(String newName) {
        try {
            return this.processor.checkNewElementName(newName);
        }
        catch (CoreException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }

    public static class Factory
    extends IRenameProcessorAdapter.DefaultFactory {
        public IRenameProcessorAdapter create(RenameProcessor processor) {
            if (processor instanceof JavaRenameProcessor) {
                return new JavaRenameProcessorAdapter((JavaRenameProcessor)processor);
            }
            return super.create(processor);
        }
    }
}

