/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.LiteralsCompiler;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.typing.JvmOnlyTypeConformanceComputer;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCallCompiler
extends LiteralsCompiler {
    @Inject
    private FeatureCallToJavaMapping featureCallToJavaMapping;
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private JvmOnlyTypeConformanceComputer jvmConformance;
    @Inject
    private Primitives primitives;

    protected void _toJavaStatement(final XAbstractFeatureCall expr, final IAppendable b, boolean isReferenced) {
        if (this.isSpreadingMemberFeatureCall(expr)) {
            this.prepareSpreadingMemberFeatureCall((XMemberFeatureCall)expr, b);
        } else if (this.expressionHelper.isShortCircuiteBooleanOperation(expr)) {
            this.generateShortCircuitInvocation(expr, b);
        } else {
            if (expr.getImplicitReceiver() != null) {
                this.internalToJavaStatement(expr.getImplicitReceiver(), b, true);
            }
            for (XExpression arg : expr.getExplicitArguments()) {
                this.prepareExpression(arg, b);
            }
            if (this.isVariableDeclarationRequired(expr, b)) {
                if (isReferenced && !this.isPrimitiveVoid(expr)) {
                    Later later = new Later(){

                        public void exec() {
                            FeatureCallCompiler.this.featureCalltoJavaExpression(expr, b);
                        }
                    };
                    this.declareLocalVariable((XExpression)expr, b, later);
                } else {
                    b.append("\n");
                    this.featureCalltoJavaExpression(expr, b);
                    b.append(";");
                }
            }
        }
    }

    protected void generateShortCircuitInvocation(XAbstractFeatureCall binaryOperation, IAppendable b) {
        XExpression leftOperand = ((XBinaryOperation)binaryOperation).getLeftOperand();
        this.declareLocalVariable(binaryOperation, b);
        this.prepareExpression(leftOperand, b);
        b.append("\nif (");
        if (binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getAndOperator())) {
            b.append("!");
        }
        this.toJavaExpression(leftOperand, b);
        b.append(") {").increaseIndentation();
        b.append("\n").append(b.getName(binaryOperation)).append(" = ").append(binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getOrOperator())).append(";");
        b.decreaseIndentation().append("\n} else {").increaseIndentation();
        if (binaryOperation.getImplicitReceiver() != null) {
            this.internalToJavaStatement(binaryOperation.getImplicitReceiver(), b, true);
        }
        for (XExpression arg : binaryOperation.getExplicitArguments()) {
            if (arg == leftOperand) continue;
            this.prepareExpression(arg, b);
        }
        b.append("\n").append(b.getName(binaryOperation)).append(" = ");
        this.featureCalltoJavaExpression(binaryOperation, b);
        b.append(";");
        b.decreaseIndentation().append("\n}");
    }

    @Override
    protected boolean isVariableDeclarationRequired(XExpression expr, IAppendable b) {
        if (expr instanceof XAssignment) {
            return true;
        }
        if (expr instanceof XAbstractFeatureCall) {
            JvmIdentifiableElement feature = ((XAbstractFeatureCall)expr).getFeature();
            if (feature instanceof JvmField) {
                return false;
            }
            return b.getName(feature) == null;
        }
        return super.isVariableDeclarationRequired(expr, b);
    }

    protected void prepareSpreadingMemberFeatureCall(XMemberFeatureCall expr, IAppendable b) {
        throw new UnsupportedOperationException("spread operator not yet supported");
    }

    protected void prepareExpression(XExpression arg, IAppendable b) {
        if (arg instanceof XAbstractFeatureCall && !(((XAbstractFeatureCall)arg).getFeature() instanceof JvmField) && !this.isVariableDeclarationRequired(arg, b)) {
            JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(arg);
            JvmTypeReference type = this.getTypeProvider().getType(arg);
            if (expectedType != null && !this.jvmConformance.isConformant(expectedType, type)) {
                String varName = this.getVarName(((XAbstractFeatureCall)arg).getFeature(), b);
                String finalVariable = b.declareVariable(Tuples.create((Object)"Convertable", (Object)arg), "typeConverted_" + varName);
                b.append("\n").append("final ");
                this.serialize(type, arg, b);
                b.append(" ").append(finalVariable).append(" = ").append("(");
                this.serialize(type, arg, b);
                b.append(")").append(varName).append(";");
            }
        } else {
            this.internalToJavaStatement(arg, b, true);
        }
    }

    protected boolean isSpreadingMemberFeatureCall(XAbstractFeatureCall expr) {
        return expr instanceof XMemberFeatureCall && ((XMemberFeatureCall)expr).isSpreading();
    }

    protected void _toJavaExpression(XAbstractFeatureCall call, IAppendable b) {
        if (this.isPrimitiveVoid(call)) {
            b.append("null");
        } else {
            if (this.isSpreadingMemberFeatureCall(call)) {
                throw new UnsupportedOperationException();
            }
            if (!this.isVariableDeclarationRequired(call, b)) {
                if (call.getFeature() instanceof JvmField) {
                    if (this.isStatic(call.getFeature())) {
                        b.append(((JvmFeature)call.getFeature()).getDeclaringType());
                        b.append(".");
                    } else {
                        XExpression receiver = this.featureCallToJavaMapping.getActualReceiver(call);
                        if (receiver != null) {
                            this.internalToJavaExpression(receiver, b);
                            b.append(".");
                        }
                    }
                    b.append(call.getFeature().getSimpleName());
                } else {
                    b.append(this.getVarName(call.getFeature(), b));
                }
            } else {
                b.append(this.getVarName(call, b));
            }
        }
    }

    protected void featureCalltoJavaExpression(XAbstractFeatureCall call, IAppendable b) {
        if (call instanceof XAssignment) {
            this.xAssignmentToJavaExpression((XAssignment)call, b);
            return;
        }
        boolean hasReceiver = this.appendReceiver(call, b);
        if (hasReceiver) {
            JvmOperation operation;
            b.append(".");
            if (!call.getTypeArguments().isEmpty()) {
                b.append("<");
                int i = 0;
                while (i < call.getTypeArguments().size()) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    JvmTypeReference typeArgument = (JvmTypeReference)call.getTypeArguments().get(i);
                    this.serialize(typeArgument, call, b);
                    ++i;
                }
                b.append(">");
            } else if (call.getFeature() instanceof JvmOperation && !(operation = (JvmOperation)call.getFeature()).getTypeParameters().isEmpty()) {
                XExpression receiver = this.featureCallToJavaMapping.getActualReceiver(call);
                JvmTypeReference receiverType = null;
                if (receiver != null) {
                    receiverType = this.getTypeProvider().getType(receiver);
                }
                JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(call);
                ArrayList argumentTypes = Lists.newArrayList();
                for (XExpression argument : this.featureCallToJavaMapping.getActualArguments(call)) {
                    argumentTypes.add(this.getTypeProvider().getType(argument));
                }
                TypeArgumentContext typeArgumentContext = this.getContextProvider().getInferredMethodInvocationContext(operation, receiverType, expectedType, argumentTypes.toArray(new JvmTypeReference[argumentTypes.size()]));
                ArrayList resolvedTypeArguments = Lists.newArrayList();
                boolean containedUnresolved = false;
                int i = 0;
                while (i < operation.getTypeParameters().size() && !containedUnresolved) {
                    JvmTypeParameter typeParameter = (JvmTypeParameter)operation.getTypeParameters().get(i);
                    JvmTypeReference typeArgument = typeArgumentContext.getBoundArgument(typeParameter);
                    if (typeArgument != null) {
                        typeArgument = typeArgumentContext.getUpperBound(typeArgument, (Notifier)call);
                        typeArgument = this.getPrimitives().asWrapperTypeIfPrimitive(typeArgument);
                        typeArgument = this.resolveMultiType(typeArgument);
                        resolvedTypeArguments.add(typeArgument);
                    } else {
                        containedUnresolved = true;
                    }
                    ++i;
                }
                if (!containedUnresolved) {
                    b.append("<");
                    i = 0;
                    while (i < resolvedTypeArguments.size()) {
                        if (i != 0) {
                            b.append(", ");
                        }
                        JvmTypeReference typeArgument = (JvmTypeReference)resolvedTypeArguments.get(i);
                        this.serialize(typeArgument, call, b);
                        ++i;
                    }
                    b.append(">");
                }
            }
        }
        this.appendFeatureCall(call, b);
    }

    protected boolean appendReceiver(XAbstractFeatureCall call, IAppendable b) {
        if (this.isStatic(call.getFeature())) {
            b.append(((JvmFeature)call.getFeature()).getDeclaringType());
            return true;
        }
        XExpression receiver = this.featureCallToJavaMapping.getActualReceiver(call);
        if (call instanceof XMemberFeatureCall) {
            XMemberFeatureCall expr = (XMemberFeatureCall)call;
            if (expr.isNullSafe()) {
                this.internalToJavaExpression(receiver, b);
                b.append("==null?");
                JvmTypeReference type = this.getTypeProvider().getType(call);
                this.appendNullValue(type, call, b);
                b.append(":");
                this.internalToJavaExpression(receiver, b);
                return true;
            }
            if (expr.isSpreading()) {
                throw new UnsupportedOperationException();
            }
        }
        if (receiver != null) {
            this.internalToJavaExpression(receiver, b);
            return true;
        }
        return false;
    }

    protected void appendNullValue(JvmTypeReference type, EObject context, IAppendable b) {
        if (!this.primitives.isPrimitive(type)) {
            b.append("(");
            this.serialize(type, context, b);
            b.append(")");
            b.append("null");
        } else {
            b.append(this.getDefaultLiteral((JvmPrimitiveType)type.getType()));
        }
    }

    protected String getDefaultLiteral(JvmPrimitiveType primitiveType) {
        String name = primitiveType.getIdentifier();
        if (Boolean.TYPE.getName().equals(name)) {
            return "false";
        }
        if (Integer.TYPE.getName().equals(name)) {
            return "0";
        }
        if (Byte.TYPE.getName().equals(name)) {
            return "(byte) 0";
        }
        if (Short.TYPE.getName().equals(name)) {
            return "(short) 0";
        }
        if (Character.TYPE.getName().equals(name)) {
            return "(char) 0";
        }
        if (Long.TYPE.getName().equals(name)) {
            return "0l";
        }
        if (Float.TYPE.getName().equals(name)) {
            return "0f";
        }
        if (Double.TYPE.getName().equals(name)) {
            return "0.0";
        }
        throw new IllegalArgumentException("Unkown primitive " + name);
    }

    protected boolean isMemberCall(XAbstractFeatureCall call) {
        return this.featureCallToJavaMapping.isTargetsMemberSyntaxCall(call, call.getFeature(), call.getImplicitReceiver());
    }

    protected boolean isStatic(JvmIdentifiableElement feature) {
        if (feature instanceof JvmOperation) {
            return ((JvmOperation)feature).isStatic();
        }
        if (feature instanceof JvmField) {
            return ((JvmField)feature).isStatic();
        }
        return false;
    }

    protected void xAssignmentToJavaExpression(XAssignment expr, IAppendable b) {
        JvmIdentifiableElement feature = expr.getFeature();
        if (feature instanceof JvmOperation) {
            boolean appendReceiver = this.appendReceiver(expr, b);
            if (appendReceiver) {
                b.append(".");
            }
            this.appendFeatureCall(expr, b);
        } else {
            if (feature instanceof JvmField) {
                boolean appendReceiver = this.appendReceiver(expr, b);
                if (appendReceiver) {
                    b.append(".");
                }
                this.appendFeatureCall(expr, b);
            } else {
                String name = b.getName(expr.getFeature());
                b.append(name);
            }
            b.append(" = ");
            this.internalToJavaExpression(expr.getValue(), b);
        }
    }

    protected void appendFeatureCall(XAbstractFeatureCall call, IAppendable b) {
        String name = this.featureNameProvider.getSimpleName(call.getFeature());
        b.append(name);
        if (call.getFeature() instanceof JvmOperation) {
            b.append("(");
            List<XExpression> arguments = this.featureCallToJavaMapping.getActualArguments(call);
            this.appendArguments(arguments, (JvmExecutable)call.getFeature(), call, b);
            b.append(")");
        }
    }

    protected JvmTypeReference getUpperBound(XAbstractFeatureCall call, EList<JvmTypeConstraint> constraints) {
        JvmTypeReference typeArg = constraints.isEmpty() ? this.getTypeReferences().getTypeForName(Object.class, (EObject)call, new JvmTypeReference[0]) : ((JvmTypeConstraint)constraints.get(0)).getTypeReference();
        return typeArg;
    }

    protected void appendArguments(List<? extends XExpression> eList, JvmExecutable executable, XExpression context, IAppendable b) {
        if (eList == null) {
            return;
        }
        int i = 0;
        while (i < eList.size()) {
            XExpression expression = eList.get(i);
            this.internalToJavaExpression(expression, b);
            if (i + 1 < eList.size()) {
                b.append(", ");
            }
            ++i;
        }
    }
}

