/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureScope;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmFeatureScopeProvider
implements IJvmFeatureScopeProvider {
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private IFeaturesForTypeProvider featuresProvider;
    @Inject
    private SynonymTypesProvider synonymTypeProvider;

    public void setTypeArgumentContextProvider(TypeArgumentContextProvider typeArgumentContextProvider) {
        this.typeArgumentContextProvider = typeArgumentContextProvider;
    }

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    @Override
    public JvmFeatureScope createFeatureScopeForTypeRef(IScope parent, JvmTypeReference typeReference, List<IJvmFeatureDescriptionProvider> jvmFeatureDescriptionProviders) {
        TypeArgumentContext context = this.typeArgumentContextProvider.getReceiverContext(typeReference);
        Iterable<JvmTypeReference> hierarchy = this.linearizeTypeHierarchy(typeReference);
        ArrayList descriptions = Lists.newArrayList();
        for (IJvmFeatureDescriptionProvider provider : jvmFeatureDescriptionProviders) {
            List<JvmFeatureDescriptionList> descriptionList = this.createFeatureScopes(hierarchy, context, provider);
            descriptions.addAll(descriptionList);
        }
        List visibleElements = Lists.transform((List)descriptions, (Function)new Function<JvmFeatureDescriptionList, JvmFeatureDescriptionList>(){

            public JvmFeatureDescriptionList apply(JvmFeatureDescriptionList from) {
                return new JvmFeatureDescriptionList(from.getText(), Iterables.filter(from.getDescriptions(), (Predicate)new Predicate<JvmFeatureDescription>(){

                    public boolean apply(JvmFeatureDescription input) {
                        return input.isValid();
                    }
                }));
            }
        });
        List invisibleElements = Lists.transform((List)descriptions, (Function)new Function<JvmFeatureDescriptionList, JvmFeatureDescriptionList>(){

            public JvmFeatureDescriptionList apply(JvmFeatureDescriptionList from) {
                return new JvmFeatureDescriptionList("[invalid] " + from.getText(), Iterables.filter(from.getDescriptions(), (Predicate)new Predicate<JvmFeatureDescription>(){

                    public boolean apply(JvmFeatureDescription input) {
                        return !input.isValid();
                    }
                }));
            }
        });
        ArrayList newArrayList = Lists.newArrayList((Iterable)Iterables.concat((Iterable)visibleElements, (Iterable)invisibleElements));
        Object current = parent;
        for (JvmFeatureDescriptionList featureDescs : Iterables.reverse((List)newArrayList)) {
            if (featureDescs == null || Iterables.isEmpty(featureDescs.getDescriptions())) continue;
            if (current == null) {
                current = IScope.NULLSCOPE;
            }
            current = this.createJvmFeatureScope((IScope)current, featureDescs);
        }
        if (current == null || parent == current) {
            return new JvmFeatureScope(parent, "No features for type " + typeReference, Collections.emptyList());
        }
        return (JvmFeatureScope)((Object)current);
    }

    protected JvmFeatureScope createJvmFeatureScope(IScope current, JvmFeatureDescriptionList featureDescs) {
        return new JvmFeatureScope(current, featureDescs.getText(), featureDescs.getDescriptions());
    }

    protected List<JvmFeatureDescriptionList> createFeatureScopes(Iterable<JvmTypeReference> hierarchy, TypeArgumentContext context, IJvmFeatureDescriptionProvider jvmFeatureDescriptionProvider) {
        JvmFeatureDescriptionList featureDescriptions;
        ArrayList result = Lists.newArrayList();
        boolean wasEmpty = true;
        for (JvmTypeReference type : hierarchy) {
            wasEmpty = false;
            JvmFeatureDescriptionList featureDescriptions2 = this.createFeatureScope(type, context, jvmFeatureDescriptionProvider);
            if (featureDescriptions2 == null) continue;
            result.add(featureDescriptions2);
        }
        if (wasEmpty && (featureDescriptions = this.createFeatureScope(null, context, jvmFeatureDescriptionProvider)) != null) {
            result.add(featureDescriptions);
        }
        return result;
    }

    protected JvmFeatureDescriptionList createFeatureScope(JvmTypeReference type, TypeArgumentContext context, IJvmFeatureDescriptionProvider jvmFeatureDescriptionProvider) {
        Iterable<? extends JvmFeature> features = this.getFeaturesForType(type, jvmFeatureDescriptionProvider);
        if (!features.iterator().hasNext()) {
            return null;
        }
        final ArrayList descriptions = Lists.newArrayList();
        IAcceptor<JvmFeatureDescription> acceptor = new IAcceptor<JvmFeatureDescription>(){

            public void accept(JvmFeatureDescription t) {
                descriptions.add(t);
            }
        };
        for (JvmFeature jvmFeature : features) {
            jvmFeatureDescriptionProvider.addFeatureDescriptions(jvmFeature, context, acceptor);
        }
        String string = type != null ? type.getIdentifier() : "[static features]";
        return new JvmFeatureDescriptionList(String.valueOf(jvmFeatureDescriptionProvider.getText()) + " " + string, descriptions);
    }

    protected Iterable<? extends JvmFeature> getFeaturesForType(JvmTypeReference type, IJvmFeatureDescriptionProvider descriptionProvider) {
        Predicate<JvmFeature> predicate = new Predicate<JvmFeature>(){

            public boolean apply(JvmFeature input) {
                return JvmFeatureScopeProvider.this.isValidFeature(input);
            }
        };
        if (descriptionProvider instanceof IFeaturesForTypeProvider) {
            return Iterables.filter(((IFeaturesForTypeProvider)((Object)descriptionProvider)).getFeaturesForType(type), (Predicate)predicate);
        }
        return this.featuresProvider.getFeaturesForType(type);
    }

    protected boolean isValidFeature(JvmFeature input) {
        return input != null && input.getSimpleName() != null && input.getDeclaringType() != null && !(input instanceof JvmConstructor);
    }

    public Iterable<JvmTypeReference> linearizeTypeHierarchy(JvmTypeReference typeRef) {
        if (typeRef == null) {
            return Collections.emptyList();
        }
        final LinkedHashMap result = Maps.newLinkedHashMap();
        result.put(typeRef, -1);
        final Wrapper addOn = Wrapper.wrap((Object)0);
        final HashMap visited = Maps.newHashMap();
        visited.put(typeRef.getType(), typeRef);
        SuperTypeCollector.SuperTypeAcceptor acceptor = new SuperTypeCollector.SuperTypeAcceptor(){

            public boolean accept(JvmTypeReference superType, int distance) {
                JvmTypeReference existing = (JvmTypeReference)visited.get(superType.getType());
                if (existing == null) {
                    visited.put(superType.getType(), superType);
                    result.put(superType, distance + (Integer)addOn.get());
                    return true;
                }
                Integer previousDistance = (Integer)result.get(existing);
                if (previousDistance > (Integer)addOn.get() && distance > previousDistance) {
                    visited.put(superType.getType(), superType);
                    result.remove(existing);
                    result.put(superType, distance + (Integer)addOn.get());
                    return true;
                }
                return false;
            }
        };
        this.superTypeCollector.collectSuperTypes(typeRef, acceptor);
        for (JvmTypeReference synonym : this.synonymTypeProvider.getSynonymTypes(typeRef)) {
            if (visited.containsKey(synonym.getType())) continue;
            result.put(synonym, result.size());
            visited.put(synonym.getType(), synonym);
            addOn.set((Object)result.size());
            this.superTypeCollector.collectSuperTypes(synonym, acceptor);
        }
        ArrayList sortable = Lists.newArrayList(result.entrySet());
        Collections.sort(sortable, new Comparator<Map.Entry<JvmTypeReference, Integer>>(){

            @Override
            public int compare(Map.Entry<JvmTypeReference, Integer> o1, Map.Entry<JvmTypeReference, Integer> o2) {
                if (o1.getValue().equals(o2.getValue())) {
                    JvmTypeReference ref1 = o1.getKey();
                    JvmTypeReference ref2 = o2.getKey();
                    if (ref1.getType() instanceof JvmGenericType && ref2.getType() instanceof JvmGenericType) {
                        if (((JvmGenericType)ref1.getType()).isInterface()) {
                            if (!((JvmGenericType)ref2.getType()).isInterface()) {
                                return 1;
                            }
                        } else if (((JvmGenericType)ref2.getType()).isInterface()) {
                            return -1;
                        }
                    }
                    return o1.getKey().getQualifiedName().compareTo(o2.getKey().getQualifiedName());
                }
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return Lists.newArrayList((Iterable)Lists.transform((List)sortable, (Function)new Function<Map.Entry<JvmTypeReference, Integer>, JvmTypeReference>(){

            public JvmTypeReference apply(Map.Entry<JvmTypeReference, Integer> from) {
                return from.getKey();
            }
        }));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JvmFeatureDescriptionList {
        private String text;
        private Iterable<JvmFeatureDescription> descriptions;

        public JvmFeatureDescriptionList(String text, Iterable<JvmFeatureDescription> descriptions) {
            this.text = text;
            this.descriptions = descriptions;
        }

        public Iterable<JvmFeatureDescription> getDescriptions() {
            return this.descriptions;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return String.valueOf(this.getText()) + (Iterables.isEmpty(this.getDescriptions()) ? "[EMPTY]" : "");
        }
    }
}

