/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypesSwitch;

public class JvmFeatureSignatureProvider {
    public String getSignature(JvmFeature from, TypeArgumentContext ctx, int numberOfIrrelevantArguments) {
        return (String)this.createSwitch(ctx, numberOfIrrelevantArguments).doSwitch((EObject)from);
    }

    protected Switch createSwitch(TypeArgumentContext context, int numberOfIrrelevantArguments) {
        return new Switch(context, numberOfIrrelevantArguments);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Switch
    extends TypesSwitch<String> {
        private int numberOfIrrelevantArguments;
        private TypeArgumentContext ctx;

        public Switch(TypeArgumentContext ctx, int numberOfIrrelevantArguments) {
            this.numberOfIrrelevantArguments = numberOfIrrelevantArguments;
            this.ctx = ctx;
        }

        public String caseJvmField(JvmField object) {
            return object.getSimpleName();
        }

        public String caseJvmOperation(JvmOperation object) {
            StringBuilder builder = new StringBuilder(32);
            builder.append(object.getSimpleName());
            builder.append("(");
            EList params = object.getParameters();
            int i = this.numberOfIrrelevantArguments;
            while (i < params.size()) {
                JvmTypeReference resolvedParameterType;
                if (i != this.numberOfIrrelevantArguments) {
                    builder.append(",");
                }
                if ((resolvedParameterType = this.ctx.getLowerBound(((JvmFormalParameter)params.get(i)).getParameterType())) != null) {
                    builder.append(resolvedParameterType.getIdentifier());
                } else {
                    builder.append("null");
                }
                ++i;
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

