/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.BasicNodeIterable;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.nodemodel.util.EmptyBidiIterable;
import org.eclipse.xtext.nodemodel.util.NodeIterable;
import org.eclipse.xtext.nodemodel.util.SingletonBidiIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNode
extends AbstractNode
implements ICompositeNode {
    private AbstractNode firstChild;
    private int lookAhead;

    @Override
    public BidiIterable<INode> getChildren() {
        if (this.hasChildren()) {
            INode firstChild = this.getFirstChild();
            if (firstChild.hasSiblings()) {
                return new NodeIterable(firstChild);
            }
            return SingletonBidiIterable.create(firstChild);
        }
        return EmptyBidiIterable.instance();
    }

    public BidiIterable<AbstractNode> basicGetChildren() {
        if (this.firstChild != null) {
            if (this.firstChild.hasSiblings()) {
                return new BasicNodeIterable(this.firstChild);
            }
            return SingletonBidiIterable.create(this.basicGetFirstChild());
        }
        return EmptyBidiIterable.instance();
    }

    @Override
    public boolean hasChildren() {
        return this.firstChild != null || this.isFolded();
    }

    @Override
    public int getLookAhead() {
        return this.lookAhead;
    }

    @Override
    public int getTotalLength() {
        if (this.firstChild != null) {
            int offset = this.firstChild.getTotalOffset();
            AbstractNode lastChild = this.firstChild.basicGetPreviousSibling();
            return lastChild.getTotalOffset() + lastChild.getTotalLength() - offset;
        }
        return 0;
    }

    @Override
    public int getTotalOffset() {
        if (this.firstChild != null) {
            return this.firstChild.getTotalOffset();
        }
        CompositeNode compositeWithSiblings = this;
        while (!compositeWithSiblings.basicHasNextSibling() && compositeWithSiblings.basicGetParent() != null) {
            compositeWithSiblings = compositeWithSiblings.basicGetParent();
        }
        if (compositeWithSiblings.basicHasNextSibling()) {
            AbstractNode sibling = compositeWithSiblings.basicGetNextSibling();
            return sibling.getTotalOffset();
        }
        BidiTreeIterator<INode> iter = this.getRootNode().getAsTreeIterable().iterator();
        INode lastSeen = null;
        while (iter.hasNext()) {
            INode next = iter.next();
            if (next == this) {
                if (lastSeen == null) {
                    return 0;
                }
                return lastSeen.getTotalEndOffset();
            }
            if (!(next instanceof ILeafNode)) continue;
            lastSeen = (ILeafNode)next;
        }
        return 0;
    }

    protected void basicSetLookAhead(int lookAhead) {
        this.lookAhead = lookAhead;
    }

    @Override
    public INode getFirstChild() {
        if (this.isFolded()) {
            return new SyntheticCompositeNode(this, 1);
        }
        return this.firstChild;
    }

    protected AbstractNode basicGetFirstChild() {
        return this.firstChild;
    }

    protected void basicSetFirstChild(AbstractNode firstChild) {
        this.firstChild = firstChild;
    }

    @Override
    public INode getLastChild() {
        if (this.isFolded()) {
            return new SyntheticCompositeNode(this, 1);
        }
        return this.basicGetLastChild();
    }

    protected AbstractNode basicGetLastChild() {
        if (this.firstChild == null) {
            return null;
        }
        return this.firstChild.basicGetPreviousSibling();
    }

    protected boolean isFolded() {
        Object grammarElementOrArray = this.basicGetGrammarElement();
        return this.isFolded(grammarElementOrArray);
    }

    protected boolean isFolded(Object grammarElementOrArray) {
        return grammarElementOrArray != null && !(grammarElementOrArray instanceof EObject);
    }

    public ICompositeNode resolveAsParent() {
        Object grammarElementOrArray = this.basicGetGrammarElement();
        if (!this.isFolded()) {
            return this;
        }
        EObject[] grammarElements = (EObject[])grammarElementOrArray;
        return new SyntheticCompositeNode(this, grammarElements.length - 1);
    }

    @Override
    public EObject getGrammarElement() {
        Object grammarElementOrArray = this.basicGetGrammarElement();
        if (!this.isFolded()) {
            return (EObject)grammarElementOrArray;
        }
        EObject[] grammarElements = (EObject[])grammarElementOrArray;
        return grammarElements[0];
    }
}

