/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.impl.FeatureFinderUtil;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaFactory;
import org.eclipse.xtext.util.formallang.NfaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SemanticSequencerNfaProvider
implements ISemanticSequencerNfaProvider {
    @Inject
    protected ISyntacticSequencerPDAProvider pdaProvider;
    protected Map<Pair<EObject, EClass>, Nfa<ISemanticSequencerNfaProvider.ISemState>> cache = Maps.newHashMap();

    @Override
    public Nfa<ISemanticSequencerNfaProvider.ISemState> getNFA(EObject context, EClass type) {
        Pair key = Tuples.create((Object)context, (Object)type);
        Nfa nfa = this.cache.get(key);
        if (nfa != null) {
            return nfa;
        }
        NfaUtil util = new NfaUtil();
        ISyntacticSequencerPDAProvider.SynAbsorberNfaAdapter synNfa = new ISyntacticSequencerPDAProvider.SynAbsorberNfaAdapter(this.pdaProvider.getPDA(context, type));
        Map distanceMap = util.distanceToFinalStateMap((Nfa)synNfa);
        nfa = util.create(util.sort((Nfa)synNfa, distanceMap), (NfaFactory)new SemStateFactory());
        this.initContentValidationNeeded(type, (Nfa<ISemanticSequencerNfaProvider.ISemState>)nfa);
        this.cache.put((Pair<EObject, EClass>)key, (Nfa<ISemanticSequencerNfaProvider.ISemState>)nfa);
        return nfa;
    }

    protected boolean isContentValidationNeeded(Collection<AbstractElement> ass) {
        if (ass == null || ass.size() < 2) {
            return false;
        }
        Iterator<AbstractElement> it = ass.iterator();
        AbstractElement first = it.next();
        CrossReference firstRef = GrammarUtil.containingCrossReference(first);
        while (it.hasNext()) {
            CrossReference nextRef;
            AbstractElement next = it.next();
            if (next instanceof Action) {
                return true;
            }
            if (!EcoreUtil.equals((EObject)first, (EObject)next)) {
                return true;
            }
            if (firstRef == null || (nextRef = GrammarUtil.containingCrossReference(next)) == null || nextRef.getType().getClassifier() == firstRef.getType().getClassifier()) continue;
            return true;
        }
        return false;
    }

    protected void initContentValidationNeeded(EClass clazz, Nfa<ISemanticSequencerNfaProvider.ISemState> nfa) {
        HashMultimap assignments = HashMultimap.create();
        Set states = new NfaUtil().collect(nfa);
        for (ISemanticSequencerNfaProvider.ISemState state : states) {
            if (state.getFeature() == null) continue;
            assignments.put((Object)state.getFeature(), (Object)state.getAssignedGrammarElement());
        }
        boolean[] validationNeeded = new boolean[clazz.getFeatureCount()];
        for (EStructuralFeature feature : clazz.getEAllStructuralFeatures()) {
            validationNeeded[clazz.getFeatureID((EStructuralFeature)feature)] = this.isContentValidationNeeded(assignments.get((Object)feature));
        }
        for (ISemanticSequencerNfaProvider.ISemState state : states) {
            ((SemState)state).contentValidationNeeded = state.getFeature() != null && validationNeeded[state.getFeatureID()] ? Lists.newArrayList((Iterable)assignments.get((Object)state.getFeature())) : Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SemNfa
    implements Nfa<ISemanticSequencerNfaProvider.ISemState> {
        protected final ISemanticSequencerNfaProvider.ISemState start;
        protected final ISemanticSequencerNfaProvider.ISemState stop;

        public SemNfa(ISemanticSequencerNfaProvider.ISemState starts, ISemanticSequencerNfaProvider.ISemState stops) {
            this.start = starts;
            this.stop = stops;
        }

        public ISemanticSequencerNfaProvider.ISemState getStop() {
            return this.stop;
        }

        public List<ISemanticSequencerNfaProvider.ISemState> getFollowers(ISemanticSequencerNfaProvider.ISemState node) {
            return node.getFollowers();
        }

        public ISemanticSequencerNfaProvider.ISemState getStart() {
            return this.start;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SemState
    implements ISemanticSequencerNfaProvider.ISemState {
        protected AbstractElement assignedGrammarElement;
        protected EStructuralFeature feature;
        protected int featureID = -1;
        protected List<ISemanticSequencerNfaProvider.ISemState> followers;
        protected EClass type;
        protected List<AbstractElement> contentValidationNeeded;

        public SemState(EClass type, AbstractElement assignedGrammarElement) {
            this.type = type;
            this.assignedGrammarElement = assignedGrammarElement;
        }

        @Override
        public AbstractElement getAssignedGrammarElement() {
            return this.assignedGrammarElement;
        }

        @Override
        public EStructuralFeature getFeature() {
            if (this.feature == null && this.assignedGrammarElement != null) {
                this.feature = FeatureFinderUtil.getFeature(this.assignedGrammarElement, this.type);
            }
            return this.feature;
        }

        @Override
        public int getFeatureID() {
            if (this.featureID < 0) {
                this.featureID = this.type.getFeatureID(this.getFeature());
            }
            return this.featureID;
        }

        @Override
        public List<ISemanticSequencerNfaProvider.ISemState> getFollowers() {
            return this.followers == null ? Collections.emptyList() : this.followers;
        }

        @Override
        public List<AbstractElement> getToBeValidatedAssignedElements() {
            return this.contentValidationNeeded;
        }

        public String toString() {
            if (this.assignedGrammarElement == null) {
                return "(null)";
            }
            return new GrammarElementTitleSwitch().showQualified().showAssignments().apply(this.assignedGrammarElement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SemStateFactory
    implements NfaFactory<ISemanticSequencerNfaProvider.ISemState, ISyntacticSequencerPDAProvider.ISynAbsorberState> {
        protected SemStateFactory() {
        }

        public ISemanticSequencerNfaProvider.ISemState createEndState(ISyntacticSequencerPDAProvider.ISynAbsorberState token) {
            return new SemState(token.getEClass(), token.getGrammarElement());
        }

        public Nfa<ISemanticSequencerNfaProvider.ISemState> createNfa(ISemanticSequencerNfaProvider.ISemState startStates, ISemanticSequencerNfaProvider.ISemState stopStates) {
            return new SemNfa(startStates, stopStates);
        }

        public ISemanticSequencerNfaProvider.ISemState createStartState(ISyntacticSequencerPDAProvider.ISynAbsorberState token) {
            return new SemState(token.getEClass(), token.getGrammarElement());
        }

        public ISemanticSequencerNfaProvider.ISemState createState(ISyntacticSequencerPDAProvider.ISynAbsorberState token) {
            return new SemState(token.getEClass(), token.getGrammarElement());
        }

        public void setFollowers(ISemanticSequencerNfaProvider.ISemState owner, Iterable<ISemanticSequencerNfaProvider.ISemState> followers) {
            ((SemState)owner).followers = Lists.newArrayList(followers);
        }
    }
}

