/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.tasks;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.tasks.ITaskTagProvider;
import org.eclipse.xtext.tasks.Priority;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.tasks.TaskTags;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceTaskTagProvider
implements ITaskTagProvider {
    public static final PreferenceKey TAGS_KEY = new PreferenceKey("task.tags", "TODO,FIXME,XXX");
    public static final PreferenceKey PRIORITIES_KEY = new PreferenceKey("task.priorities", "NORMAL,HIGH,NORMAL");
    public static final PreferenceKey CASE_SENSITIVE_KEY = new PreferenceKey("task.caseSensitive", "true");
    public static final List<PreferenceKey> KEYS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new PreferenceKey[]{TAGS_KEY, PRIORITIES_KEY, CASE_SENSITIVE_KEY}));
    private IPreferenceValuesProvider preferenceValuesProvider;

    public static List<TaskTag> parseTags(String names, String priorities) {
        Splitter _on = Splitter.on((String)",");
        Splitter _omitEmptyStrings = _on.omitEmptyStrings();
        Splitter splitter = _omitEmptyStrings.trimResults();
        Iterable _split = splitter.split((CharSequence)names);
        final List tags = IterableExtensions.toList((Iterable)_split);
        Iterable _split_1 = splitter.split((CharSequence)priorities);
        final List prios = IterableExtensions.toList((Iterable)_split_1);
        ArrayList elements = CollectionLiterals.newArrayList((Object[])new TaskTag[0]);
        int _size = tags.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (final Integer i : _doubleDotLessThan) {
            TaskTag _taskTag = new TaskTag();
            Procedures.Procedure1<TaskTag> _function = new Procedures.Procedure1<TaskTag>(){

                public void apply(TaskTag it) {
                    boolean _greaterEqualsThan;
                    String _get = (String)tags.get(i);
                    it.setName(_get);
                    Priority _xifexpression = null;
                    int _size = prios.size();
                    boolean bl = _greaterEqualsThan = _size >= i;
                    if (_greaterEqualsThan) {
                        Priority _xtrycatchfinallyexpression = null;
                        try {
                            String _get_1 = (String)prios.get(i);
                            _xtrycatchfinallyexpression = Priority.valueOf(_get_1);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof IllegalArgumentException) {
                                IllegalArgumentException e = (IllegalArgumentException)_t;
                                _xtrycatchfinallyexpression = Priority.NORMAL;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        _xifexpression = _xtrycatchfinallyexpression;
                    } else {
                        _xifexpression = Priority.NORMAL;
                    }
                    it.setPriority(_xifexpression);
                }
            };
            TaskTag _doubleArrow = (TaskTag)ObjectExtensions.operator_doubleArrow((Object)_taskTag, (Procedures.Procedure1)_function);
            elements.add(_doubleArrow);
        }
        return elements;
    }

    public static String serializeTags(List<TaskTag> tags) {
        Joiner _on = Joiner.on((String)",");
        Functions.Function1<TaskTag, String> _function = new Functions.Function1<TaskTag, String>(){

            public String apply(TaskTag it) {
                return it.getName();
            }
        };
        List _map = ListExtensions.map(tags, (Functions.Function1)_function);
        return _on.join((Iterable)_map);
    }

    public static String serializePriorities(List<TaskTag> tags) {
        Joiner _on = Joiner.on((String)",");
        Functions.Function1<TaskTag, Priority> _function = new Functions.Function1<TaskTag, Priority>(){

            public Priority apply(TaskTag it) {
                return it.getPriority();
            }
        };
        List _map = ListExtensions.map(tags, (Functions.Function1)_function);
        return _on.join((Iterable)_map);
    }

    @Override
    public TaskTags getTaskTags(Resource resource) {
        TaskTags _xblockexpression = null;
        final IPreferenceValues prefs = this.preferenceValuesProvider.getPreferenceValues(resource);
        final String names = prefs.getPreference(TAGS_KEY);
        final String priorities = prefs.getPreference(PRIORITIES_KEY);
        TaskTags _taskTags = new TaskTags();
        Procedures.Procedure1<TaskTags> _function = new Procedures.Procedure1<TaskTags>(){

            public void apply(TaskTags it) {
                String _preference = prefs.getPreference(CASE_SENSITIVE_KEY);
                Boolean _valueOf = Boolean.valueOf(_preference);
                it.setCaseSensitive(_valueOf);
                List<TaskTag> _taskTags = it.getTaskTags();
                List<TaskTag> _parseTags = PreferenceTaskTagProvider.parseTags(names, priorities);
                Iterables.addAll(_taskTags, _parseTags);
            }
        };
        _xblockexpression = (TaskTags)ObjectExtensions.operator_doubleArrow((Object)_taskTags, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    @Inject
    public void setPreferenceValuesProvider(IPreferenceValuesProvider preferenceValuesProvider) {
        this.preferenceValuesProvider = preferenceValuesProvider;
    }
}

