/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.builder.trace.AbstractTrace;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

public abstract class AbstractLocationInResource
implements ILocationInResource {
    private final AbstractTrace trace;
    private URI eObjectURI;
    private boolean triedToComputeURI;

    protected AbstractLocationInResource(AbstractTrace trace) {
        this.trace = trace;
    }

    public abstract URI getResourceURI();

    protected abstract String getProjectName();

    protected abstract int getOffset();

    protected abstract int getLength();

    protected abstract int getLineNumber();

    protected abstract int getEndLineNumber();

    @NonNull
    public IStorage getStorage() {
        IStorage result = this.trace.findStorage(this.getResourceURI(), this.getProject());
        return result;
    }

    public ITextRegionWithLineInformation getTextRegion() {
        TextRegionWithLineInformation result = new TextRegionWithLineInformation(this.getOffset(), this.getLength(), this.getLineNumber(), this.getEndLineNumber());
        return result;
    }

    @NonNull
    public IProject getProject() {
        return this.trace.findProject(this.getProjectName());
    }

    public LanguageInfo getLanguage() {
        LanguageInfo result = this.trace.findLanguage(this.getResourceURI());
        return result;
    }

    public URI getEObjectURI() {
        if (this.eObjectURI == null && !this.triedToComputeURI) {
            IParseResult parseResult;
            Resource resource = this.trace.getResource(this.getResourceURI(), this.getProject());
            if (resource instanceof XtextResource && (parseResult = ((XtextResource)resource).getParseResult()) != null) {
                ICompositeNode rootNode = parseResult.getRootNode();
                int end = this.getOffset() + this.getLength();
                ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)this.getOffset());
                while (node != null) {
                    EObject object;
                    if (node.getTotalEndOffset() >= end && (object = NodeModelUtils.findActualSemanticObjectFor((INode)node)) != null) {
                        URI result;
                        this.eObjectURI = result = EcoreUtil.getURI((EObject)object);
                        this.triedToComputeURI = true;
                        return result;
                    }
                    node = node.getParent();
                }
            }
            this.triedToComputeURI = true;
        }
        return this.eObjectURI;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " @ " + this.getTextRegion();
    }
}

