/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;

public abstract class AbstractDpiConverter
implements IDpiConverter {
    protected int dpi = -1;
    protected float scaleFactor = -1.0f;

    protected abstract void readDpiFromDisplay();

    @Override
    public int getDpi() {
        if (this.dpi < 0) {
            this.readDpiFromDisplay();
            this.scaleFactor = GUIHelper.getDpiFactor(this.getDpi());
        }
        return this.dpi;
    }

    @Override
    public float getCurrentDpiFactor() {
        if (this.scaleFactor < 0.0f) {
            this.scaleFactor = GUIHelper.getDpiFactor(this.getDpi());
        }
        return this.scaleFactor;
    }

    @Override
    public int convertPixelToDpi(int pixel) {
        if (this.getCurrentDpiFactor() == 1.0f) {
            return pixel;
        }
        return Math.round((float)pixel * this.scaleFactor);
    }

    @Override
    public int convertDpiToPixel(int dpi) {
        if (this.getCurrentDpiFactor() == 1.0f) {
            return dpi;
        }
        return Math.round((float)dpi / this.scaleFactor);
    }
}

