/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.questionnaire;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.questionnaire.GearShell;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.Pair;
import org.eclipse.swt.widgets.Shell;

public final class QuestionnairePlugin
extends OomphUIPlugin {
    public static final QuestionnairePlugin INSTANCE = new QuestionnairePlugin();
    public static final String PLUGIN_ID = INSTANCE.getSymbolicName();
    private static Implementation plugin;

    public QuestionnairePlugin() {
        super(new ResourceLocator[]{SetupUIPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static void performQuestionnaire(final Shell parentShell, boolean force) {
        RecorderTransaction transaction = RecorderTransaction.open();
        try {
            User user;
            SetupTaskContainer rootObject = transaction.getRootObject();
            if (rootObject instanceof User && ((user = (User)rootObject).getQuestionnaireDate() == null || force)) {
                final HashMap preferences = new HashMap();
                UIUtil.syncExec((Runnable)new Runnable(){

                    public void run() {
                        GearShell shell = new GearShell(parentShell);
                        Map result = (Map)shell.openModal();
                        if (result != null) {
                            preferences.putAll(result);
                        }
                    }
                });
                URI uri = PreferencesFactory.eINSTANCE.createURI("RECORDER_PREFERENCE_KEY");
                if (preferences.containsKey(uri)) {
                    boolean enabled = Boolean.parseBoolean((String)((Pair)preferences.remove(uri)).getElement2());
                    user.setPreferenceRecorderDefault(enabled);
                }
                if (!preferences.isEmpty()) {
                    for (Map.Entry entry : preferences.entrySet()) {
                        String path = PreferencesFactory.eINSTANCE.convertURI((URI)entry.getKey());
                        transaction.setPolicy(path, true);
                        if (SetupUtil.INSTALLER_APPLICATION) continue;
                        PreferencesUtil.PreferenceProperty property = new PreferencesUtil.PreferenceProperty(path);
                        property.set((String)((Pair)entry.getValue()).getElement2());
                    }
                    transaction.setPreferences(preferences);
                }
                user.setQuestionnaireDate(new Date());
                transaction.setForceDirty(true);
                transaction.commit();
            }
        }
        finally {
            transaction.close();
        }
    }

    public static class Implementation
    extends EclipseUIPlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

