/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.ProfileLock;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.engine.SurrogateProfileHandler;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.oomph.p2.internal.core.LazyProfile;
import org.eclipse.oomph.p2.internal.core.Messages;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class LazyProfileRegistry
extends SimpleProfileRegistry {
    private static final String PROFILE_EXT = ".profile";
    private static final String PROFILE_GZ_EXT = ".profile.gz";
    private final Class<?> parserClass;
    private final Constructor<?> parserConstructor;
    private final Method parseMethod;
    private final Method addProfilePlaceHolderMethod;
    private final Method getProfileMapMethod;
    private final Method updateSelfProfileMethod;
    private final IProvisioningAgent provisioningAgent;
    private final File store;
    final String self;
    private final boolean canWrite;
    private boolean updateSelfProfile;
    private final Map<String, ProfileLock> profileLocks;
    private Map<String, Profile> profileMap;

    public LazyProfileRegistry(IProvisioningAgent provisioningAgent, File store, boolean updateSelfProfile) throws Exception {
        super(provisioningAgent, store, (ISurrogateProfileHandler)(updateSelfProfile ? new AdjustingSurrogateProfileHandler(provisioningAgent) : null), updateSelfProfile);
        this.provisioningAgent = provisioningAgent;
        this.store = store;
        this.canWrite = IOUtil.canWriteFolder((File)store);
        Field selfField = ReflectUtil.getField(SimpleProfileRegistry.class, (String)"self");
        this.self = (String)ReflectUtil.getValue((Field)selfField, (Object)((Object)this));
        this.updateSelfProfile = updateSelfProfile;
        Field profileLocksField = ReflectUtil.getField(SimpleProfileRegistry.class, (String)"profileLocks");
        this.profileLocks = (Map)ReflectUtil.getValue((Field)profileLocksField, (Object)((Object)this));
        try {
            this.parserClass = CommonPlugin.loadClass((String)"org.eclipse.equinox.p2.engine", (String)"org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry$Parser");
            this.parserConstructor = ReflectUtil.getConstructor(this.parserClass, (Class[])new Class[]{SimpleProfileRegistry.class, BundleContext.class, String.class});
            this.parseMethod = ReflectUtil.getMethod(this.parserClass, (String)"parse", (Class[])new Class[]{File.class});
            this.addProfilePlaceHolderMethod = ReflectUtil.getMethod(this.parserClass, (String)"addProfilePlaceHolder", (Class[])new Class[]{String.class});
            this.getProfileMapMethod = ReflectUtil.getMethod(this.parserClass, (String)"getProfileMap", (Class[])new Class[0]);
            this.updateSelfProfileMethod = ReflectUtil.getMethod(SimpleProfileRegistry.class, (String)"updateSelfProfile", (Class[])new Class[]{Map.class});
        }
        catch (Throwable ex) {
            throw new Exception(Messages.LazyProfileRegistry_P2InternalsChanged_exception, ex);
        }
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.provisioningAgent;
    }

    public synchronized void resetProfiles() {
        this.profileMap = null;
    }

    public synchronized IProfile[] getProfiles() {
        return this.getProfiles((IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized IProfile[] getProfiles(IProgressMonitor monitor) {
        Map<String, Profile> profileMap = this.getProfileMap();
        int size = profileMap.size();
        monitor.beginTask("", size);
        try {
            ArrayList<Profile> result = new ArrayList<Profile>(size);
            for (Profile profile : profileMap.values()) {
                monitor.subTask(NLS.bind((String)Messages.LazyProfileRegistry_Loading_task, (Object)profile.getProfileId()));
                try {
                    Profile snapshot = profile.snapshot();
                    result.add(snapshot);
                }
                catch (RuntimeException ex) {
                    P2CorePlugin.INSTANCE.log(ex, ex instanceof IORuntimeException ? 2 : 4);
                }
                monitor.worked(1);
            }
            IProfile[] iProfileArray = (IProfile[])result.toArray(new Profile[result.size()]);
            return iProfileArray;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void removeProfile(String id, long timestamp) throws ProvisionException {
        IProfile profile;
        LazyProfile lazyProfile;
        Profile p;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if ((p = this.getProfileMap().get(id)) instanceof LazyProfile && (lazyProfile = (LazyProfile)p).getDelegate(false) != null && (profile = this.getProfile(id)) != null && profile.getTimestamp() == timestamp) {
            throw new ProvisionException(Messages.LazyProfileRegistry_CannotRemoveCurrentProfile_exception);
        }
        super.removeProfile(id, timestamp);
    }

    public synchronized boolean containsProfile(String id) {
        LazyProfile lazyProfile;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if (id == null) {
            return false;
        }
        Profile p = this.getProfileMap().get(id);
        if (p instanceof LazyProfile && (lazyProfile = (LazyProfile)p).getDelegate(false) != null && this.getProfile(id) != null) {
            return true;
        }
        return super.containsProfile(id);
    }

    protected final synchronized Map<String, Profile> getProfileMap() {
        return this.getProfileMap((IProgressMonitor)new NullProgressMonitor());
    }

    public final synchronized Map<String, Profile> getProfileMap(IProgressMonitor monitor) {
        if (this.profileMap == null) {
            if (this.store == null || !this.store.isDirectory()) {
                throw new IllegalStateException(NLS.bind((String)Messages.LazyProfileRegistry_RegistryDirectoryNotAvailable_exception, (Object)this.store));
            }
            this.profileMap = new HashMap<String, Profile>();
            File[] profileDirectories = this.store.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(LazyProfileRegistry.PROFILE_EXT) && pathname.isDirectory();
                }
            });
            if (profileDirectories == null) {
                profileDirectories = new File[]{};
            }
            monitor.beginTask("", profileDirectories.length);
            try {
                File[] fileArray = profileDirectories;
                int n = profileDirectories.length;
                int n2 = 0;
                while (n2 < n) {
                    File profileDirectory = fileArray[n2];
                    P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                    File profileFile = LazyProfileRegistry.findLatestProfileFile(profileDirectory);
                    if (profileFile == null) {
                        monitor.subTask(NLS.bind((String)Messages.LazyProfileRegistry_Deleting_task, (Object)profileDirectory));
                        IOUtil.deleteBestEffort((File)profileFile);
                    } else {
                        String directoryName = profileDirectory.getName();
                        String profileId = LazyProfileRegistry.unescape((String)directoryName.substring(0, directoryName.lastIndexOf(PROFILE_EXT)));
                        monitor.subTask(NLS.bind((String)Messages.LazyProfileRegistry_Registering_task, (Object)profileId));
                        LazyProfile profile = new LazyProfile(this, profileId, profileDirectory);
                        this.profileMap.put(profileId, profile);
                    }
                    monitor.worked(1);
                    ++n2;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (this.updateSelfProfile) {
            ReflectUtil.invokeMethod((Method)this.updateSelfProfileMethod, (Object)((Object)this), (Object[])new Object[]{this.profileMap});
            this.updateSelfProfile = false;
        }
        return this.profileMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Profile loadProfile(String profileId, File profileDirectory) {
        if (this.store == null || !this.store.isDirectory()) {
            throw new IllegalStateException(NLS.bind((String)Messages.LazyProfileRegistry_RegistryDirectoryNotAvailable_exception, (Object)this.store));
        }
        try {
            Object parser;
            block13: {
                parser = ReflectUtil.newInstance(this.parserConstructor, (Object[])new Object[]{this, EngineActivator.getContext(), "org.eclipse.equinox.p2.engine"});
                ProfileLock lock = this.profileLocks.get(profileId);
                if (lock == null && this.canWrite) {
                    lock = new ProfileLock((Object)this, profileDirectory);
                    this.profileLocks.put(profileId, lock);
                }
                boolean locked = false;
                if (lock == null || lock.processHoldsLock() || (locked = lock.lock())) {
                    try {
                        File profileFile = LazyProfileRegistry.findLatestProfileFile(profileDirectory);
                        if (profileFile == null) break block13;
                        try {
                            ReflectUtil.invokeMethod((Method)this.parseMethod, (Object)parser, (Object[])new Object[]{profileFile});
                            break block13;
                        }
                        catch (ReflectUtil.ReflectionException ex) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof IOException) {
                                long length = profileFile.length();
                                throw new IORuntimeException(NLS.bind((String)Messages.LazyProfileRegistry_LoadFailure_exception, (Object)profileFile, (Object)length), cause);
                            }
                            throw ex;
                        }
                    }
                    finally {
                        if (locked) {
                            lock.unlock();
                        }
                    }
                }
                ReflectUtil.invokeMethod((Method)this.addProfilePlaceHolderMethod, (Object)parser, (Object[])new Object[]{profileId});
            }
            Map profileMap = (Map)ReflectUtil.invokeMethod((Method)this.getProfileMapMethod, (Object)parser, (Object[])new Object[0]);
            return (Profile)profileMap.get(profileId);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void updateProfile(Profile profile) {
        String id = profile.getProfileId();
        Profile current = this.getProfileMap().get(id);
        if (current instanceof LazyProfile) {
            current = ((LazyProfile)current).getDelegate(true);
        }
        super.updateProfile(profile);
    }

    public static File findLatestProfileFile(File profileDirectory) {
        File latest = null;
        long latestTimestamp = 0L;
        File[] profileFiles = profileDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return (pathname.getName().endsWith(LazyProfileRegistry.PROFILE_GZ_EXT) || pathname.getName().endsWith(LazyProfileRegistry.PROFILE_EXT)) && !pathname.isDirectory();
            }
        });
        if (profileFiles == null) {
            return null;
        }
        int i = 0;
        while (i < profileFiles.length) {
            File profileFile = profileFiles[i];
            String fileName = profileFile.getName();
            try {
                long timestamp = Long.parseLong(fileName.substring(0, fileName.indexOf(PROFILE_EXT)));
                if (timestamp > latestTimestamp) {
                    latestTimestamp = timestamp;
                    latest = profileFile;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return latest;
    }

    private static class AdjustingSurrogateProfileHandler
    extends SurrogateProfileHandler {
        public AdjustingSurrogateProfileHandler(IProvisioningAgent provisioningAgent) {
            super(provisioningAgent);
            IProfileRegistry profileRegistry;
            IProvisioningAgent baseAgent = (IProvisioningAgent)provisioningAgent.getService("org.eclipse.equinox.shared.base.agent");
            if (baseAgent != null && (profileRegistry = (IProfileRegistry)baseAgent.getService(IProfileRegistry.SERVICE_NAME)) != null) {
                ReflectUtil.setValue((String)"profileRegistry", (Object)((Object)this), (Object)profileRegistry);
            }
        }

        public IProfile createProfile(String id) {
            String cache;
            IProfile sharedProfile;
            SoftReference sharedProfileReference;
            IProfile profile = super.createProfile(id);
            if (profile != null && "true".equals(profile.getProperty("org.eclipse.oomph.p2.profile.shared.pool")) && (sharedProfileReference = (SoftReference)ReflectUtil.getValue((String)"cachedProfile", (Object)((Object)this))) != null && (sharedProfile = (IProfile)sharedProfileReference.get()) != null && (cache = sharedProfile.getProperty("org.eclipse.equinox.p2.cache")) != null) {
                ((Profile)profile).setProperty("org.eclipse.equinox.p2.cache.shared", cache);
            }
            return profile;
        }
    }
}

