/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.e4.ui.progress.internal.AnimationItem;
import org.eclipse.e4.ui.progress.internal.GroupInfo;
import org.eclipse.e4.ui.progress.internal.IAnimationProcessor;
import org.eclipse.e4.ui.progress.internal.IJobProgressManagerListener;
import org.eclipse.e4.ui.progress.internal.JobInfo;
import org.eclipse.e4.ui.progress.internal.ProgressAnimationProcessor;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

@Creatable
@Singleton
public class AnimationManager {
    boolean animated = false;
    private IJobProgressManagerListener listener;
    IAnimationProcessor animationProcessor;
    Job animationUpdateJob;
    @Inject
    ProgressManager progressManager;

    static Color getItemBackgroundColor(Control control) {
        return control.getDisplay().getSystemColor(29);
    }

    @PostConstruct
    void init() {
        this.animationProcessor = new ProgressAnimationProcessor(this);
        this.animationUpdateJob = new UIJob(ProgressMessages.AnimationManager_AnimationStart){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (AnimationManager.this.animated) {
                    AnimationManager.this.animationProcessor.animationStarted();
                } else {
                    AnimationManager.this.animationProcessor.animationFinished();
                }
                return Status.OK_STATUS;
            }
        };
        this.animationUpdateJob.setSystem(true);
        this.listener = this.getProgressListener();
        this.progressManager.addListener(this.listener);
    }

    void addItem(AnimationItem item) {
        this.animationProcessor.addItem(item);
    }

    void removeItem(AnimationItem item) {
        this.animationProcessor.removeItem(item);
    }

    boolean isAnimated() {
        return this.animated;
    }

    void setAnimated(boolean bool) {
        this.animated = bool;
        this.animationUpdateJob.schedule(100L);
    }

    @PreDestroy
    void dispose() {
        this.setAnimated(false);
        this.progressManager.removeListener(this.listener);
    }

    private IJobProgressManagerListener getProgressListener() {
        return new IJobProgressManagerListener(){
            Set<Job> jobs = Collections.synchronizedSet(new HashSet());

            @Override
            public void addJob(JobInfo info) {
                this.incrementJobCount(info);
            }

            @Override
            public void refreshJobInfo(JobInfo info) {
                int state = info.getJob().getState();
                if (state == 4) {
                    this.addJob(info);
                } else {
                    this.removeJob(info);
                }
            }

            @Override
            public void refreshAll() {
                JobInfo[] currentInfos;
                this.jobs.clear();
                AnimationManager.this.setAnimated(false);
                JobInfo[] jobInfoArray = currentInfos = AnimationManager.this.progressManager.getJobInfos(this.showsDebug());
                int n = currentInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    JobInfo currentInfo = jobInfoArray[n2];
                    this.addJob(currentInfo);
                    ++n2;
                }
            }

            @Override
            public void removeJob(JobInfo info) {
                this.decrementJobCount(info.getJob());
            }

            @Override
            public boolean showsDebug() {
                return false;
            }

            private void incrementJobCount(JobInfo info) {
                if (this.isNotTracked(info)) {
                    return;
                }
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(true);
                }
                this.jobs.add(info.getJob());
            }

            private void decrementJobCount(Job job) {
                this.jobs.remove(job);
                if (this.jobs.isEmpty()) {
                    AnimationManager.this.setAnimated(false);
                }
            }

            private boolean isNotTracked(JobInfo info) {
                Job job = info.getJob();
                return job.getState() != 4 || AnimationManager.this.animationProcessor.isProcessorJob(job);
            }

            @Override
            public void addGroup(GroupInfo info) {
            }

            @Override
            public void removeGroup(GroupInfo group) {
            }

            @Override
            public void refreshGroup(GroupInfo info) {
            }
        };
    }

    int getPreferredWidth() {
        return this.animationProcessor.getPreferredWidth();
    }
}

